/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorHelper;
import org.apache.camel.component.zookeeper.cloud.MetaData;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServiceDiscovery
extends DefaultServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperServiceDiscovery.class);
    private final ZooKeeperCuratorConfiguration configuration;
    private final boolean managedInstance;
    private CuratorFramework curator;
    private ServiceDiscovery<MetaData> serviceDiscovery;

    public ZooKeeperServiceDiscovery(ZooKeeperCuratorConfiguration configuration) {
        this.configuration = configuration;
        this.curator = configuration.getCuratorFramework();
        this.managedInstance = Objects.isNull(this.curator);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.curator == null) {
            ObjectHelper.notNull(this.getCamelContext(), "Camel Context");
            ObjectHelper.notNull(this.configuration.getBasePath(), "ZooKeeper base path");
            LOGGER.debug("Starting ZooKeeper Curator with namespace '{}',  nodes: '{}'", (Object)this.configuration.getNamespace(), (Object)String.join((CharSequence)",", this.configuration.getNodes()));
            this.curator = ZooKeeperCuratorHelper.createCurator(this.configuration);
            this.curator.start();
        }
        if (this.serviceDiscovery == null) {
            ObjectHelper.notNull(this.configuration.getBasePath(), "ZooKeeper base path");
            LOGGER.debug("Starting ZooKeeper ServiceDiscoveryBuilder with base path '{}'", (Object)this.configuration.getBasePath());
            this.serviceDiscovery = ZooKeeperCuratorHelper.createServiceDiscovery(this.configuration, this.curator, MetaData.class);
            this.serviceDiscovery.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.serviceDiscovery != null) {
            try {
                this.serviceDiscovery.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing Curator ServiceDiscovery", (Throwable)e);
            }
        }
        if (this.curator != null && this.managedInstance) {
            this.curator.close();
        }
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        if (this.serviceDiscovery == null) {
            return Collections.emptyList();
        }
        try {
            return this.serviceDiscovery.queryForInstances(name).stream().map(si -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                ObjectHelper.ifNotEmpty((MetaData)si.getPayload(), meta::putAll);
                meta.putIfAbsent("service.name", si.getName());
                meta.putIfAbsent("service.id", si.getId());
                return new DefaultServiceDefinition(si.getName(), si.getAddress(), (int)(si.getSslPort() != null ? si.getSslPort() : si.getPort()), meta);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }
}

