/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cloud;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.component.zookeeper.cloud.ZooKeeperServiceDiscovery;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.CloudServiceFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;

@CloudServiceFactory(value="zookeeper-service-discovery")
@Configurer
public class ZooKeeperServiceDiscoveryFactory
implements ServiceDiscoveryFactory {
    private ZooKeeperCuratorConfiguration configuration;

    public ZooKeeperServiceDiscoveryFactory() {
        this.configuration = new ZooKeeperCuratorConfiguration();
    }

    public ZooKeeperServiceDiscoveryFactory(ZooKeeperCuratorConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public ZooKeeperCuratorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ZooKeeperCuratorConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public CuratorFramework getCuratorFramework() {
        return this.configuration.getCuratorFramework();
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.configuration.setCuratorFramework(curatorFramework);
    }

    public List<String> getNodes() {
        return this.configuration.getNodes();
    }

    public void setNodes(String nodes) {
        this.configuration.setNodes(nodes);
    }

    @Metadata(skip=true)
    public void setNodes(List<String> nodes) {
        this.configuration.setNodes(nodes);
    }

    public String getNamespace() {
        return this.configuration.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.configuration.setNamespace(namespace);
    }

    public long getReconnectBaseSleepTime() {
        return this.configuration.getReconnectBaseSleepTime();
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime) {
        this.configuration.setReconnectBaseSleepTime(reconnectBaseSleepTime);
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectBaseSleepTime(reconnectBaseSleepTime, reconnectBaseSleepTimeUnit);
    }

    public TimeUnit getReconnectBaseSleepTimeUnit() {
        return this.configuration.getReconnectBaseSleepTimeUnit();
    }

    public void setReconnectBaseSleepTimeUnit(TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectBaseSleepTimeUnit(reconnectBaseSleepTimeUnit);
    }

    public long getReconnectMaxSleepTime() {
        return this.configuration.getReconnectMaxSleepTime();
    }

    public void setReconnectMaxSleepTime(long reconnectMaxSleepTime) {
        this.configuration.setReconnectMaxSleepTime(reconnectMaxSleepTime);
    }

    public void setReconnectMaxSleepTime(long reconnectMaxSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectMaxSleepTime(reconnectMaxSleepTime, reconnectBaseSleepTimeUnit);
    }

    public TimeUnit getReconnectMaxSleepTimeUnit() {
        return this.configuration.getReconnectMaxSleepTimeUnit();
    }

    public void setReconnectMaxSleepTimeUnit(TimeUnit reconnectMaxSleepTimeUnit) {
        this.configuration.setReconnectMaxSleepTimeUnit(reconnectMaxSleepTimeUnit);
    }

    public int getReconnectMaxRetries() {
        return this.configuration.getReconnectMaxRetries();
    }

    public void setReconnectMaxRetries(int reconnectMaxRetries) {
        this.configuration.setReconnectMaxRetries(reconnectMaxRetries);
    }

    public long getSessionTimeout() {
        return this.configuration.getSessionTimeout();
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.configuration.setSessionTimeout(sessionTimeout);
    }

    public void setSessionTimeout(long sessionTimeout, TimeUnit sessionTimeoutUnit) {
        this.configuration.setSessionTimeout(sessionTimeout, sessionTimeoutUnit);
    }

    public TimeUnit getSessionTimeoutUnit() {
        return this.configuration.getSessionTimeoutUnit();
    }

    public void setSessionTimeoutUnit(TimeUnit sessionTimeoutUnit) {
        this.configuration.setSessionTimeoutUnit(sessionTimeoutUnit);
    }

    public long getConnectionTimeout() {
        return this.configuration.getConnectionTimeout();
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.configuration.setConnectionTimeout(connectionTimeout);
    }

    public void setConnectionTimeout(long connectionTimeout, TimeUnit connectionTimeotUnit) {
        this.configuration.setConnectionTimeout(connectionTimeout, connectionTimeotUnit);
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.configuration.getConnectionTimeoutUnit();
    }

    public void setConnectionTimeoutUnit(TimeUnit connectionTimeoutUnit) {
        this.configuration.setConnectionTimeoutUnit(connectionTimeoutUnit);
    }

    public List<AuthInfo> getAuthInfoList() {
        return this.configuration.getAuthInfoList();
    }

    public void setAuthInfoList(List<AuthInfo> authInfoList) {
        this.configuration.setAuthInfoList(authInfoList);
    }

    public long getMaxCloseWait() {
        return this.configuration.getMaxCloseWait();
    }

    public void setMaxCloseWait(long maxCloseWait) {
        this.configuration.setMaxCloseWait(maxCloseWait);
    }

    public TimeUnit getMaxCloseWaitUnit() {
        return this.configuration.getMaxCloseWaitUnit();
    }

    public void setMaxCloseWaitUnit(TimeUnit maxCloseWaitUnit) {
        this.configuration.setMaxCloseWaitUnit(maxCloseWaitUnit);
    }

    public RetryPolicy getRetryPolicy() {
        return this.configuration.getRetryPolicy();
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.configuration.setRetryPolicy(retryPolicy);
    }

    public String getBasePath() {
        return this.configuration.getBasePath();
    }

    public void setBasePath(String basePath) {
        this.configuration.setBasePath(basePath);
    }

    @Override
    public ServiceDiscovery newInstance(CamelContext context) throws Exception {
        ZooKeeperServiceDiscovery discovery = new ZooKeeperServiceDiscovery(this.configuration);
        discovery.setCamelContext(context);
        return discovery;
    }
}

