/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperConnectionManager;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.component.zookeeper.ZooKeeperMessage;
import org.apache.camel.component.zookeeper.ZooKeeperUtils;
import org.apache.camel.component.zookeeper.operations.CreateOperation;
import org.apache.camel.component.zookeeper.operations.DeleteOperation;
import org.apache.camel.component.zookeeper.operations.GetChildrenOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.SetDataOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperProducer
extends DefaultProducer {
    public static final String ZK_OPERATION_WRITE = "WRITE";
    public static final String ZK_OPERATION_DELETE = "DELETE";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperProducer.class);
    private final ZooKeeperConfiguration configuration;
    private ZooKeeperConnectionManager zkm;
    private ZooKeeper connection;

    public ZooKeeperProducer(ZooKeeperEndpoint endpoint) {
        super(endpoint);
        this.configuration = endpoint.getConfiguration();
        this.zkm = endpoint.getConnectionManager();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.connection == null) {
            this.connection = this.zkm.getConnection();
        }
        ProductionContext context = new ProductionContext(this.connection, exchange);
        String operation = exchange.getIn().getHeader("CamelZookeeperOperation", String.class);
        boolean isDelete = ZK_OPERATION_DELETE.equals(operation);
        if (ExchangeHelper.isOutCapable(exchange)) {
            if (isDelete) {
                LOG.debug("Deleting znode '{}', waiting for confirmation", (Object)context.node);
                OperationResult result = this.synchronouslyDelete(context);
                if (this.configuration.isListChildren()) {
                    result = this.listChildren(context);
                }
                this.updateExchangeWithResult(context, result);
            } else {
                LOG.debug("Storing data to znode '{}', waiting for confirmation", (Object)context.node);
                OperationResult result = this.synchronouslySetData(context);
                if (this.configuration.isListChildren()) {
                    result = this.listChildren(context);
                }
                this.updateExchangeWithResult(context, result);
            }
        } else if (isDelete) {
            this.asynchronouslyDeleteNode(this.connection, context);
        } else {
            this.asynchronouslySetDataOnNode(this.connection, context);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.connection = this.zkm.getConnection();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting zookeeper producer of '{}'", (Object)this.configuration.getPath());
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Shutting down zookeeper producer of '{}'", (Object)this.configuration.getPath());
        }
        this.zkm.shutdown();
    }

    private void asynchronouslyDeleteNode(ZooKeeper connection, ProductionContext context) {
        LOG.debug("Deleting node '{}', not waiting for confirmation", (Object)context.node);
        connection.delete(context.node, context.version, new AsyncDeleteCallback(), context);
    }

    private void asynchronouslySetDataOnNode(ZooKeeper connection, ProductionContext context) {
        LOG.debug("Storing data to node '{}', not waiting for confirmation", (Object)context.node);
        connection.setData(context.node, context.payload, context.version, new AsyncSetDataCallback(), context);
    }

    private void updateExchangeWithResult(ProductionContext context, OperationResult result) {
        ZooKeeperMessage out = new ZooKeeperMessage(this.getEndpoint().getCamelContext(), context.node, result.getStatistics(), context.in.getHeaders());
        if (result.isOk()) {
            out.setBody(result.getResult());
        } else {
            context.exchange.setException(result.getException());
        }
        context.exchange.setMessage(out);
    }

    private OperationResult listChildren(ProductionContext context) throws Exception {
        return new GetChildrenOperation(context.connection, this.configuration.getPath()).get();
    }

    private OperationResult<String> createNode(ProductionContext ctx) throws Exception {
        CreateOperation create = new CreateOperation(ctx.connection, ctx.node);
        create.setPermissions(ZooKeeperUtils.getAclListFromMessage(ctx.exchange.getIn()));
        CreateMode mode = null;
        String modeString = this.configuration.getCreateMode();
        if (modeString != null) {
            try {
                mode = ZooKeeperUtils.getCreateModeFromString(modeString, CreateMode.EPHEMERAL);
            }
            catch (Exception exception) {}
        } else {
            mode = ZooKeeperUtils.getCreateMode(ctx.exchange.getIn(), CreateMode.EPHEMERAL);
        }
        create.setCreateMode(mode == null ? CreateMode.EPHEMERAL : mode);
        create.setData(ctx.payload);
        return create.get();
    }

    private OperationResult synchronouslySetData(ProductionContext ctx) throws Exception {
        SetDataOperation setData = new SetDataOperation(ctx.connection, ctx.node, ctx.payload);
        setData.setVersion(ctx.version);
        OperationResult<Object> result = setData.get();
        if (!result.isOk() && this.configuration.isCreate() && result.failedDueTo(KeeperException.Code.NONODE)) {
            LOG.warn("Node '{}' did not exist, creating it.", (Object)ctx.node);
            result = this.createNode(ctx);
        }
        return result;
    }

    private OperationResult synchronouslyDelete(ProductionContext ctx) throws Exception {
        DeleteOperation setData = new DeleteOperation(ctx.connection, ctx.node);
        setData.setVersion(ctx.version);
        OperationResult<Object> result = setData.get();
        if (!result.isOk() && this.configuration.isCreate() && result.failedDueTo(KeeperException.Code.NONODE)) {
            LOG.warn("Node '{}' did not exist, creating it.", (Object)ctx.node);
            result = this.createNode(ctx);
        }
        return result;
    }

    private void logStoreComplete(String path, Stat statistics) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Stored data to node '{}', and receive statistics {}", (Object)path, (Object)statistics);
            } else {
                LOG.debug("Stored data to node '{}'", (Object)path);
            }
        }
    }

    private class ProductionContext {
        ZooKeeper connection;
        Exchange exchange;
        Message in;
        byte[] payload;
        int version;
        String node;

        ProductionContext(ZooKeeper connection, Exchange exchange) {
            this.connection = connection;
            this.exchange = exchange;
            this.in = exchange.getIn();
            this.node = ZooKeeperUtils.getNodeFromMessage(this.in, ZooKeeperProducer.this.configuration.getPath());
            this.version = ZooKeeperUtils.getVersionFromMessage(this.in);
            this.payload = ZooKeeperUtils.getPayloadFromExchange(exchange);
        }
    }

    private class AsyncDeleteCallback
    implements AsyncCallback.VoidCallback {
        private AsyncDeleteCallback() {
        }

        @Override
        public void processResult(int rc, String path, Object ctx) {
            LOG.debug("Removed data node '{}'", (Object)path);
        }
    }

    private class AsyncSetDataCallback
    implements AsyncCallback.StatCallback {
        private AsyncSetDataCallback() {
        }

        @Override
        public void processResult(int rc, String node, Object ctx, Stat statistics) {
            if (KeeperException.Code.NONODE.equals(KeeperException.Code.get(rc))) {
                if (ZooKeeperProducer.this.configuration.isCreate()) {
                    LOG.warn("Node '{}' did not exist, creating it...", (Object)node);
                    ProductionContext context = (ProductionContext)ctx;
                    OperationResult<String> result = null;
                    try {
                        result = ZooKeeperProducer.this.createNode(context);
                    }
                    catch (Exception e) {
                        LOG.error("Error trying to create node '{}'", (Object)node, (Object)e);
                    }
                    if (result == null || !result.isOk()) {
                        LOG.error("Error creating node '{}'", (Object)node, (Object)result.getException());
                    }
                }
            } else {
                ZooKeeperProducer.this.logStoreComplete(node, statistics);
            }
        }
    }
}

