/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.BufferCaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateBulkLoader=true)
public final class NIOConverter {
    private static final Logger LOG = LoggerFactory.getLogger(NIOConverter.class);

    private NIOConverter() {
    }

    @Converter(order=1)
    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] bArray = new byte[buffer.limit()];
        buffer.get(bArray);
        return bArray;
    }

    @Converter(order=2)
    public static String toString(ByteBuffer buffer, Exchange exchange) throws IOException {
        return IOConverter.toString(NIOConverter.toByteArray(buffer), exchange);
    }

    @Converter(order=3)
    public static ByteBuffer toByteBuffer(byte[] data) {
        return ByteBuffer.wrap(data);
    }

    @Converter(order=4)
    public static ByteBuffer toByteBuffer(ByteArrayOutputStream baos) {
        return ByteBuffer.wrap(baos.toByteArray());
    }

    @Converter(order=5)
    public static ByteBuffer toByteBuffer(File file) throws IOException {
        return NIOConverter.toByteBuffer(file.toPath());
    }

    @Converter(order=6)
    public static ByteBuffer toByteBuffer(Path file) throws IOException {
        long length = Files.size(file);
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Cannot convert file: " + String.valueOf(file) + " to ByteBuffer. The file length is too large: " + length);
        }
        return ByteBuffer.wrap(Files.readAllBytes(file));
    }

    @Converter(order=7)
    public static ByteBuffer toByteBuffer(String value, Exchange exchange) {
        String charsetName;
        byte[] bytes = null;
        if (exchange != null && (charsetName = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class)) != null) {
            try {
                bytes = value.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Cannot convert the byte to String with the charset {}", (Object)charsetName, (Object)e);
            }
        }
        if (bytes == null) {
            bytes = value.getBytes();
        }
        return ByteBuffer.wrap(bytes);
    }

    @Converter(order=8)
    public static ByteBuffer toByteBuffer(Short value) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort(value);
        BufferCaster.cast(buf).flip();
        return buf;
    }

    @Converter(order=9)
    public static ByteBuffer toByteBuffer(Integer value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(value);
        BufferCaster.cast(buf).flip();
        return buf;
    }

    @Converter(order=10)
    public static ByteBuffer toByteBuffer(Long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(value);
        BufferCaster.cast(buf).flip();
        return buf;
    }

    @Converter(order=11)
    public static ByteBuffer toByteBuffer(Float value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putFloat(value.floatValue());
        BufferCaster.cast(buf).flip();
        return buf;
    }

    @Converter(order=12)
    public static ByteBuffer toByteBuffer(Double value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putDouble(value);
        BufferCaster.cast(buf).flip();
        return buf;
    }

    @Converter(order=13)
    public static InputStream toInputStream(ByteBuffer bufferbuffer) {
        return IOConverter.toInputStream(NIOConverter.toByteArray(bufferbuffer));
    }
}

