/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.server.ExpiryQueue;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.ZooTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTrackerImpl
extends ZooKeeperCriticalThread
implements SessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTrackerImpl.class);
    protected final ConcurrentHashMap<Long, SessionImpl> sessionsById = new ConcurrentHashMap();
    private final ExpiryQueue<SessionImpl> sessionExpiryQueue;
    protected final ConcurrentMap<Long, Integer> sessionsWithTimeout;
    private final AtomicLong nextSessionId = new AtomicLong();
    private final SessionTracker.SessionExpirer expirer;
    volatile boolean running = true;

    public static long initializeNextSessionId(long id) {
        long nextSid = Time.currentElapsedTime() << 24 >>> 8;
        if ((nextSid |= id << 56) == Long.MIN_VALUE) {
            ++nextSid;
        }
        return nextSid;
    }

    public SessionTrackerImpl(SessionTracker.SessionExpirer expirer, ConcurrentMap<Long, Integer> sessionsWithTimeout, int tickTime, long serverId, ZooKeeperServerListener listener) {
        super("SessionTracker", listener);
        this.expirer = expirer;
        this.sessionExpiryQueue = new ExpiryQueue(tickTime);
        this.sessionsWithTimeout = sessionsWithTimeout;
        this.nextSessionId.set(SessionTrackerImpl.initializeNextSessionId(serverId));
        for (Map.Entry e : sessionsWithTimeout.entrySet()) {
            this.trackSession((Long)e.getKey(), (Integer)e.getValue());
        }
        EphemeralType.validateServerId(serverId);
    }

    @Override
    public void dumpSessions(PrintWriter pwriter) {
        pwriter.print("Session ");
        this.sessionExpiryQueue.dump(pwriter);
    }

    @Override
    public synchronized Map<Long, Set<Long>> getSessionExpiryMap() {
        Map<Long, Set<SessionImpl>> expiryMap = this.sessionExpiryQueue.getExpiryMap();
        TreeMap<Long, Set<Long>> sessionExpiryMap = new TreeMap<Long, Set<Long>>();
        for (Map.Entry<Long, Set<SessionImpl>> e : expiryMap.entrySet()) {
            HashSet<Long> ids = new HashSet<Long>();
            sessionExpiryMap.put(e.getKey(), ids);
            for (SessionImpl s2 : e.getValue()) {
                ids.add(s2.sessionId);
            }
        }
        return sessionExpiryMap;
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pwriter = new PrintWriter(sw);
        this.dumpSessions(pwriter);
        pwriter.flush();
        pwriter.close();
        return sw.toString();
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                long waitTime = this.sessionExpiryQueue.getWaitTime();
                if (waitTime > 0L) {
                    Thread.sleep(waitTime);
                    continue;
                }
                for (SessionImpl s2 : this.sessionExpiryQueue.poll()) {
                    ServerMetrics.getMetrics().STALE_SESSIONS_EXPIRED.add(1L);
                    this.setSessionClosing(s2.sessionId);
                    this.expirer.expire(s2);
                }
            }
        }
        catch (InterruptedException e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("SessionTrackerImpl exited loop!");
    }

    @Override
    public synchronized boolean touchSession(long sessionId, int timeout) {
        SessionImpl s2 = this.sessionsById.get(sessionId);
        if (s2 == null) {
            this.logTraceTouchInvalidSession(sessionId, timeout);
            return false;
        }
        if (s2.isClosing()) {
            this.logTraceTouchClosingSession(sessionId, timeout);
            return false;
        }
        this.updateSessionExpiry(s2, timeout);
        return true;
    }

    private void updateSessionExpiry(SessionImpl s2, int timeout) {
        this.logTraceTouchSession(s2.sessionId, timeout, "");
        this.sessionExpiryQueue.update(s2, timeout);
    }

    private void logTraceTouchSession(long sessionId, int timeout, String sessionStatus) {
        if (LOG.isTraceEnabled()) {
            String msg = MessageFormat.format("SessionTrackerImpl --- Touch {0}session: 0x{1} with timeout {2}", sessionStatus, Long.toHexString(sessionId), Integer.toString(timeout));
            ZooTrace.logTraceMessage(LOG, 8L, msg);
        }
    }

    private void logTraceTouchInvalidSession(long sessionId, int timeout) {
        this.logTraceTouchSession(sessionId, timeout, "invalid ");
    }

    private void logTraceTouchClosingSession(long sessionId, int timeout) {
        this.logTraceTouchSession(sessionId, timeout, "closing ");
    }

    public int getSessionTimeout(long sessionId) {
        return (Integer)this.sessionsWithTimeout.get(sessionId);
    }

    @Override
    public synchronized void setSessionClosing(long sessionId) {
        SessionImpl s2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Session closing: 0x{}", (Object)Long.toHexString(sessionId));
        }
        if ((s2 = this.sessionsById.get(sessionId)) == null) {
            return;
        }
        s2.isClosing = true;
    }

    @Override
    public synchronized void removeSession(long sessionId) {
        LOG.debug("Removing session 0x{}", (Object)Long.toHexString(sessionId));
        SessionImpl s2 = this.sessionsById.remove(sessionId);
        this.sessionsWithTimeout.remove(sessionId);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Removing session 0x" + Long.toHexString(sessionId));
        }
        if (s2 != null) {
            this.sessionExpiryQueue.remove(s2);
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.running = false;
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "Shutdown SessionTrackerImpl!");
        }
    }

    @Override
    public long createSession(int sessionTimeout) {
        long sessionId = this.nextSessionId.getAndIncrement();
        this.trackSession(sessionId, sessionTimeout);
        return sessionId;
    }

    @Override
    public synchronized boolean trackSession(long id, int sessionTimeout) {
        SessionImpl existedSession;
        boolean added = false;
        SessionImpl session = this.sessionsById.get(id);
        if (session == null) {
            session = new SessionImpl(id, sessionTimeout);
        }
        if ((existedSession = this.sessionsById.putIfAbsent(id, session)) != null) {
            session = existedSession;
        } else {
            added = true;
            LOG.debug("Adding session 0x{}", (Object)Long.toHexString(id));
        }
        if (LOG.isTraceEnabled()) {
            String actionStr = added ? "Adding" : "Existing";
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- " + actionStr + " session 0x" + Long.toHexString(id) + " " + sessionTimeout);
        }
        this.updateSessionExpiry(session, sessionTimeout);
        return added;
    }

    @Override
    public synchronized boolean commitSession(long id, int sessionTimeout) {
        return this.sessionsWithTimeout.put(id, sessionTimeout) == null;
    }

    @Override
    public boolean isTrackingSession(long sessionId) {
        return this.sessionsById.containsKey(sessionId);
    }

    @Override
    public synchronized void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException, KeeperException.UnknownSessionException {
        LOG.debug("Checking session 0x{}", (Object)Long.toHexString(sessionId));
        SessionImpl session = this.sessionsById.get(sessionId);
        if (session == null) {
            throw new KeeperException.UnknownSessionException();
        }
        if (session.isClosing()) {
            throw new KeeperException.SessionExpiredException();
        }
        if (session.owner == null) {
            session.owner = owner;
        } else if (session.owner != owner) {
            throw new KeeperException.SessionMovedException();
        }
    }

    @Override
    public synchronized void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        SessionImpl session = this.sessionsById.get(id);
        if (session == null || session.isClosing()) {
            throw new KeeperException.SessionExpiredException();
        }
        session.owner = owner;
    }

    @Override
    public void checkGlobalSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        try {
            this.checkSession(sessionId, owner);
        }
        catch (KeeperException.UnknownSessionException e) {
            throw new KeeperException.SessionExpiredException();
        }
    }

    @Override
    public long getLocalSessionCount() {
        return 0L;
    }

    @Override
    public boolean isLocalSessionsEnabled() {
        return false;
    }

    @Override
    public Set<Long> globalSessions() {
        return this.sessionsById.keySet();
    }

    @Override
    public Set<Long> localSessions() {
        return Collections.emptySet();
    }

    public static class SessionImpl
    implements SessionTracker.Session {
        final long sessionId;
        final int timeout;
        boolean isClosing;
        Object owner;

        SessionImpl(long sessionId, int timeout) {
            this.sessionId = sessionId;
            this.timeout = timeout;
            this.isClosing = false;
        }

        @Override
        public long getSessionId() {
            return this.sessionId;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public boolean isClosing() {
            return this.isClosing;
        }

        public String toString() {
            return "0x" + Long.toHexString(this.sessionId);
        }
    }
}

