/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster;

import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.zookeepermaster.CamelNodeState;
import org.apache.camel.component.zookeepermaster.ManagedGroupFactoryStrategy;
import org.apache.camel.component.zookeepermaster.group.DefaultGroupFactoryStrategy;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.component.zookeepermaster.group.ManagedGroupFactory;
import org.apache.camel.component.zookeepermaster.group.NodeState;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryOneTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperGroupSupport<T extends NodeState>
extends ServiceSupport
implements CamelContextAware,
Callable<CuratorFramework>,
ConnectionStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperGroupSupport.class);
    private static final String ZOOKEEPER_URL = "zookeeper.url";
    private static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    private static final String ZOOKEEPER_URL_ENV = "ZOOKEEPER_URL";
    private static final String ZOOKEEPER_HOST_ENV = "ZK_CLIENT_SERVICE_HOST";
    private static final String ZOOKEEPER_PORT_ENV = "ZK_CLIENT_SERVICE_PORT";
    private CamelContext camelContext;
    @Metadata(label="advanced", autowired=true)
    private ManagedGroupFactory managedGroupFactory;
    @Metadata(label="advanced", autowired=true)
    private ManagedGroupFactoryStrategy managedGroupFactoryStrategy;
    @Metadata(label="advanced")
    private CuratorFramework curator;
    @Metadata(defaultValue="10000")
    private int maximumConnectionTimeout = 10000;
    @Metadata(defaultValue="localhost:2181")
    private String zooKeeperUrl;
    @Metadata(label="security", secret=true)
    private String zooKeeperPassword;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CuratorFramework getCurator() {
        if (this.managedGroupFactory == null) {
            throw new IllegalStateException("Component is not started");
        }
        return this.managedGroupFactory.getCurator();
    }

    public Group<T> createGroup(String path) {
        if (this.managedGroupFactory == null) {
            throw new IllegalStateException("Component is not started");
        }
        return this.managedGroupFactory.createGroup(path, CamelNodeState.class);
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
        this.registerAsListener();
    }

    public int getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(int maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zooKeeperUrl = zooKeeperUrl;
    }

    public String getZooKeeperPassword() {
        return this.zooKeeperPassword;
    }

    public void setZooKeeperPassword(String zooKeeperPassword) {
        this.zooKeeperPassword = zooKeeperPassword;
    }

    public ManagedGroupFactory getManagedGroupFactory() {
        return this.managedGroupFactory;
    }

    public void setManagedGroupFactory(ManagedGroupFactory managedGroupFactory) {
        this.managedGroupFactory = managedGroupFactory;
        this.managedGroupFactory.setClassLoader(this.getClass().getClassLoader());
    }

    public ManagedGroupFactoryStrategy getManagedGroupFactoryStrategy() {
        return this.managedGroupFactoryStrategy;
    }

    public void setManagedGroupFactoryStrategy(ManagedGroupFactoryStrategy managedGroupFactoryStrategy) {
        this.managedGroupFactoryStrategy = managedGroupFactoryStrategy;
    }

    @Override
    protected void doStart() throws Exception {
        Set<Object> set;
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        if (this.curator == null) {
            try {
                CuratorFramework aCurator = this.getCamelContext().getRegistry().lookupByNameAndType("curator", CuratorFramework.class);
                if (aCurator != null) {
                    LOG.debug("CuratorFramework found in CamelRegistry: {}", (Object)aCurator);
                    this.setCurator(aCurator);
                }
            }
            catch (Exception aCurator) {
                // empty catch block
            }
        }
        if (this.managedGroupFactoryStrategy == null && (set = this.getCamelContext().getRegistry().findByType(ManagedGroupFactoryStrategy.class)).size() == 1) {
            this.setManagedGroupFactoryStrategy((ManagedGroupFactoryStrategy)set.iterator().next());
        }
        if (this.managedGroupFactory == null && (set = this.getCamelContext().getRegistry().findByType(ManagedGroupFactory.class)).size() == 1) {
            this.setManagedGroupFactory((ManagedGroupFactory)set.iterator().next());
        }
        if (this.managedGroupFactory == null) {
            set = this.getCamelContext().getRegistry().findByType(ManagedGroupFactoryStrategy.class);
            if (set.size() == 1) {
                this.setManagedGroupFactoryStrategy((ManagedGroupFactoryStrategy)set.iterator().next());
            } else {
                this.setManagedGroupFactoryStrategy(new DefaultGroupFactoryStrategy());
            }
        }
        if (this.managedGroupFactory == null) {
            this.setManagedGroupFactory(this.getManagedGroupFactoryStrategy().createGroupFactory(this.curator, this.getClass().getClassLoader(), this.getCamelContext(), this));
        }
    }

    @Override
    public CuratorFramework call() throws Exception {
        String password;
        String zkHost;
        Object connectString = this.getZooKeeperUrl();
        if (connectString == null) {
            connectString = System.getenv(ZOOKEEPER_URL_ENV);
        }
        if (connectString == null && (zkHost = System.getenv(ZOOKEEPER_HOST_ENV)) != null) {
            String zkPort = System.getenv(ZOOKEEPER_PORT_ENV);
            connectString = zkHost + ":" + (zkPort == null ? "2181" : zkPort);
        }
        if (connectString == null) {
            connectString = System.getProperty(ZOOKEEPER_URL, "localhost:2181");
        }
        if ((password = this.getZooKeeperPassword()) == null) {
            System.getProperty(ZOOKEEPER_PASSWORD);
        }
        LOG.info("Creating new CuratorFramework with connection: {}", connectString);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString((String)connectString).retryPolicy(new RetryOneTime(1000)).connectionTimeoutMs(this.getMaximumConnectionTimeout());
        if (password != null && !password.isEmpty()) {
            builder.authorization("digest", ("fabric:" + password).getBytes());
        }
        this.curator = builder.build();
        LOG.debug("Starting CuratorFramework {}", (Object)this.curator);
        this.curator.start();
        return this.curator;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.managedGroupFactory != null) {
            this.managedGroupFactory.close();
            this.managedGroupFactory = null;
        }
    }

    @Override
    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        LOG.debug("CuratorFramework state changed: {}", (Object)newState);
    }

    protected void registerAsListener() {
        if (this.curator != null) {
            this.curator.getConnectionStateListenable().addListener(this);
        }
    }
}

