/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command;

import org.talend.commandline.client.command.JavaServerCommand;
import org.talend.commandline.client.filter.ItemFilter;
import org.talend.commandline.client.util.CommandStringBuilder;

public class ChangeStatusCommand
extends JavaServerCommand {
    private String newStatusCode;
    private boolean dependencies;
    private ItemFilter itemFilter;
    private String itemFilterAsString;

    public ChangeStatusCommand(String newStatusCode, boolean dependencies, ItemFilter itemFilter) {
        this.newStatusCode = newStatusCode;
        this.dependencies = dependencies;
        this.itemFilter = itemFilter;
    }

    public ChangeStatusCommand(String newStatusCode, String itemFilterAsString) {
        this.newStatusCode = newStatusCode;
        this.itemFilterAsString = itemFilterAsString;
    }

    @Override
    public String writeToString() {
        CommandStringBuilder builder = new CommandStringBuilder("changeStatus");
        builder.addArgument(this.newStatusCode);
        if (this.dependencies) {
            builder.addOption("d");
        }
        if (this.itemFilter != null) {
            builder.addOptionWithArgument("if", this.itemFilter.writeToString());
        } else if (this.itemFilterAsString != null) {
            builder.addOptionWithArgument("if", this.itemFilterAsString);
        }
        return builder.toString();
    }

    public String getNewStatusCode() {
        return this.newStatusCode;
    }

    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    public boolean isDependencies() {
        return this.dependencies;
    }
}

