/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.files;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.talend.utils.files.FilterInfo;
import org.talend.utils.string.StringUtilities;
import org.talend.utils.sugars.ReturnCode;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public final class FileUtils {
    private static final String LS_FEATURE_KEY = "LS";
    private static final String LS_FEATURE_VERSION = "3.0";
    private static final String CORE_FEATURE_KEY = "Core";
    private static final String CORE_FEATURE_VERSION = "2.0";

    private FileUtils() {
    }

    public static synchronized void replaceInFile(String path, String oldString, String newString) throws IOException, URISyntaxException {
        File file = new File(path);
        File tmpFile = new File(path + ".tmp");
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis);
        dis = new DataInputStream(bis);
        FileOutputStream tempOutputStream = new FileOutputStream(tmpFile);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)tempOutputStream, "UTF8"));
        int len = 0;
        byte[] buf2 = new byte[1024];
        while ((len = dis.read(buf2)) != -1) {
            String line = new String(buf2, 0, len);
            String newLine = line.replace(oldString, newString);
            newLine = new String(newLine.getBytes(), "UTF8");
            bufferedWriter.write(newLine);
            bufferedWriter.flush();
        }
        bufferedWriter.close();
        dis.close();
        file.delete();
        tmpFile.renameTo(file);
    }

    public static synchronized List<ReturnCode> checkBracketsInFile(String path) throws IOException, URISyntaxException {
        String line;
        ArrayList<ReturnCode> returncodes = new ArrayList<ReturnCode>();
        File file = new File(path);
        BufferedReader in = new BufferedReader(new FileReader(file));
        int lineNb = 0;
        while ((line = in.readLine()) != null) {
            ReturnCode checkBlocks = StringUtilities.checkBalancedParenthesis(line, '(', ')');
            ++lineNb;
            if (checkBlocks.isOk().booleanValue()) continue;
            String errorMsg = "Line " + lineNb + ": " + checkBlocks.getMessage();
            returncodes.add(new ReturnCode(errorMsg, false));
        }
        in.close();
        return returncodes;
    }

    public static void getAllFilesFromFolder(File aFolder, List<File> fileList, FilenameFilter filenameFilter) {
        if (aFolder != null) {
            File[] allFolders;
            File[] folderFiles = aFolder.listFiles(filenameFilter);
            if (fileList != null && folderFiles != null) {
                Collections.addAll(fileList, folderFiles);
            }
            if ((allFolders = aFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    return arg0.isDirectory();
                }
            })) != null) {
                for (File folder : allFolders) {
                    FileUtils.getAllFilesFromFolder(folder, fileList, filenameFilter);
                }
            }
        }
    }

    public static List<File> getAllFilesFromFolder(File aFolder, FilenameFilter filenameFilter) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.getAllFilesFromFolder(aFolder, files, filenameFilter);
        return files;
    }

    public static List<File> getAllFilesFromFolder(File aFolder, Set<FilterInfo> filterInfo) {
        ArrayList<File> files = new ArrayList<File>();
        if (filterInfo != null) {
            Iterator<FilterInfo> iterator = filterInfo.iterator();
            while (iterator.hasNext()) {
                FilterInfo info;
                final FilterInfo thatInfo = info = iterator.next();
                files.addAll(FileUtils.getAllFilesFromFolder(aFolder, new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name == null) {
                            return false;
                        }
                        if (thatInfo.getPrefix() == null) {
                            return name.endsWith(thatInfo.getSuffix());
                        }
                        return name.startsWith(thatInfo.getPrefix()) && name.endsWith(thatInfo.getSuffix());
                    }
                }));
            }
        }
        return files;
    }

    public static void deleteFiles(File folder, final Function<String, Boolean> func) {
        if (folder != null && func != null && folder.exists()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File _dir, String name) {
                    return (Boolean)func.apply(name);
                }
            };
            List<File> filesToRemove = FileUtils.getAllFilesFromFolder(folder, filter);
            for (File fileToRemove : filesToRemove) {
                fileToRemove.delete();
            }
        }
    }

    public static File createTmpFolder(String prefix, String suffix) {
        File tempFolder = null;
        try {
            tempFolder = File.createTempFile(prefix, suffix);
            tempFolder.delete();
        }
        catch (IOException e) {
            String tempFolderName = prefix + System.currentTimeMillis() + suffix;
            tempFolder = FileUtils.createUserTmpFolder(tempFolderName);
        }
        tempFolder.mkdirs();
        return tempFolder;
    }

    public static File createUserTmpFolder(String folderName) {
        File tmpFolder = new File(System.getProperty("user.dir"), "temp/" + folderName);
        tmpFolder.mkdirs();
        return tmpFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createProjectFile(String projectName, File tmpProjectFile) throws Exception {
        tmpProjectFile.createNewFile();
        FileOutputStream fos = null;
        PrintStream ps = null;
        try {
            fos = new FileOutputStream(tmpProjectFile);
            ps = new PrintStream(fos);
            ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ps.println("<projectDescription>");
            ps.println("\t<name>" + projectName + "</name>");
            ps.println("\t<comment></comment>");
            ps.println("\t<projects></projects>");
            ps.println("\t<buildSpec></buildSpec>");
            ps.println("\t<natures>");
            ps.println("\t\t<nature>org.talend.core.talendnature</nature>");
            ps.println("\t</natures>");
            ps.println("</projectDescription>");
            ps.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static void writeXMLFile(Document document, Writer writer) {
        DOMImplementation implementation = document.getImplementation();
        if (implementation.hasFeature(LS_FEATURE_KEY, LS_FEATURE_VERSION) && implementation.hasFeature(CORE_FEATURE_KEY, CORE_FEATURE_VERSION)) {
            DOMImplementationLS implementationLS = (DOMImplementationLS)implementation.getFeature(LS_FEATURE_KEY, LS_FEATURE_VERSION);
            LSSerializer serializer = implementationLS.createLSSerializer();
            DOMConfiguration configuration = serializer.getDomConfig();
            configuration.setParameter("well-formed", Boolean.TRUE);
            configuration.setParameter("comments", true);
            LSOutput output = implementationLS.createLSOutput();
            output.setEncoding("UTF-8");
            output.setCharacterStream(writer);
            serializer.write(document, output);
        }
    }
}

