/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.talend.utils.sugars.ReturnCode;

public final class FilesUtils {
    private static final int BUFFER_SIZE = 65536;
    public static final String GITKEEP = ".gitkeep";
    public static final String[] SVN_FOLDER_NAMES = new String[]{".svn", "_svn"};

    public static boolean isSVNFolder(String name) {
        if (name != null) {
            String checkedName = name.toLowerCase();
            for (String element : SVN_FOLDER_NAMES) {
                if (!element.equals(checkedName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSVNFolder(File file) {
        if (file != null) {
            return FilesUtils.isSVNFolder(file.getName());
        }
        return false;
    }

    private FilesUtils() {
    }

    public static boolean isEmptyFolder(String path) {
        File[] files;
        File file = new File(path);
        return file.isDirectory() && (files = file.listFiles()).length <= 0;
    }

    public static void copyFolder(File source, File target, boolean emptyTargetBeforeCopy, final FileFilter sourceFolderFilter, final FileFilter sourceFileFilter, boolean copyFolder) throws IOException {
        File[] files;
        if (!target.exists()) {
            target.mkdirs();
        }
        if (emptyTargetBeforeCopy) {
            FilesUtils.emptyFolder(target);
        }
        FileFilter folderFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && (sourceFolderFilter == null || sourceFolderFilter.accept(pathname));
            }
        };
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() && (sourceFileFilter == null || sourceFileFilter.accept(pathname));
            }
        };
        File[] folders = source.listFiles(folderFilter);
        if (folders != null) {
            for (File current : folders) {
                if (copyFolder) {
                    File newFolder = new File(target, current.getName());
                    newFolder.mkdir();
                    FilesUtils.copyFolder(current, newFolder, emptyTargetBeforeCopy, sourceFolderFilter, sourceFileFilter, copyFolder);
                    continue;
                }
                FilesUtils.copyFolder(current, target, emptyTargetBeforeCopy, sourceFolderFilter, sourceFileFilter, copyFolder);
            }
        }
        if ((files = source.listFiles(fileFilter)) != null) {
            for (File current : files) {
                File out = new File(target, current.getName());
                FilesUtils.copyFile(current, out);
            }
        }
    }

    private static void emptyFolder(File toEmpty) {
        for (File current : toEmpty.listFiles()) {
            if (current.isDirectory()) {
                FilesUtils.emptyFolder(current);
            }
            current.delete();
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        if (!target.exists() || source.lastModified() > target.lastModified()) {
            FileInputStream in = new FileInputStream(source);
            FilesUtils.copyFile(in, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream source, File target) throws IOException {
        File parentFile = target.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(target);
        try {
            IOUtils.copy(source, (OutputStream)out);
        }
        finally {
            try {
                source.close();
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void copyDirectory(File source, File target) {
        File tarpath = new File(target, source.getName());
        if (source.isDirectory()) {
            File[] dir;
            tarpath.mkdir();
            for (File element : dir = source.listFiles()) {
                FilesUtils.copyDirectory(element, tarpath);
            }
        } else {
            try {
                FileInputStream in = new FileInputStream(source);
                FilesUtils.copyFile(in, tarpath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceInFile(String regex, String fileName, String replacement) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (FileInputStream in = new FileInputStream(fileName);){
            String line;
            InputStreamReader inR = new InputStreamReader(in);
            BufferedReader buf = new BufferedReader(inR);
            while ((line = buf.readLine()) != null) {
                buffer.append(line.replaceAll(regex, replacement)).append("\n");
            }
        }
        FileOutputStream os = new FileOutputStream(fileName);
        ((OutputStream)os).write(buffer.toString().getBytes());
        ((OutputStream)os).close();
    }

    public static FileFilter getExcludeSystemFilesFilter() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !FilesUtils.isSVNFolder(pathname);
            }
        };
        return filter;
    }

    public static FileFilter getAcceptJARFilesFilter() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.toString().endsWith(".jar");
            }
        };
        return filter;
    }

    public static FileFilter getAcceptPMFilesFilter() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.toString().endsWith(".pm");
            }
        };
        return filter;
    }

    public static boolean createFolder(String path) {
        File folderPath = new File(path);
        return FilesUtils.createFolder(folderPath);
    }

    public static boolean createFolder(File path) {
        if (!path.exists()) {
            return path.mkdir();
        }
        if (!path.isDirectory()) {
            return path.mkdir();
        }
        return true;
    }

    public static int getLastSeparatorLocation(String pathName) {
        int temp;
        int lastseparator = -1;
        if (pathName.contains("\\")) {
            lastseparator = pathName.lastIndexOf("\\");
        }
        if (pathName.contains("/") && (temp = pathName.lastIndexOf("/")) > lastseparator) {
            lastseparator = temp;
        }
        return lastseparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getContentLines(String filePath) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
            String line;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static ReturnCode createFoldersIfNotExists(String path) {
        return FilesUtils.createFoldersIfNotExists(path, false);
    }

    public static ReturnCode createFoldersIfNotExists(String path, boolean pathIsFilePath) {
        File filePath;
        ReturnCode rc = new ReturnCode();
        File fileFolder = filePath = new File(path);
        if (pathIsFilePath) {
            fileFolder = filePath.getParentFile();
        }
        if (!fileFolder.exists() && !fileFolder.mkdirs()) {
            rc.setOk(false);
            rc.setMessage("Failed to create the directory: " + fileFolder.getAbsolutePath());
        }
        return rc;
    }

    public static void zipDirWithApache(String zipFileName, String inputFile) throws Exception {
        ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(zipFileName));
        FilesUtils.zipDirWithApache(out, new File(inputFile), "");
        out.close();
    }

    private static void zipDirWithApache(ZipOutputStream out, File f, String base) throws Exception {
        String baseValue = base;
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            out.putNextEntry(new ZipEntry(baseValue + "/"));
            baseValue = baseValue.length() == 0 ? "" : baseValue + "/";
            for (File element : fl) {
                FilesUtils.zipDirWithApache(out, element, baseValue + element.getName());
            }
        } else {
            int b;
            out.putNextEntry(new ZipEntry(baseValue));
            FileInputStream in = new FileInputStream(f);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
        }
    }

    public static boolean removeFolder(String pathFolder, boolean recursiveRemove) {
        File folder = new File(pathFolder);
        if (folder.isDirectory()) {
            return FilesUtils.removeFolder(folder, recursiveRemove);
        }
        return false;
    }

    public static boolean removeFolder(File folder, boolean removeRecursivly) {
        if (removeRecursivly) {
            for (File current : folder.listFiles()) {
                if (current.isDirectory()) {
                    FilesUtils.removeFolder(current, true);
                    continue;
                }
                current.delete();
            }
        }
        return folder.delete();
    }

    public static String extractPathFolderFromFilePath(String filePath) {
        File completePath = new File(filePath);
        return completePath.getParent();
    }

    public static long getChecksumAlder32(File file) throws IOException {
        try (BufferedInputStream bufferedInputStream = null;){
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            long l = FilesUtils.getChecksumAlder32(bufferedInputStream);
            return l;
        }
    }

    public static long getChecksumAlder32(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return 0L;
        }
        try (FilterInputStream cis = null;){
            cis = new CheckedInputStream(inputStream, new Adler32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long l = ((CheckedInputStream)cis).getChecksum().getValue();
            return l;
        }
    }

    public static byte[] getBytes(File archiveFile) throws IOException {
        long length = archiveFile.length();
        int lengthFinalSize = 0;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Capacity is over !");
        }
        lengthFinalSize = (int)length;
        FileInputStream fis = new FileInputStream(archiveFile);
        int bufferSize = 1024;
        byte[] buf = new byte[bufferSize];
        int readBytes = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(lengthFinalSize);
        while ((readBytes = fis.read(buf)) != -1) {
            bos.write(buf, 0, readBytes);
        }
        return bos.toByteArray();
    }

    public static File getFile(String filePath, byte[] jobScriptArchive) throws IOException {
        File file = new File(filePath);
        ByteArrayInputStream bis = new ByteArrayInputStream(jobScriptArchive, 0, jobScriptArchive.length);
        FileOutputStream fos = new FileOutputStream(file);
        int bufferSize = 1024;
        byte[] buf = new byte[bufferSize];
        int readBytes = 0;
        while ((readBytes = bis.read(buf)) != -1) {
            fos.write(buf, 0, readBytes);
        }
        bis.close();
        fos.close();
        return file;
    }

    private static void printFailure(ReturnCode rc) {
        if (!rc.isOk().booleanValue()) {
            System.err.println("Failure: " + rc.getMessage());
        }
    }

    public static void zip(String sourceFileName, String zippedFileName) throws IOException {
        FilesUtils.zip(new File(sourceFileName), zippedFileName, null);
    }

    public static void zip(String sourceFileName, String zippedFileName, FileFilter fileFilter) throws IOException {
        FilesUtils.zip(new File(sourceFileName), zippedFileName, fileFilter);
    }

    public static void zip(File sourceFile, String zippedFileName) throws IOException {
        FilesUtils.zip(sourceFile, zippedFileName, null);
    }

    public static void zip(File sourceFile, String zippedFileName, FileFilter fileFilter) throws IOException {
        if (sourceFile.isDirectory()) {
            FilesUtils.zips(sourceFile.listFiles(fileFilter), zippedFileName, fileFilter);
        } else {
            FilesUtils.zips(new File[]{sourceFile}, zippedFileName, fileFilter);
        }
    }

    public static void jar(Manifest manifest, File sourceDir, File zip) throws IOException {
        FilesUtils.jar(manifest, sourceDir, zip, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jar(Manifest manifest, File sourceDir, File zip, FileFilter fileFilter) throws IOException {
        try (JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(zip), manifest);){
            FilesUtils.zips(sourceDir.listFiles(fileFilter), out, fileFilter);
        }
    }

    public static void zips(File[] sourceFile, String zippedFileName) throws IOException {
        FilesUtils.zips(sourceFile, zippedFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zips(File[] sourceFile, String zippedFileName, FileFilter fileFilter) throws IOException {
        FileOutputStream fos = new FileOutputStream(zippedFileName);
        java.util.zip.ZipOutputStream out = new java.util.zip.ZipOutputStream(fos);
        try {
            FilesUtils.zips(sourceFile, out, fileFilter);
        }
        finally {
            if (sourceFile.length > 0) {
                out.close();
            } else {
                ((OutputStream)fos).close();
            }
        }
    }

    private static void zips(File[] sourceFile, java.util.zip.ZipOutputStream out, FileFilter fileFilter) throws IOException {
        for (File theFile : sourceFile) {
            FilesUtils.zips(out, theFile, "", fileFilter);
        }
    }

    private static void zips(java.util.zip.ZipOutputStream out, File f, String base, FileFilter fileFilter) throws IOException {
        if (f.isDirectory()) {
            base = base + f.getName() + '/';
            out.putNextEntry(new java.util.zip.ZipEntry(base));
            for (File element : f.listFiles(fileFilter)) {
                FilesUtils.zips(out, element, base, fileFilter);
            }
        } else {
            out.putNextEntry(new java.util.zip.ZipEntry(base + f.getName()));
            FileInputStream in = new FileInputStream(f);
            byte[] b = new byte[65536];
            int readBytes = 0;
            while ((readBytes = ((InputStream)in).read(b, 0, 65536)) != -1) {
                out.write(b, 0, readBytes);
            }
            ((InputStream)in).close();
            out.flush();
        }
    }

    public static void zipFiles(String source, String target) throws Exception {
        FilesUtils.zip(source, target);
    }

    public static void zipFolderRecursion(String sourceFileName, String zippedFileName) throws IOException {
        FilesUtils.zip(sourceFileName, zippedFileName, null);
    }

    public static void zipFolderRecursion(String sourceFileName, String zippedFileName, FileFilter fileFilter) throws Exception {
        FilesUtils.zip(sourceFileName, zippedFileName, fileFilter);
    }

    public static void unzip(String zipFile, String targetFolder, String ... fileSuffixes) throws Exception {
        FilesUtils.unzip(zipFile, targetFolder, true, fileSuffixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(String zipFile, String targetFolder, boolean overwrite, String ... fileSuffixes) throws Exception {
        Exception exception = null;
        ZipFile zip = new ZipFile(zipFile);
        byte[] buf = new byte[8192];
        try {
            Enumeration<? extends java.util.zip.ZipEntry> enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                java.util.zip.ZipEntry entry = enumeration.nextElement();
                File file = new File(targetFolder, entry.getName());
                FilesUtils.validateDestPath(targetFolder, file.getPath());
                boolean exist = file.exists();
                if (entry.isDirectory()) {
                    if (exist) continue;
                    file.mkdir();
                    continue;
                }
                if (!overwrite && exist || fileSuffixes.length > 0 && !FilesUtils.isReservedFile(file.getName(), fileSuffixes)) continue;
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                InputStream zin = zip.getInputStream(entry);
                FileOutputStream fout = new FileOutputStream(file);
                File dir = file.getParentFile();
                if (dir.isDirectory() && !dir.exists()) {
                    dir.mkdirs();
                }
                try {
                    int bytesRead;
                    while ((bytesRead = zin.read(buf)) != -1) {
                        ((OutputStream)fout).write(buf, 0, bytesRead);
                    }
                    fout.flush();
                }
                catch (Exception e) {
                    try {
                        exception = e;
                    }
                    catch (Throwable throwable) {
                        try {
                            zin.close();
                            ((OutputStream)fout).close();
                            throw throwable;
                        }
                        catch (Exception e2) {
                            exception = e2;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                            return;
                        }
                    }
                    zin.close();
                    ((OutputStream)fout).close();
                    zip.close();
                    if (exception == null) return;
                    throw exception;
                }
                zin.close();
                ((OutputStream)fout).close();
            }
        }
        finally {
            zip.close();
            if (exception == null) return;
            throw exception;
        }
    }

    public static void validateDestPath(String targetDir, String destPathStr) throws IOException {
        if (targetDir != null && !targetDir.isEmpty() && destPathStr != null && !destPathStr.isEmpty()) {
            Path targetPathNormalized = Paths.get(new File(targetDir).toPath().toString(), new String[0]).normalize();
            Path destPathNormalized = Paths.get(new File(destPathStr).toPath().toString(), new String[0]).normalize();
            if (!destPathNormalized.startsWith(targetPathNormalized)) {
                throw new IOException("Invalid output path: " + destPathStr);
            }
        }
    }

    private static boolean isReservedFile(String name, String[] fileSuffixes) {
        if (name != null) {
            String checkedName = name.toLowerCase();
            for (String element : fileSuffixes) {
                if (!element.equals(checkedName) && !checkedName.endsWith(element)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFileFromWeb(URL resourceURL, String fullPath) {
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        HttpURLConnection conn = null;
        byte[] buf = new byte[65536];
        int size = 0;
        File fileTostore = null;
        try {
            conn = (HttpURLConnection)resourceURL.openConnection();
            conn.connect();
            InputStream inputStream = conn.getInputStream();
            bis = new BufferedInputStream(inputStream);
            fileTostore = new File(fullPath);
            if (!fileTostore.exists()) {
                fileTostore.createNewFile();
            } else {
                fileTostore.delete();
                fileTostore.createNewFile();
            }
            fos = new FileOutputStream(fullPath);
            while ((size = bis.read(buf)) != -1) {
                fos.write(buf, 0, size);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                buf = null;
                bis.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            conn.disconnect();
        }
    }

    public static void deleteFile(File file, boolean delete) {
        if (file.exists()) {
            if (file.isFile() && delete) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files;
                for (File file2 : files = file.listFiles()) {
                    FilesUtils.deleteFile(file2, true);
                }
            }
            if (delete) {
                file.delete();
            }
        }
    }

    public static void deleteFolder(File file, boolean withCurrentFolder) {
        if (file.exists() && file.isDirectory()) {
            File[] files;
            for (File file2 : files = file.listFiles()) {
                FilesUtils.deleteFile(file2, true);
            }
            if (withCurrentFolder) {
                file.delete();
            }
        }
    }

    public static boolean allInSameFolder(File baseFile, String ... fileNames) {
        if (baseFile != null && baseFile.exists()) {
            if (fileNames == null || fileNames.length == 0) {
                return true;
            }
            File baseFoler = baseFile;
            if (baseFile.isFile()) {
                baseFoler = baseFile.getParentFile();
            }
            for (String fileName : fileNames) {
                File subFile;
                if (fileName == null || (subFile = new File(baseFoler, fileName)).exists()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

