/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.string;

import java.util.HashSet;

public final class Jaccard {
    private Jaccard() {
    }

    public static String tokenize(String outputEntry) {
        String str = outputEntry.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
        str = str.replaceAll("_", "");
        str = str.replaceAll(" +", " ").toLowerCase();
        return str;
    }

    public static double JaccardCompare(String res, String res1) {
        String[] left = res.split("\\s+");
        String[] right = res1.split("\\s+");
        int leftLength = left.length;
        int rightLength = right.length;
        HashSet<String> unionSet = new HashSet<String>();
        boolean unionFilled = false;
        double intersection = 0.0;
        if (leftLength == 0 || rightLength == 0) {
            return 0.0;
        }
        for (int leftIndex = 0; leftIndex < leftLength; ++leftIndex) {
            unionSet.add(left[leftIndex]);
            for (int rightIndex = 0; rightIndex < rightLength; ++rightIndex) {
                if (!unionFilled) {
                    unionSet.add(right[rightIndex]);
                }
                if (!left[leftIndex].equals(right[rightIndex])) continue;
                int wordLength = left[leftIndex].length();
                if (wordLength > 1) {
                    double weight = Math.log(wordLength) / Math.log(2.0);
                    intersection += weight;
                    continue;
                }
                intersection += 1.0;
            }
            unionFilled = true;
        }
        return intersection / Double.valueOf(unionSet.size());
    }
}

