/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class FileTransferHandler {
    private static final int BUFFER_SIZE = 1024;

    private FileTransferHandler() {
    }

    public static long getFileSize(String filePath) {
        return new File(filePath).length();
    }

    public static String getMD5(String filePath) throws IOException {
        String string;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filePath));
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            string = bigInt.toString(16);
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException iOException) {}
        return string;
    }

    public static void sendFile(String filePath, OutputStream outputStream) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(filePath));
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            outputStream.flush();
            while ((read = ((InputStream)inputStream).read(buffer)) > 0) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.flush();
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void receiveFile(String filePath, InputStream inputStream, long size) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] buffer = new byte[1024];
        int read = 0;
        int toRead = 1024;
        try {
            if (size < 1024L) {
                toRead = (int)size;
            }
            while ((read = inputStream.read(buffer, 0, toRead)) > 0) {
                if ((size -= (long)read) < 1024L) {
                    toRead = (int)size;
                }
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            try {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException iOException) {}
    }
}

