/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.talend.ci.util.Utils;
import org.talend.ci.util.VersionUtils;
import org.talend.commandline.client.CommandLineJavaClient;
import org.talend.commandline.client.command.CreateProjectCommand;
import org.talend.commandline.client.command.IJavaCommand;
import org.talend.commandline.client.command.InitLocalCommand;
import org.talend.commandline.client.command.LogoffProjectCommand;
import org.talend.commandline.client.command.LogonProjectCommand;
import org.talend.commandline.client.command.extension.BuildItemSourcesCommand;
import org.talend.commandline.client.command.extension.RegenerateAllPomsCommand;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.PomFinder;
import org.talend.jobbuilder.model.ItemInfo;
import org.talend.jobbuilder.model.TalendProject;
import org.talend.utils.json.JSONArray;
import org.talend.utils.json.JSONObject;

@Mojo(name="generateAllPoms", requiresProject=false)
public class PomGenerator
extends JobBuilder {
    @Parameter(required=false, property="itemFilter")
    protected String itemFilter;
    @Parameter(required=false, property="projectFilter")
    protected String projectFilter;
    @Parameter(required=false, property="filter.include.dependencies", defaultValue="true")
    protected boolean includeDependencies;
    @Parameter(required=false, property="workspace")
    protected String workSpace;
    private static final String PROFILE_MODE_PROPERTY = "talend.profile.module";
    private static final String MAVEN_SETTING_PARAM = "-s";
    private Pattern pattern;
    private ClassWorld cw = null;
    private MavenCli cli = null;
    protected Map<String, TalendProject> projectMap = new HashMap<String, TalendProject>();

    @Override
    protected void exec() throws MojoExecutionException, MojoFailureException {
        this.session.getUserProperties().setProperty("talend.ci.generate.pom", Boolean.TRUE.toString());
        if (StringUtils.isEmpty(this.itemFilter)) {
            this.itemFilter = null;
        }
        if (StringUtils.isNotBlank(this.projectFilter)) {
            try {
                this.pattern = Pattern.compile(this.projectFilter.toUpperCase());
                this.getLog().info((CharSequence)("Project Filter is available: [" + this.projectFilter + "]"));
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        if (StringUtils.isEmpty(this.workSpace)) {
            this.workSpace = new File("").getAbsolutePath();
        }
        this.commandlineWorkspace = this.workSpace;
        this.getLog().info((CharSequence)("commandlineWorkspace: " + new File(this.commandlineWorkspace).getAbsolutePath()));
        this.getLog().info((CharSequence)"*****************************************************");
        this.initializeProjectList();
        this.checkCompatiable();
        try {
            this.setConfigToCommandline();
        }
        catch (IOException e) {
            throw new MojoFailureException("Set ci-setting info failed.", (Throwable)e);
        }
        this.installCommandline();
        if (this.generationType.equals("server")) {
            this.executeByServerCommandline();
        } else if (this.generationType.equals("local")) {
            this.executeByLocalCommandline();
        }
        String profileProp = this.session.getUserProperties().getProperty(PROFILE_MODE_PROPERTY);
        boolean profilePreference = this.readProfileModeFromPreference();
        if (profileProp == null && profilePreference) {
            this.getLog().warn((CharSequence)"Profile mode is enabled in project preference: org.talend.designer.maven.prefs. You can disable profile mode by specifying -Dtalend.profile.module=false");
        } else {
            boolean profileMode = Boolean.parseBoolean(profileProp);
            this.getLog().info((CharSequence)("profileMode: " + profileMode));
            if (!profileMode) {
                try {
                    this.installCommonProject();
                }
                catch (Exception e) {
                    throw new MojoFailureException("installing common projects failed", (Throwable)e);
                }
            }
        }
    }

    protected void installCommonProject() throws Exception {
        this.getLog().info((CharSequence)"<---------------------Begin installing common projects----------------------->");
        this.cw = new ClassWorld("", this.session.getClass().getClassLoader());
        this.cli = new MavenCli(this.cw);
        HashMap<String, ArrayList<ReferenceCount>> ret = new HashMap<String, ArrayList<ReferenceCount>>();
        Set<Map.Entry<String, TalendProject>> entries = this.projectMap.entrySet();
        for (Map.Entry<String, TalendProject> entry : entries) {
            HashSet<String> visitedProjects = new HashSet<String>();
            ReferenceCount rc = new ReferenceCount(entry.getValue());
            for (Map.Entry<String, TalendProject> entryInner : entries) {
                this.findReferenceCount(visitedProjects, this.projectMap, entryInner.getValue(), rc, 0);
                if (rc.getReferenceCount() <= 1) continue;
                ArrayList<ReferenceCount> refs = (ArrayList<ReferenceCount>)ret.get(entryInner.getKey());
                if (refs == null) {
                    refs = new ArrayList<ReferenceCount>();
                    ret.put(entryInner.getKey(), refs);
                }
                refs.add(rc);
            }
        }
        this.getLog().info((CharSequence)("size of ret: " + ret.size()));
        Set refEntries = ret.entrySet();
        HashSet<String> generatedProjects = new HashSet<String>();
        for (Map.Entry entry : refEntries) {
            this.getLog().info((CharSequence)("k, size of v: " + (String)entry.getKey() + ", " + ((List)entry.getValue()).size()));
            List<ReferenceCount> refCounts = (List<ReferenceCount>)entry.getValue();
            refCounts = refCounts.stream().filter(ref -> !generatedProjects.contains(ref.getTalendProject().getName())).collect(Collectors.toList());
            refCounts.sort(new Comparator<ReferenceCount>(){

                @Override
                public int compare(ReferenceCount o1, ReferenceCount o2) {
                    return o2.getReferenceLevel() - o1.getReferenceLevel();
                }
            });
            this.getLog().info((CharSequence)("Ordered common projects: " + refCounts.toString()));
            if (refCounts.isEmpty()) continue;
            this.generateSources(refCounts);
            Properties buildProperties = Utils.getBuildProperties(this.commandlineWorkspace);
            if (buildProperties.getProperty("session.id") != null && buildProperties.getProperty("license.path") != null) {
                this.setSignerSessionInfo();
            }
            for (ReferenceCount rc : refCounts) {
                TalendProject prj = rc.getTalendProject();
                this.installTalendProject(prj);
                generatedProjects.add(prj.getName());
            }
        }
        this.getLog().info((CharSequence)"<---------------------End installing common projects----------------------->");
    }

    private void generateSources(List<ReferenceCount> orderedRefCounts) throws MojoExecutionException, MojoFailureException {
        ArrayList<IJavaCommand> commands = new ArrayList<IJavaCommand>();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to generate sources");
        commands.add(new InitLocalCommand());
        this.prepareBuildItemSourcesCommands(commands, orderedRefCounts);
        this.getLog().info((CharSequence)"Executing script...");
        this.generateScriptAndRun(commands);
        this.getLog().info((CharSequence)"Script execution finished.");
        this.getLog().info((CharSequence)"Successfully generated sources");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Finished to generate the code");
        this.getLog().info((CharSequence)"*****************************************************");
    }

    private void prepareBuildItemSourcesCommands(List<IJavaCommand> commands, List<ReferenceCount> orderedRefCounts) {
        boolean mainJobOnly = false;
        for (ReferenceCount rc : orderedRefCounts) {
            PomFinder jf = new PomFinder(this.getLog());
            Path jobPomDir = Paths.get(this.commandlineWorkspace, rc.getTalendProject().getName(), "poms");
            try {
                Files.walkFileTree(jobPomDir, jf);
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
            this.getLog().info((CharSequence)("Generating commandline script for project: " + rc.getTalendProject().getName()));
            commands.add(new LogonProjectCommand(rc.getTalendProject().getName(), this.commandlineUser, null, true));
            List<MavenProject> sortedProjects = jf.getSortedProjects();
            this.getLog().info((CharSequence)("size of sortedProjects: " + sortedProjects.size()));
            for (MavenProject mp : sortedProjects) {
                if (mp.getPackaging().equals("pom")) continue;
                String prjName = mp.getProperties().getProperty("talend.project.name");
                String jobName = mp.getProperties().getProperty("talend.job.name");
                String jobId = mp.getProperties().getProperty("talend.job.id");
                String jobVersion = mp.getProperties().getProperty("talend.job.version");
                if (StringUtils.isEmpty(prjName) || StringUtils.isEmpty(jobId) || StringUtils.isEmpty(jobVersion)) continue;
                ItemInfo info = new ItemInfo(jobId, jobVersion, jobName);
                this.getLog().info((CharSequence)("Prepare command to generating code for :" + info.getName()));
                BuildItemSourcesCommand buildItem = new BuildItemSourcesCommand(info.getId(), info.getVersion(), String.valueOf(mainJobOnly));
                commands.add(buildItem);
                this.getLog().info((CharSequence)("command: " + buildItem.writeToString()));
            }
            commands.add(new LogoffProjectCommand());
        }
    }

    private void installTalendProject(TalendProject prj) throws Exception {
        String userSettings;
        this.getLog().info((CharSequence)("installing " + prj.getProjectFolder().getAbsolutePath()));
        ArrayList<Object> cmds = new ArrayList<Object>();
        cmds.add("clean");
        cmds.add("install");
        cmds.add("-f");
        cmds.add(Paths.get(prj.getProjectFolder().getAbsolutePath(), "poms", "pom.xml").toFile().getAbsolutePath());
        cmds.add("-Dci.builder.skip=true");
        cmds.add("-Dmaven.test.skip=true");
        File licenseFile = new File(this.productPath).toPath().resolve("license").toFile();
        cmds.add("-Dlicense.path=" + licenseFile.getAbsolutePath());
        this.session.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> cmds.add("-D" + k.toString() + "=" + v.toString())));
        String sid = this.session.getSystemProperties().getProperty("session.id");
        if (!StringUtils.isEmpty(sid)) {
            cmds.add("-Dsession.id=" + sid);
        }
        File globalSettingFile = this.session.getRequest().getGlobalSettingsFile();
        String mvnHome = globalSettingFile.getParentFile().getParentFile().getAbsolutePath();
        this.getLog().info((CharSequence)("mvnHome from global settings file: " + mvnHome + ", settings file: " + globalSettingFile));
        Path m2Conf = Paths.get(mvnHome, "bin", "m2.conf");
        cmds.add("-Dclassworlds.conf=" + m2Conf.toFile().getAbsolutePath());
        cmds.add("-Dmaven.home=" + new File(mvnHome).getAbsolutePath());
        Object cmdArgs = this.session.getSystemProperties().get("env.MAVEN_CMD_LINE_ARGS");
        if (cmdArgs != null) {
            this.getLog().info((CharSequence)("mvnarg: " + cmdArgs.toString()));
            Object[] cmdArray = Utils.getCommandLineArgs(cmdArgs.toString());
            this.getLog().info((CharSequence)("cmdArray: " + Arrays.toString(cmdArray)));
            for (int i = 0; i < cmdArray.length; ++i) {
                if (StringUtils.equals((CharSequence)cmdArray[i], "-X") || StringUtils.equals((CharSequence)cmdArray[i], "-U") || StringUtils.equals((CharSequence)cmdArray[i], "-fae") || StringUtils.equals((CharSequence)cmdArray[i], "-fn") || StringUtils.equals((CharSequence)cmdArray[i], "-ff") || StringUtils.equals((CharSequence)cmdArray[i], "-o")) {
                    cmds.add(cmdArray[i]);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)cmdArray[i], "-P") && !StringUtils.equals((CharSequence)cmdArray[i], "-l")) continue;
                cmds.add(cmdArray[i]);
                cmds.add(cmdArray[i + 1]);
            }
        }
        if (StringUtils.isNotBlank(userSettings = Utils.getMavenSettingsFile(this.session))) {
            cmds.add(MAVEN_SETTING_PARAM);
            cmds.add(new File(userSettings).getAbsolutePath());
        }
        this.getLog().info((CharSequence)("cmd: " + ((Object)cmds).toString()));
        try {
            int result = this.cli.doMain(cmds.toArray(new String[0]), this.commandlineWorkspace, null, null);
            if (result != 0) {
                throw new Exception("cmd failed, cmd: " + ((Object)cmds).toString());
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected void findReferenceCount(Set<String> visitedProjects, Map<String, TalendProject> projectMap, TalendProject projectTree, ReferenceCount rc, int level) {
        if (visitedProjects.contains(projectTree.getName()) || projectTree == null || projectTree.getReferences().isEmpty()) {
            return;
        }
        visitedProjects.add(projectTree.getName());
        for (String refPrj : projectTree.getReferences()) {
            TalendProject project;
            if (StringUtils.equals(refPrj, rc.getTalendProject().getName())) {
                rc.increaseReferenceCount();
                rc.setReferenceLevel(level);
            }
            if ((project = projectMap.get(refPrj)) == null) {
                RuntimeException e = new RuntimeException("referenced project missing: " + refPrj);
                this.getLog().error((Throwable)e);
                throw e;
            }
            this.findReferenceCount(visitedProjects, projectMap, project, rc, level++);
        }
    }

    boolean readProfileModeFromPreference() {
        Set<Map.Entry<String, TalendProject>> entries = this.projectMap.entrySet();
        for (Map.Entry<String, TalendProject> entry : entries) {
            String pMode;
            Path prefPath = Paths.get(entry.getValue().getProjectFolder().getAbsolutePath(), ".settings", "org.talend.designer.maven.prefs");
            Properties p = new Properties();
            try (FileInputStream is = new FileInputStream(prefPath.toFile());){
                p.load(is);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("can not read org.talend.designer.maven.prefs for project: " + entry.getKey()), (Throwable)e);
            }
            if (StringUtils.isEmpty(pMode = p.getProperty("USE_PROFILE_MODULE")) || !Boolean.parseBoolean(pMode)) continue;
            this.getLog().info((CharSequence)("Profile mode is enabled in " + prefPath));
            return true;
        }
        return false;
    }

    @Override
    protected void initializeProjectList() throws MojoExecutionException {
        this.getLog().info((CharSequence)("List projects from:" + this.commandlineWorkspace));
        File workspace = new File(this.commandlineWorkspace);
        if (workspace == null || !workspace.exists()) {
            throw new MojoExecutionException("Invalid or non-existing workspace directory");
        }
        Stream.of(workspace.listFiles(File::isDirectory)).forEach(file -> {
            File talendProjectFile = new File((File)file, "talend.project");
            String projectName = file.getName();
            if (talendProjectFile.isFile() && talendProjectFile.exists()) {
                TalendProject project = new TalendProject((File)file, talendProjectFile.getParent());
                this.projectMap.put(project.getName(), project);
                File refSettingsFile = file.toPath().resolve(".settings").resolve("reference_projects.settings").toFile();
                if (refSettingsFile.exists()) {
                    try {
                        String jsonStr = new String(Files.readAllBytes(refSettingsFile.toPath()));
                        if (!jsonStr.isEmpty()) {
                            JSONObject obj = new JSONObject(jsonStr);
                            JSONArray refProjects = obj.getJSONArray("reference_projects");
                            for (int i = 0; i < refProjects.length(); ++i) {
                                project.getReferences().add(refProjects.getJSONObject(i).getString("project"));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to read " + refSettingsFile.getAbsolutePath()));
                    }
                }
                this.getLog().info((CharSequence)("  Found project:" + VersionUtils.create(this.getLog()).buildMessage((File)file)));
            } else {
                this.getLog().info((CharSequence)("  Not valid folder (no talend project) in:" + projectName));
            }
        });
        if (this.pattern != null) {
            Map<String, TalendProject> selectedProjects = this.projectMap.entrySet().stream().filter(en -> this.pattern.matcher((CharSequence)en.getKey()).matches()).peek(en -> {
                ((TalendProject)en.getValue()).setItemFilter(this.itemFilter);
                if (this.itemFilter != null) {
                    ((TalendProject)en.getValue()).setIncludeDependencies(this.includeDependencies);
                }
            }).collect(Collectors.toMap(en -> (String)en.getKey(), en -> (TalendProject)en.getValue()));
            String propStr = this.session.getUserProperties().getProperty("talend.child.lifecycle.skip");
            if (!selectedProjects.isEmpty() && propStr != null && Boolean.valueOf(propStr).booleanValue() && this.itemFilter != null) {
                StringBuilder builder = new StringBuilder();
                selectedProjects.keySet().forEach(project -> builder.append((String)project).append(","));
                String mainProjects = StringUtils.stripEnd(builder.toString(), ",");
                this.session.getUserProperties().setProperty("talend.main.projects", mainProjects);
            }
            HashSet refProjects = new HashSet();
            HashSet missingProjects = new HashSet();
            selectedProjects.values().forEach(p -> this.findAllReferenceProjects((TalendProject)p, refProjects, missingProjects));
            if (!missingProjects.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Some projects are not found: ");
                missingProjects.forEach(p -> builder.append((String)p).append(","));
                String msg = StringUtils.removeEnd(builder.toString(), ",");
                this.getLog().warn((CharSequence)msg);
            }
            refProjects.stream().filter(p -> !selectedProjects.containsKey(p.getName())).forEach(p -> selectedProjects.put(p.getName(), (TalendProject)p));
            this.projectMap.clear();
            this.projectMap.putAll(selectedProjects);
        } else {
            this.projectMap.values().forEach(project -> {
                project.setItemFilter(this.itemFilter);
                if (this.itemFilter != null) {
                    project.setIncludeDependencies(this.includeDependencies);
                }
            });
        }
        this.projectMap.values().forEach(project -> this.findReferencedLevel((TalendProject)project, this.projectMap, 0));
        this.talendProjectList = this.projectMap.values().stream().sorted((p1, p2) -> p2.getLevel() - p1.getLevel()).collect(Collectors.toList());
        if (this.talendProjectList.isEmpty()) {
            throw new MojoExecutionException("No valid talend projects");
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Generate Order:");
        this.getLog().info((CharSequence)"");
        this.talendProjectList.forEach(p -> this.getLog().info((CharSequence)("  |--" + p.getName())));
    }

    @Override
    protected void checkCompatiable() throws MojoFailureException, MojoExecutionException {
        VersionUtils.create(this.getLog()).checkCompatiable((JobBuilder)this, this.commandlineWorkspace, this.productPath);
    }

    private void findAllReferenceProjects(TalendProject project, Set<TalendProject> refProjects, Set<String> missingProjects) {
        List<String> references = project.getReferences();
        references.forEach(r -> {
            TalendProject refProject = this.projectMap.get(r);
            if (refProject == null) {
                missingProjects.add((String)r);
            } else {
                refProjects.add(refProject);
                this.findAllReferenceProjects(refProject, refProjects, missingProjects);
            }
        });
    }

    private void findReferencedLevel(TalendProject project, Map<String, TalendProject> projectMap, int count) {
        project.setLevel(count);
        project.getReferences().stream().filter(p -> projectMap.containsKey(p)).forEach(p -> this.findReferencedLevel((TalendProject)projectMap.get(p), projectMap, count + 1));
    }

    private void executeByServerCommandline() throws MojoExecutionException, MojoFailureException {
        CommandLineJavaClient client = new CommandLineJavaClient(this.commandlineHost, this.commandlinePort);
        try {
            client.connect();
        }
        catch (Exception e) {
            throw new MojoFailureException("Can't connect to Commandline server : " + client.getHostname() + " with port: " + client.getPort(), (Throwable)e);
        }
        this.addCommandAndCheck(client, new InitLocalCommand());
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Creating the detected projects for Commandline workspace.");
        Map<File, File> backupFilesMap = this.backupProjectFile();
        for (TalendProject project : this.talendProjectList) {
            this.addCommandAndCheck(client, new CreateProjectCommand(project.getName(), "from CI Builder", "java", this.commandlineUser));
            this.getLog().info((CharSequence)("  Created project (base on existing folder): " + project.getName()));
        }
        this.addCommandAndCheck(client, new LogoffProjectCommand());
        this.restoreProjectFile(backupFilesMap);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to regenerateAllPoms");
        for (TalendProject project : this.talendProjectList) {
            this.getLog().info((CharSequence)" Logon project");
            this.addCommandAndCheck(client, new LogonProjectCommand(project.getName(), this.commandlineUser, null, true));
            this.getLog().info((CharSequence)"regenerateAllPoms...");
            RegenerateAllPomsCommand cmd = new RegenerateAllPomsCommand(project.getItemFilter(), project.isIncludeDependencies());
            this.addCommandAndCheck(client, cmd);
            this.getLog().info((CharSequence)("cmd" + cmd + " finished successfully"));
            this.getLog().info((CharSequence)"Logoff project");
            this.addCommandAndCheck(client, new LogoffProjectCommand());
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Finished to generate all of poms");
        this.getLog().info((CharSequence)"*****************************************************");
        try {
            client.disconnect();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void executeByLocalCommandline() throws MojoExecutionException, MojoFailureException {
        this.prepareLocalExcution();
        ArrayList<IJavaCommand> commands = new ArrayList<IJavaCommand>();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to regenerateAllPoms");
        this.getLog().info((CharSequence)"Generating commandline script...");
        commands.add(new InitLocalCommand());
        for (TalendProject project : this.talendProjectList) {
            commands.add(new LogonProjectCommand(project.getName(), this.commandlineUser, null, true));
            RegenerateAllPomsCommand cmd = new RegenerateAllPomsCommand(project.getItemFilter(), project.isIncludeDependencies());
            commands.add(cmd);
            commands.add(new LogoffProjectCommand());
            this.getLog().info((CharSequence)("added command: " + cmd));
        }
        this.getLog().info((CharSequence)"Commandline script generated");
        this.getLog().info((CharSequence)"Executing script...");
        this.generateScriptAndRun(commands);
        this.getLog().info((CharSequence)"Script execution finished.");
        this.getLog().info((CharSequence)"Successfully regenerateAllPoms");
        this.getLog().info((CharSequence)"*****************************************************");
    }

    static class ReferenceCount {
        private TalendProject talendProject;
        private int referenceCount;
        private int referenceLevel;

        public void setReferenceLevel(int referenceLevel) {
            if (this.referenceLevel < referenceLevel) {
                this.referenceLevel = referenceLevel;
            }
        }

        public int getReferenceLevel() {
            return this.referenceLevel;
        }

        public void increaseReferenceLevel() {
            ++this.referenceLevel;
        }

        public TalendProject getTalendProject() {
            return this.talendProject;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public void increaseReferenceCount() {
            ++this.referenceCount;
        }

        public ReferenceCount(TalendProject project) {
            this.talendProject = project;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("name: ");
            sb.append(this.talendProject.getName());
            sb.append(",");
            sb.append("referenceLevel: ");
            sb.append(this.referenceLevel);
            sb.append(",");
            sb.append("referenceCount: ");
            sb.append(this.referenceCount);
            return sb.toString();
        }
    }
}

