/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.talend.commandline.client.CommandLineAbstractClient;
import org.talend.commandline.client.CommandLineJavaCLientException;
import org.talend.commandline.client.CommandLineJavaServerException;
import org.talend.commandline.client.util.ConsoleUtil;
import org.talend.commandline.client.util.ReaderWriterHandler;

public class CommandLineTextClient
extends CommandLineAbstractClient {
    public CommandLineTextClient(int port) {
        super(port);
    }

    public CommandLineTextClient(String hostname, Integer port) {
        super(hostname, port);
    }

    public CommandLineTextClient(String hostname) {
        super(hostname);
    }

    public static void main(String[] args) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException, InterruptedException {
        CommandLineTextClient client;
        if (args.length == 1) {
            client = new CommandLineTextClient(args[0]);
        } else if (args.length == 2) {
            client = new CommandLineTextClient(args[0], Integer.parseInt(args[1]));
        } else {
            System.out.println("Arguments : host [port]");
            return;
        }
        client.connect();
        client.init();
        client.disconnect();
    }

    private void init() throws IOException {
        ConsoleUtil.set();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String readLine = null;
        this.readUntilPrompt();
        boolean connected = true;
        while (connected) {
            try {
                readLine = bufferedReader.readLine();
                this.sendCommand(readLine);
                this.readUntilPrompt();
            }
            catch (IOException iOException) {
                connected = false;
                System.out.println("Connection closed by foreign host.");
            }
        }
        ConsoleUtil.unset();
    }

    private void readUntilPrompt() throws IOException {
        ReaderWriterHandler readerWriterHandler = new ReaderWriterHandler(this.inputStream, new OutputStreamWriter(System.out));
        readerWriterHandler.readUntil("talend> ");
    }
}

