/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class CreateProjectCommand
extends AbstractServerCommand {
    public CreateProjectCommand() {
    }

    public CreateProjectCommand(String projectName, String projectDescription, String projectLanguage, String projectAuthor, String projectAuthorPass) {
        this();
        this.setValue("PROJECT_NAME", projectName);
        this.setValue("PROJECT_DESCRIPTION", projectDescription);
        this.setValue("PROJECT_LANGUAGE", projectLanguage);
        this.setValue("PROJECT_AUTHOR", projectAuthor);
        this.setValue("PROJECT_AUTHOR_PASS", projectAuthorPass);
    }

    public CreateProjectCommand(String projectName, String projectDescription, String projectLanguage, String projectAuthor) {
        this(projectName, projectDescription, projectLanguage, projectAuthor, null);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(super.toString());
        buffer.append(" ");
        buffer.append(" name ");
        buffer.append(this.getProjectName());
        String projectDescription = this.getProjectDescription();
        if (projectDescription != null) {
            buffer.append(" description ");
            buffer.append(projectDescription);
        }
        buffer.append(" language ");
        buffer.append(this.getProjectLanguage());
        buffer.append(" author ");
        buffer.append(this.getProjectAuthor());
        String projectAuthorPass = this.getProjectAuthorPass();
        if (projectAuthorPass != null) {
            buffer.append(" password ");
            buffer.append(projectAuthorPass);
        }
        return buffer.toString();
    }

    @Override
    public String writeToString() {
        return this.writeToString(false);
    }

    @Override
    public String writeToString(boolean forDisplay) {
        CommandStringBuilder builder = new CommandStringBuilder("createProject");
        builder.addOptionWithArgument("pn", this.getProjectName());
        String projectDescription = this.getProjectDescription();
        if (projectDescription != null) {
            builder.addOptionWithArgument("pd", projectDescription);
        }
        builder.addOptionWithArgument("pl", this.getProjectLanguage());
        builder.addOptionWithArgument("pa", this.getProjectAuthor());
        String projectAuthorPass = this.getProjectAuthorPass();
        if (projectAuthorPass != null && projectAuthorPass.length() > 0) {
            builder.addOptionWithArgument("pap", this.getDisplayPassword(projectAuthorPass, forDisplay));
        }
        return builder.toString();
    }

    public String getProjectName() {
        return (String)this.getValue("PROJECT_NAME");
    }

    public String getProjectDescription() {
        return (String)this.getValue("PROJECT_DESCRIPTION");
    }

    public String getProjectLanguage() {
        return (String)this.getValue("PROJECT_LANGUAGE");
    }

    public String getProjectAuthor() {
        return (String)this.getValue("PROJECT_AUTHOR");
    }

    public String getProjectAuthorPass() {
        return (String)this.getValue("PROJECT_AUTHOR_PASS");
    }
}

