/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class ExportRouteServerCommand
extends AbstractServerCommand {
    public ExportRouteServerCommand() {
    }

    public ExportRouteServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportTOOsgi, boolean addAntScript, boolean addMavenScript, String buildType) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, false, exportTOOsgi, addAntScript, addMavenScript, "Runtime", false, false);
    }

    public ExportRouteServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportTOOsgi, boolean addAntScript, boolean addMavenScript, String buildType, boolean exportAsZip, boolean onlyExportDefaultContext) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, addStatisticsCode, exportTOOsgi, addAntScript, addMavenScript, buildType, exportAsZip, onlyExportDefaultContext, false);
    }

    public ExportRouteServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean addStatisticsCode, boolean exportTOOsgi, boolean addAntScript, boolean addMavenScript, String buildType, boolean exportAsZip, boolean onlyExportDefaultContext, boolean enablePrometheusMetricsEndpoint) {
        this();
        this.setValue("DESTINATION_DIRECTORY", destDir);
        this.setValue("AECHIVE_FILENAME", archiveFileName);
        this.setValue("ROUTE_NAME", jobName);
        this.setValue("JOB_CONTEXT", jobContext);
        this.setValue("JOB_VERSION", jobVersion);
        this.setValue("JOB_APPLY_CONTEXT_TO_CHILDREN", applyContextToChildren);
        this.setValue("JOB_ADD_STATISTICS_CODE", addStatisticsCode);
        this.setValue("JOB_ADD_MAVEN_SCRIPT", addMavenScript);
        this.setValue("JOB_ENABLE_PROMETHEUS_METRICS_ENDPOINT", enablePrometheusMetricsEndpoint);
        this.setValue("JOB_BUILD_TYPE", buildType);
        this.setValue("JOB_EXPORT_AS_ZIP", exportAsZip);
        this.setValue("JOB_EXPORT_ONLY_DEFAULT_CONTEXT", onlyExportDefaultContext);
    }

    public ExportRouteServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean exportTOOsgi, boolean addAntScript, boolean addMavenScript) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, false, exportTOOsgi, addAntScript, addMavenScript, "Runtime");
    }

    public ExportRouteServerCommand(String destDir, String archiveFileName, String jobName, String jobContext, String jobVersion, boolean applyContextToChildren, boolean exportTOOsgi, boolean addAntScript, boolean addMavenScript, String buildType) {
        this(destDir, archiveFileName, jobName, jobContext, jobVersion, applyContextToChildren, false, exportTOOsgi, addAntScript, addMavenScript, buildType);
    }

    public String getDestDir() {
        return (String)this.getValue("DESTINATION_DIRECTORY");
    }

    public String getJobName() {
        return (String)this.getValue("ROUTE_NAME");
    }

    public String getJobContext() {
        return (String)this.getValue("JOB_CONTEXT");
    }

    public String getJobVersion() {
        return (String)this.getValue("JOB_VERSION");
    }

    public String getBuildType() {
        return (String)this.getValue("JOB_BUILD_TYPE");
    }

    public String getArchiveFileName() {
        return (String)this.getValue("AECHIVE_FILENAME");
    }

    public boolean isApplyContextToChildren() {
        return this.getBooleanValue("JOB_APPLY_CONTEXT_TO_CHILDREN");
    }

    public boolean isAddStatisticsCode() {
        return this.getBooleanValue("JOB_ADD_STATISTICS_CODE");
    }

    public boolean isAddMavenScript() {
        return this.getBooleanValue("JOB_ADD_MAVEN_SCRIPT");
    }

    public boolean isEnableMetrics() {
        return this.getBooleanValue("JOB_ENABLE_PROMETHEUS_METRICS_ENDPOINT");
    }

    public boolean isExportAsZip() {
        return this.getBooleanValue("JOB_EXPORT_AS_ZIP");
    }

    public boolean isOnlyExportDefaultContext() {
        return this.getBooleanValue("JOB_EXPORT_ONLY_DEFAULT_CONTEXT");
    }

    @Override
    public String writeToString() {
        boolean isOnlyExportDefaultContext;
        boolean isExportAsZip;
        String buildType;
        boolean isEnableMetrics;
        boolean isAddMavenScript;
        boolean isAddStatisticsCode;
        boolean isApplyContextToChildren;
        String jobContext;
        String jobVersion;
        String archiveFileName;
        CommandStringBuilder builder = new CommandStringBuilder("exportRoute");
        builder.addArgument(this.getJobName());
        String destDir = this.getDestDir();
        if (destDir != null) {
            builder.addOptionWithArgument("dd", destDir);
        }
        if ((archiveFileName = this.getArchiveFileName()) != null) {
            builder.addOptionWithArgument("af", archiveFileName);
        }
        if ((jobVersion = this.getJobVersion()) != null) {
            builder.addOptionWithArgument("jv", jobVersion);
        }
        if ((jobContext = this.getJobContext()) != null) {
            builder.addOptionWithArgument("jc", jobContext);
        }
        if (isApplyContextToChildren = this.isApplyContextToChildren()) {
            builder.addOption("jactc");
        }
        if (isAddStatisticsCode = this.isAddStatisticsCode()) {
            builder.addOption("jstats");
        }
        if (isAddMavenScript = this.isAddMavenScript()) {
            builder.addOption("JOB_ADD_MAVEN_SCRIPT");
        }
        if (isEnableMetrics = this.isEnableMetrics()) {
            builder.addOption("JOB_ENABLE_PROMETHEUS_METRICS_ENDPOINT");
        }
        if ((buildType = this.getBuildType()) != null) {
            builder.addOptionWithArgument("JOB_BUILD_TYPE", buildType);
        }
        if (isExportAsZip = this.isExportAsZip()) {
            builder.addOption("JOB_EXPORT_AS_ZIP");
        }
        if (isOnlyExportDefaultContext = this.isOnlyExportDefaultContext()) {
            builder.addOption("JOB_EXPORT_ONLY_DEFAULT_CONTEXT");
        }
        return builder.toString();
    }
}

