/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.PublishServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class PublishJobServerCommand
extends PublishServerCommand {
    public String getJobName() {
        return (String)this.getValue("JOB_NAME");
    }

    public String getJobVersion() {
        return (String)this.getValue("VERSION");
    }

    public String getJobGroup() {
        return (String)this.getValue("GROUP");
    }

    public String getType() {
        return (String)this.getValue("TYPE");
    }

    public String getJobContext() {
        return (String)this.getValue("JOB_CONTEXT");
    }

    public boolean isApplyContextToChildren() {
        return this.getBooleanValue("JOB_APPLY_CONTEXT_TO_CHILDREN");
    }

    public boolean isIncludeContext() {
        return this.getBooleanValue("JOB_INCLUDE_CONTEXT");
    }

    public boolean isExecuteTests() {
        return this.getBooleanValue("JOB_EXECUTE_TESTS");
    }

    @Override
    public String writeToString() {
        String jobContext;
        String artifactId;
        String jobGroup;
        String publishVersion;
        CommandStringBuilder builder = new CommandStringBuilder("publishJob");
        builder.addArgument(this.getJobName());
        String routeVersion = this.getJobVersion();
        if (routeVersion != null) {
            builder.addOptionWithArgument("v", routeVersion);
        }
        if ((publishVersion = this.getPublishVersion()) != null) {
            builder.addOptionWithArgument("pv", publishVersion);
        }
        if ((jobGroup = this.getJobGroup()) != null) {
            builder.addOptionWithArgument("g", jobGroup);
        }
        if ((artifactId = this.getArtifactId()) != null) {
            builder.addOptionWithArgument("a", artifactId);
        }
        if (this.isSnapshot()) {
            builder.addOption("s");
        }
        builder.addOptionWithArgument("r", this.getArtifactRepository());
        builder.addOptionWithArgument("u", this.getUsername());
        String type = this.getType();
        if (type != null) {
            builder.addOptionWithArgument("t", type);
        }
        if ((jobContext = this.getJobContext()) != null) {
            builder.addOptionWithArgument("jc", jobContext);
        }
        if (this.isApplyContextToChildren()) {
            builder.addOption("jactc");
        }
        if (this.isIncludeContext()) {
            builder.addOption("ic");
        }
        if (this.isExecuteTests()) {
            builder.addOption("et");
        }
        builder.addOptionWithArgument("rt", this.getRepositoryType());
        return builder.toString();
    }
}

