/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.constant.model;

import java.util.ArrayList;
import java.util.List;
import org.talend.commandline.client.constant.model.ArgumentDefine;

public class CommandDefine {
    private int commandID;
    private String command;
    private String commandDesc;
    private List<ArgumentDefine> args = new ArrayList<ArgumentDefine>();

    public CommandDefine(int commandID, String command) {
        this.commandID = commandID;
        this.command = command;
        this.initArguments();
    }

    public CommandDefine(int commandID, String command, String commandDesc) {
        this(commandID, command);
        this.commandDesc = commandDesc;
    }

    protected void initArguments() {
    }

    public void addArguments(ArgumentDefine argDef) {
        if (argDef != null) {
            this.args.add(argDef);
        }
    }

    public int getCommandID() {
        return this.commandID;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandDesc() {
        return this.commandDesc;
    }

    public ArgumentDefine[] getArgs() {
        if (this.args != null) {
            return this.args.toArray(new ArgumentDefine[0]);
        }
        return new ArgumentDefine[0];
    }

    public ArgumentDefine findArg(String argName) {
        if (argName != null) {
            for (ArgumentDefine argDef : this.args) {
                if (!argName.equals(argDef.getArgName())) continue;
                return argDef;
            }
        }
        return null;
    }
}

