/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.talend.commandline.client.util.ConsoleReaderInputStream;

public final class ConsoleUtil {
    private ConsoleUtil() {
    }

    public static void unset() {
        ConsoleReaderInputStream.restoreIn();
    }

    public static void set() {
        ConsoleReader consoleReader = ConsoleUtil.getConsoleReader();
        if (consoleReader != null) {
            ConsoleReaderInputStream.setIn(consoleReader);
        }
    }

    public static ConsoleReader getConsoleReader() {
        ConsoleReader consoleReader = null;
        try {
            consoleReader = new ConsoleReader((InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)System.out, TerminalFactory.get());
            consoleReader.setHistory((History)new FileHistory(new File(System.getProperty("user.home"), ".commandline_history")));
        }
        catch (Throwable throwable) {
            ConsoleUtil.unset();
        }
        return consoleReader;
    }

    public static ConsoleReaderInputStream getConsoleReaderInputStream() {
        ConsoleReaderInputStream consoleReaderInputStream = null;
        ConsoleReader consoleReader = ConsoleUtil.getConsoleReader();
        if (consoleReader != null) {
            consoleReaderInputStream = new ConsoleReaderInputStream(consoleReader);
        }
        return consoleReaderInputStream;
    }
}

