/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.talend.ci.util.VersionUtils;
import org.talend.commandline.client.CommandLineJavaClient;
import org.talend.commandline.client.command.CreateProjectCommand;
import org.talend.commandline.client.command.IJavaCommand;
import org.talend.commandline.client.command.InitLocalCommand;
import org.talend.commandline.client.command.LogoffProjectCommand;
import org.talend.commandline.client.command.LogonProjectCommand;
import org.talend.commandline.client.command.extension.DetectCVECommand;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.model.TalendProject;
import org.talend.utils.json.JSONArray;
import org.talend.utils.json.JSONObject;

@Mojo(name="detectCVE", requiresProject=false)
public class CVEDetector
extends JobBuilder {
    protected String cveIndexFilePath;
    @Parameter(required=false, property="cveReportFilePath", defaultValue="./cvereport.csv")
    protected String cveReportFilePath;
    @Parameter(required=false, property="fromVersion")
    protected String fromVersion;
    protected String versionTo;
    protected String includeNotFixed = "false";
    @Parameter(required=false, property="workspace")
    protected String workSpace;
    @Parameter(required=false, property="projectFilter")
    protected String projectFilter;
    private static String OS = System.getProperty("os.name");

    @Override
    protected void exec() throws MojoExecutionException, MojoFailureException {
        File f = new File(this.cveReportFilePath);
        if (!f.isAbsolute()) {
            this.cveReportFilePath = f.getAbsolutePath();
        }
        if (StringUtils.containsIgnoreCase(OS, "win") && StringUtils.contains((CharSequence)this.cveReportFilePath, "\\")) {
            this.cveReportFilePath = this.cveReportFilePath.replace("\\", "\\\\");
        }
        if (StringUtils.isEmpty(this.workSpace)) {
            this.workSpace = new File("").getAbsolutePath();
        }
        this.commandlineWorkspace = this.workSpace;
        this.getLog().info((CharSequence)("commandlineWorkspace: " + new File(this.commandlineWorkspace).getAbsolutePath()));
        this.getLog().info((CharSequence)"*****************************************************");
        this.initializeProjectList();
        this.checkCompatiable();
        try {
            this.setConfigToCommandline();
        }
        catch (IOException e) {
            throw new MojoFailureException("Set ci-setting info failed.", (Throwable)e);
        }
        this.installCommandline();
        if (this.generationType.equals("server")) {
            this.executeByServerCommandline();
        } else if (this.generationType.equals("local")) {
            this.executeByLocalCommandline();
        }
    }

    @Override
    protected void initializeProjectList() throws MojoExecutionException {
        RuntimeException e;
        this.getLog().info((CharSequence)("List projects from:" + this.commandlineWorkspace));
        HashMap projectMap = new HashMap();
        File workspace = new File(this.commandlineWorkspace);
        if (workspace == null || !workspace.exists()) {
            throw new MojoExecutionException("Invalid or not existing workspace directory");
        }
        Stream.of(workspace.listFiles(File::isDirectory)).forEach(file -> {
            File talendProjectFile = new File((File)file, "talend.project");
            if (talendProjectFile.isFile() && talendProjectFile.exists()) {
                TalendProject project = new TalendProject((File)file, null);
                projectMap.put(project.getName(), project);
                File refSettingsFile = file.toPath().resolve(".settings").resolve("reference_projects.settings").toFile();
                if (refSettingsFile.exists()) {
                    try {
                        String jsonStr = new String(Files.readAllBytes(refSettingsFile.toPath()));
                        if (!jsonStr.isEmpty()) {
                            JSONObject obj = new JSONObject(jsonStr);
                            JSONArray refProjects = obj.getJSONArray("reference_projects");
                            for (int i = 0; i < refProjects.length(); ++i) {
                                project.getReferences().add(refProjects.getJSONObject(i).getString("project"));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("Failed to read " + refSettingsFile.getAbsolutePath()));
                    }
                }
                this.getLog().info((CharSequence)("  Found project:" + VersionUtils.create(this.getLog()).buildMessage((File)file)));
            } else {
                this.getLog().info((CharSequence)("  Not valid folder (no talend project) in:" + file.getName()));
            }
        });
        projectMap.values().forEach(project -> this.findReferencedLevel((TalendProject)project, projectMap, 0));
        this.talendProjectList = projectMap.values().stream().sorted((p1, p2) -> p2.getLevel() - p1.getLevel()).collect(Collectors.toList());
        if (this.talendProjectList.isEmpty()) {
            e = new RuntimeException("No valid talend projects");
            this.getLog().warn((Throwable)e);
        } else {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Generate Order:");
            this.getLog().info((CharSequence)"");
            this.talendProjectList.forEach(p -> this.getLog().info((CharSequence)("  |--" + p.getName())));
            if (!StringUtils.isEmpty(this.projectFilter)) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)("projectFilter: " + this.projectFilter));
                Pattern pattern = Pattern.compile(this.projectFilter);
                this.talendProjectList = this.talendProjectList.stream().filter(prj -> pattern.matcher(prj.getName()).matches()).collect(Collectors.toList());
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Project list after filter:");
                this.talendProjectList.forEach(p -> this.getLog().info((CharSequence)("  |--" + p.getName())));
            }
        }
        if (this.talendProjectList.isEmpty()) {
            e = new RuntimeException("No valid talend projects");
            this.getLog().warn((Throwable)e);
        }
    }

    @Override
    protected void checkCompatiable() throws MojoFailureException, MojoExecutionException {
        VersionUtils.create(this.getLog()).checkCompatiable((JobBuilder)this, this.commandlineWorkspace, this.productPath);
    }

    private void findReferencedLevel(TalendProject project, Map<String, TalendProject> projectMap, int count) {
        project.setLevel(count);
        project.getReferences().stream().filter(p -> projectMap.containsKey(p)).forEach(p -> this.findReferencedLevel((TalendProject)projectMap.get(p), projectMap, count + 1));
    }

    private void executeByServerCommandline() throws MojoExecutionException, MojoFailureException {
        if (this.talendProjectList.isEmpty()) {
            return;
        }
        CommandLineJavaClient client = new CommandLineJavaClient(this.commandlineHost, this.commandlinePort);
        try {
            client.connect();
        }
        catch (Exception e) {
            throw new MojoFailureException("Can't connect to Commandline server : " + client.getHostname() + " with port: " + client.getPort(), (Throwable)e);
        }
        this.addCommandAndCheck(client, new InitLocalCommand());
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Creating the detected projects for Commandline workspace.");
        Map<File, File> backupFilesMap = this.backupProjectFile();
        for (TalendProject project : this.talendProjectList) {
            this.addCommandAndCheck(client, new CreateProjectCommand(project.getName(), "from CI Builder", "java", this.commandlineUser));
            this.getLog().info((CharSequence)("  Created project (base on existing folder): " + project.getName()));
        }
        this.addCommandAndCheck(client, new LogoffProjectCommand());
        this.restoreProjectFile(backupFilesMap);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to detectCVE");
        for (TalendProject project : this.talendProjectList) {
            this.getLog().info((CharSequence)" Logon project");
            this.addCommandAndCheck(client, new LogonProjectCommand(project.getName(), this.commandlineUser, null, true));
            this.getLog().info((CharSequence)"detectCVE...");
            DetectCVECommand cmd = new DetectCVECommand(this.cveIndexFilePath, this.cveReportFilePath, this.fromVersion, this.versionTo, this.includeNotFixed);
            this.addCommandAndCheck(client, cmd);
            this.getLog().info((CharSequence)("cmd" + cmd + " finished successfully"));
            this.getLog().info((CharSequence)"Logoff project");
            this.addCommandAndCheck(client, new LogoffProjectCommand());
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Finished to run detectCVE");
        this.getLog().info((CharSequence)"*****************************************************");
        try {
            client.disconnect();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void executeByLocalCommandline() throws MojoExecutionException, MojoFailureException {
        if (this.talendProjectList.isEmpty()) {
            return;
        }
        this.prepareLocalExcution();
        ArrayList<IJavaCommand> commands = new ArrayList<IJavaCommand>();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to detectCVE");
        this.getLog().info((CharSequence)"Generating commandline script...");
        commands.add(new InitLocalCommand());
        for (TalendProject project : this.talendProjectList) {
            commands.add(new LogonProjectCommand(project.getName(), this.commandlineUser, null, true));
            DetectCVECommand cmd = new DetectCVECommand(this.cveIndexFilePath, this.cveReportFilePath, this.fromVersion, this.versionTo, this.includeNotFixed);
            commands.add(cmd);
            commands.add(new LogoffProjectCommand());
            this.getLog().info((CharSequence)("added command: " + cmd));
        }
        this.getLog().info((CharSequence)"Commandline script generated");
        this.getLog().info((CharSequence)"Executing script...");
        this.generateScriptAndRun(commands);
        this.getLog().info((CharSequence)"Script execution finished.");
        this.getLog().info((CharSequence)"Successfully detectCVE");
        this.getLog().info((CharSequence)"*****************************************************");
    }
}

