/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BoundedExecutor {
    private final ExecutorService exec;
    private final Semaphore semaphore;

    public BoundedExecutor(ExecutorService exec, int bound) {
        this.exec = exec;
        this.semaphore = new Semaphore(bound);
    }

    public BoundedExecutor(String poolName, int bound) {
        this.exec = this.intializeBoundedPool(poolName, bound);
        this.semaphore = new Semaphore(bound);
    }

    protected ThreadPoolExecutor intializeBoundedPool(final String poolName, int poolSize) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.SECONDS, workQueue, new ThreadFactory(){
            ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = this.defaultThreadFactory.newThread(r);
                newThread.setName(poolName + "_" + newThread.getName());
                return newThread;
            }
        });
        return threadPoolExecutor;
    }

    public void submitTask(final Runnable command) throws InterruptedException, RejectedExecutionException {
        this.semaphore.acquire();
        try {
            this.exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        BoundedExecutor.this.semaphore.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
            throw e;
        }
    }

    public ExecutorService getExecutorService() {
        return this.exec;
    }
}

