/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.talend.components.common.httpclient.api.BodyFormat;
import org.talend.components.common.httpclient.api.DefaultConfigurationValues;
import org.talend.components.common.httpclient.api.KeyValuePair;
import org.talend.components.common.httpclient.api.OauthQueryConfiguration;
import org.talend.components.common.httpclient.api.ProxyConfiguration;
import org.talend.components.common.httpclient.api.ResponseFormat;
import org.talend.components.common.httpclient.api.RetryWithBackoff;
import org.talend.components.common.httpclient.api.attachments.AttachmentsConfiguration;
import org.talend.components.common.httpclient.api.authentication.AuthenticationType;
import org.talend.components.common.httpclient.api.authentication.LoginPassword;
import org.talend.components.common.httpclient.api.jsondecorator.JSONDecoratorConfig;
import org.talend.components.common.httpclient.api.pagination.OffsetLimitPagination;

public class QueryConfiguration {
    private String url;
    private String method;
    private long connectionTimeout = DefaultConfigurationValues.HTTP_CLIENT_CONNECT_TIMEOUT_VALUE;
    private long receiveTimeout = DefaultConfigurationValues.HTTP_CLIENT_RECEIVE_TIMEOUT_VALUE;
    private boolean bypassCertificateValidation = false;
    private AuthenticationType authenticationType = AuthenticationType.None;
    private LoginPassword loginPassword;
    private String authorizationToken;
    private Map<String, String> urlPathParams = new HashMap<String, String>();
    private List<KeyValuePair> queryParams = new ArrayList<KeyValuePair>();
    private List<KeyValuePair> headers = new ArrayList<KeyValuePair>();
    private BodyFormat bodyType;
    private List<KeyValuePair> bodyQueryParams = new ArrayList<KeyValuePair>();
    private String filePath;
    private String plainTextBody;
    private boolean decompressResponsePayload;
    private OauthQueryConfiguration oauthCall;
    private Optional<String> oAuthTokenCacheKey = Optional.empty();
    private boolean acceptRedirections = DefaultConfigurationValues.HTTP_CLIENT_ACCEPT_REDIRECTIONS_VALUE;
    private int maxNumberOfAcceptedRedirectionsOnSameURI = DefaultConfigurationValues.HTTP_CLIENT_MAX_NUMBER_REDIRECTIONS_ON_SAME_URI_VALUE;
    private boolean acceptOnlySameHostRedirection = DefaultConfigurationValues.HTTP_CLIENT_ACCEPT_ONLY_SAME_HOST_REDIRECTIONS_VALUE;
    private boolean acceptRelativeURLRedirection = DefaultConfigurationValues.HTTP_CLIENT_ACCEPT_RELATIVE_REDIRECTIONS_VALUE;
    private String allowedURIRedirection;
    private ResponseFormat responseFormat;
    private ProxyConfiguration proxy;
    private boolean initPaginationDone = false;
    private OffsetLimitPagination offsetLimitPagination;
    private RetryWithBackoff retryWithBackoff;
    private JSONDecoratorConfig jsonDecoratorConfig = new JSONDecoratorConfig();
    private String apiKeyHeaderName;
    private boolean readCookies;
    private boolean saveCookies;
    private String cookieContainerDirectory;
    private boolean keepSession;
    private AttachmentsConfiguration attachmentsConfiguration = new AttachmentsConfiguration();

    public void setOauthCall(QueryConfiguration oauthCall) {
        this.oauthCall = new OauthQueryConfiguration(oauthCall);
    }

    void setApiKeyHeaderName(String name) {
        this.apiKeyHeaderName = name;
    }

    @Generated
    public QueryConfiguration() {
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @Generated
    public boolean isBypassCertificateValidation() {
        return this.bypassCertificateValidation;
    }

    @Generated
    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public LoginPassword getLoginPassword() {
        return this.loginPassword;
    }

    @Generated
    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    @Generated
    public Map<String, String> getUrlPathParams() {
        return this.urlPathParams;
    }

    @Generated
    public List<KeyValuePair> getQueryParams() {
        return this.queryParams;
    }

    @Generated
    public List<KeyValuePair> getHeaders() {
        return this.headers;
    }

    @Generated
    public BodyFormat getBodyType() {
        return this.bodyType;
    }

    @Generated
    public List<KeyValuePair> getBodyQueryParams() {
        return this.bodyQueryParams;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Generated
    public String getPlainTextBody() {
        return this.plainTextBody;
    }

    @Generated
    public boolean isDecompressResponsePayload() {
        return this.decompressResponsePayload;
    }

    @Generated
    public OauthQueryConfiguration getOauthCall() {
        return this.oauthCall;
    }

    @Generated
    public Optional<String> getOAuthTokenCacheKey() {
        return this.oAuthTokenCacheKey;
    }

    @Generated
    public boolean isAcceptRedirections() {
        return this.acceptRedirections;
    }

    @Generated
    public int getMaxNumberOfAcceptedRedirectionsOnSameURI() {
        return this.maxNumberOfAcceptedRedirectionsOnSameURI;
    }

    @Generated
    public boolean isAcceptOnlySameHostRedirection() {
        return this.acceptOnlySameHostRedirection;
    }

    @Generated
    public boolean isAcceptRelativeURLRedirection() {
        return this.acceptRelativeURLRedirection;
    }

    @Generated
    public String getAllowedURIRedirection() {
        return this.allowedURIRedirection;
    }

    @Generated
    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    @Generated
    public boolean isInitPaginationDone() {
        return this.initPaginationDone;
    }

    @Generated
    public OffsetLimitPagination getOffsetLimitPagination() {
        return this.offsetLimitPagination;
    }

    @Generated
    public RetryWithBackoff getRetryWithBackoff() {
        return this.retryWithBackoff;
    }

    @Generated
    public JSONDecoratorConfig getJsonDecoratorConfig() {
        return this.jsonDecoratorConfig;
    }

    @Generated
    public String getApiKeyHeaderName() {
        return this.apiKeyHeaderName;
    }

    @Generated
    public boolean isReadCookies() {
        return this.readCookies;
    }

    @Generated
    public boolean isSaveCookies() {
        return this.saveCookies;
    }

    @Generated
    public String getCookieContainerDirectory() {
        return this.cookieContainerDirectory;
    }

    @Generated
    public boolean isKeepSession() {
        return this.keepSession;
    }

    @Generated
    public AttachmentsConfiguration getAttachmentsConfiguration() {
        return this.attachmentsConfiguration;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    @Generated
    public void setBypassCertificateValidation(boolean bypassCertificateValidation) {
        this.bypassCertificateValidation = bypassCertificateValidation;
    }

    @Generated
    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    @Generated
    public void setLoginPassword(LoginPassword loginPassword) {
        this.loginPassword = loginPassword;
    }

    @Generated
    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    @Generated
    public void setUrlPathParams(Map<String, String> urlPathParams) {
        this.urlPathParams = urlPathParams;
    }

    @Generated
    public void setQueryParams(List<KeyValuePair> queryParams) {
        this.queryParams = queryParams;
    }

    @Generated
    public void setHeaders(List<KeyValuePair> headers) {
        this.headers = headers;
    }

    @Generated
    public void setBodyType(BodyFormat bodyType) {
        this.bodyType = bodyType;
    }

    @Generated
    public void setBodyQueryParams(List<KeyValuePair> bodyQueryParams) {
        this.bodyQueryParams = bodyQueryParams;
    }

    @Generated
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Generated
    public void setPlainTextBody(String plainTextBody) {
        this.plainTextBody = plainTextBody;
    }

    @Generated
    public void setDecompressResponsePayload(boolean decompressResponsePayload) {
        this.decompressResponsePayload = decompressResponsePayload;
    }

    @Generated
    public void setOAuthTokenCacheKey(Optional<String> oAuthTokenCacheKey) {
        this.oAuthTokenCacheKey = oAuthTokenCacheKey;
    }

    @Generated
    public void setAcceptRedirections(boolean acceptRedirections) {
        this.acceptRedirections = acceptRedirections;
    }

    @Generated
    public void setMaxNumberOfAcceptedRedirectionsOnSameURI(int maxNumberOfAcceptedRedirectionsOnSameURI) {
        this.maxNumberOfAcceptedRedirectionsOnSameURI = maxNumberOfAcceptedRedirectionsOnSameURI;
    }

    @Generated
    public void setAcceptOnlySameHostRedirection(boolean acceptOnlySameHostRedirection) {
        this.acceptOnlySameHostRedirection = acceptOnlySameHostRedirection;
    }

    @Generated
    public void setAcceptRelativeURLRedirection(boolean acceptRelativeURLRedirection) {
        this.acceptRelativeURLRedirection = acceptRelativeURLRedirection;
    }

    @Generated
    public void setAllowedURIRedirection(String allowedURIRedirection) {
        this.allowedURIRedirection = allowedURIRedirection;
    }

    @Generated
    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @Generated
    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setInitPaginationDone(boolean initPaginationDone) {
        this.initPaginationDone = initPaginationDone;
    }

    @Generated
    public void setOffsetLimitPagination(OffsetLimitPagination offsetLimitPagination) {
        this.offsetLimitPagination = offsetLimitPagination;
    }

    @Generated
    public void setRetryWithBackoff(RetryWithBackoff retryWithBackoff) {
        this.retryWithBackoff = retryWithBackoff;
    }

    @Generated
    public void setJsonDecoratorConfig(JSONDecoratorConfig jsonDecoratorConfig) {
        this.jsonDecoratorConfig = jsonDecoratorConfig;
    }

    @Generated
    public void setReadCookies(boolean readCookies) {
        this.readCookies = readCookies;
    }

    @Generated
    public void setSaveCookies(boolean saveCookies) {
        this.saveCookies = saveCookies;
    }

    @Generated
    public void setCookieContainerDirectory(String cookieContainerDirectory) {
        this.cookieContainerDirectory = cookieContainerDirectory;
    }

    @Generated
    public void setKeepSession(boolean keepSession) {
        this.keepSession = keepSession;
    }

    @Generated
    public void setAttachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration) {
        this.attachmentsConfiguration = attachmentsConfiguration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryConfiguration)) {
            return false;
        }
        QueryConfiguration other = (QueryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getReceiveTimeout() != other.getReceiveTimeout()) {
            return false;
        }
        if (this.isBypassCertificateValidation() != other.isBypassCertificateValidation()) {
            return false;
        }
        if (this.isDecompressResponsePayload() != other.isDecompressResponsePayload()) {
            return false;
        }
        if (this.isAcceptRedirections() != other.isAcceptRedirections()) {
            return false;
        }
        if (this.getMaxNumberOfAcceptedRedirectionsOnSameURI() != other.getMaxNumberOfAcceptedRedirectionsOnSameURI()) {
            return false;
        }
        if (this.isAcceptOnlySameHostRedirection() != other.isAcceptOnlySameHostRedirection()) {
            return false;
        }
        if (this.isAcceptRelativeURLRedirection() != other.isAcceptRelativeURLRedirection()) {
            return false;
        }
        if (this.isInitPaginationDone() != other.isInitPaginationDone()) {
            return false;
        }
        if (this.isReadCookies() != other.isReadCookies()) {
            return false;
        }
        if (this.isSaveCookies() != other.isSaveCookies()) {
            return false;
        }
        if (this.isKeepSession() != other.isKeepSession()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        AuthenticationType this$authenticationType = this.getAuthenticationType();
        AuthenticationType other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !((Object)((Object)this$authenticationType)).equals((Object)other$authenticationType)) {
            return false;
        }
        LoginPassword this$loginPassword = this.getLoginPassword();
        LoginPassword other$loginPassword = other.getLoginPassword();
        if (this$loginPassword == null ? other$loginPassword != null : !((Object)this$loginPassword).equals(other$loginPassword)) {
            return false;
        }
        String this$authorizationToken = this.getAuthorizationToken();
        String other$authorizationToken = other.getAuthorizationToken();
        if (this$authorizationToken == null ? other$authorizationToken != null : !this$authorizationToken.equals(other$authorizationToken)) {
            return false;
        }
        Map<String, String> this$urlPathParams = this.getUrlPathParams();
        Map<String, String> other$urlPathParams = other.getUrlPathParams();
        if (this$urlPathParams == null ? other$urlPathParams != null : !((Object)this$urlPathParams).equals(other$urlPathParams)) {
            return false;
        }
        List<KeyValuePair> this$queryParams = this.getQueryParams();
        List<KeyValuePair> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        List<KeyValuePair> this$headers = this.getHeaders();
        List<KeyValuePair> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        BodyFormat this$bodyType = this.getBodyType();
        BodyFormat other$bodyType = other.getBodyType();
        if (this$bodyType == null ? other$bodyType != null : !((Object)((Object)this$bodyType)).equals((Object)other$bodyType)) {
            return false;
        }
        List<KeyValuePair> this$bodyQueryParams = this.getBodyQueryParams();
        List<KeyValuePair> other$bodyQueryParams = other.getBodyQueryParams();
        if (this$bodyQueryParams == null ? other$bodyQueryParams != null : !((Object)this$bodyQueryParams).equals(other$bodyQueryParams)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$plainTextBody = this.getPlainTextBody();
        String other$plainTextBody = other.getPlainTextBody();
        if (this$plainTextBody == null ? other$plainTextBody != null : !this$plainTextBody.equals(other$plainTextBody)) {
            return false;
        }
        OauthQueryConfiguration this$oauthCall = this.getOauthCall();
        OauthQueryConfiguration other$oauthCall = other.getOauthCall();
        if (this$oauthCall == null ? other$oauthCall != null : !this$oauthCall.equals(other$oauthCall)) {
            return false;
        }
        Optional<String> this$oAuthTokenCacheKey = this.getOAuthTokenCacheKey();
        Optional<String> other$oAuthTokenCacheKey = other.getOAuthTokenCacheKey();
        if (this$oAuthTokenCacheKey == null ? other$oAuthTokenCacheKey != null : !((Object)this$oAuthTokenCacheKey).equals(other$oAuthTokenCacheKey)) {
            return false;
        }
        String this$allowedURIRedirection = this.getAllowedURIRedirection();
        String other$allowedURIRedirection = other.getAllowedURIRedirection();
        if (this$allowedURIRedirection == null ? other$allowedURIRedirection != null : !this$allowedURIRedirection.equals(other$allowedURIRedirection)) {
            return false;
        }
        ResponseFormat this$responseFormat = this.getResponseFormat();
        ResponseFormat other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !((Object)((Object)this$responseFormat)).equals((Object)other$responseFormat)) {
            return false;
        }
        ProxyConfiguration this$proxy = this.getProxy();
        ProxyConfiguration other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        OffsetLimitPagination this$offsetLimitPagination = this.getOffsetLimitPagination();
        OffsetLimitPagination other$offsetLimitPagination = other.getOffsetLimitPagination();
        if (this$offsetLimitPagination == null ? other$offsetLimitPagination != null : !((Object)this$offsetLimitPagination).equals(other$offsetLimitPagination)) {
            return false;
        }
        RetryWithBackoff this$retryWithBackoff = this.getRetryWithBackoff();
        RetryWithBackoff other$retryWithBackoff = other.getRetryWithBackoff();
        if (this$retryWithBackoff == null ? other$retryWithBackoff != null : !((Object)this$retryWithBackoff).equals(other$retryWithBackoff)) {
            return false;
        }
        JSONDecoratorConfig this$jsonDecoratorConfig = this.getJsonDecoratorConfig();
        JSONDecoratorConfig other$jsonDecoratorConfig = other.getJsonDecoratorConfig();
        if (this$jsonDecoratorConfig == null ? other$jsonDecoratorConfig != null : !this$jsonDecoratorConfig.equals(other$jsonDecoratorConfig)) {
            return false;
        }
        String this$apiKeyHeaderName = this.getApiKeyHeaderName();
        String other$apiKeyHeaderName = other.getApiKeyHeaderName();
        if (this$apiKeyHeaderName == null ? other$apiKeyHeaderName != null : !this$apiKeyHeaderName.equals(other$apiKeyHeaderName)) {
            return false;
        }
        String this$cookieContainerDirectory = this.getCookieContainerDirectory();
        String other$cookieContainerDirectory = other.getCookieContainerDirectory();
        if (this$cookieContainerDirectory == null ? other$cookieContainerDirectory != null : !this$cookieContainerDirectory.equals(other$cookieContainerDirectory)) {
            return false;
        }
        AttachmentsConfiguration this$attachmentsConfiguration = this.getAttachmentsConfiguration();
        AttachmentsConfiguration other$attachmentsConfiguration = other.getAttachmentsConfiguration();
        return !(this$attachmentsConfiguration == null ? other$attachmentsConfiguration != null : !((Object)this$attachmentsConfiguration).equals(other$attachmentsConfiguration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + (int)($connectionTimeout >>> 32 ^ $connectionTimeout);
        long $receiveTimeout = this.getReceiveTimeout();
        result = result * 59 + (int)($receiveTimeout >>> 32 ^ $receiveTimeout);
        result = result * 59 + (this.isBypassCertificateValidation() ? 79 : 97);
        result = result * 59 + (this.isDecompressResponsePayload() ? 79 : 97);
        result = result * 59 + (this.isAcceptRedirections() ? 79 : 97);
        result = result * 59 + this.getMaxNumberOfAcceptedRedirectionsOnSameURI();
        result = result * 59 + (this.isAcceptOnlySameHostRedirection() ? 79 : 97);
        result = result * 59 + (this.isAcceptRelativeURLRedirection() ? 79 : 97);
        result = result * 59 + (this.isInitPaginationDone() ? 79 : 97);
        result = result * 59 + (this.isReadCookies() ? 79 : 97);
        result = result * 59 + (this.isSaveCookies() ? 79 : 97);
        result = result * 59 + (this.isKeepSession() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        AuthenticationType $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : ((Object)((Object)$authenticationType)).hashCode());
        LoginPassword $loginPassword = this.getLoginPassword();
        result = result * 59 + ($loginPassword == null ? 43 : ((Object)$loginPassword).hashCode());
        String $authorizationToken = this.getAuthorizationToken();
        result = result * 59 + ($authorizationToken == null ? 43 : $authorizationToken.hashCode());
        Map<String, String> $urlPathParams = this.getUrlPathParams();
        result = result * 59 + ($urlPathParams == null ? 43 : ((Object)$urlPathParams).hashCode());
        List<KeyValuePair> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        List<KeyValuePair> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        BodyFormat $bodyType = this.getBodyType();
        result = result * 59 + ($bodyType == null ? 43 : ((Object)((Object)$bodyType)).hashCode());
        List<KeyValuePair> $bodyQueryParams = this.getBodyQueryParams();
        result = result * 59 + ($bodyQueryParams == null ? 43 : ((Object)$bodyQueryParams).hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $plainTextBody = this.getPlainTextBody();
        result = result * 59 + ($plainTextBody == null ? 43 : $plainTextBody.hashCode());
        OauthQueryConfiguration $oauthCall = this.getOauthCall();
        result = result * 59 + ($oauthCall == null ? 43 : $oauthCall.hashCode());
        Optional<String> $oAuthTokenCacheKey = this.getOAuthTokenCacheKey();
        result = result * 59 + ($oAuthTokenCacheKey == null ? 43 : ((Object)$oAuthTokenCacheKey).hashCode());
        String $allowedURIRedirection = this.getAllowedURIRedirection();
        result = result * 59 + ($allowedURIRedirection == null ? 43 : $allowedURIRedirection.hashCode());
        ResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)((Object)$responseFormat)).hashCode());
        ProxyConfiguration $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        OffsetLimitPagination $offsetLimitPagination = this.getOffsetLimitPagination();
        result = result * 59 + ($offsetLimitPagination == null ? 43 : ((Object)$offsetLimitPagination).hashCode());
        RetryWithBackoff $retryWithBackoff = this.getRetryWithBackoff();
        result = result * 59 + ($retryWithBackoff == null ? 43 : ((Object)$retryWithBackoff).hashCode());
        JSONDecoratorConfig $jsonDecoratorConfig = this.getJsonDecoratorConfig();
        result = result * 59 + ($jsonDecoratorConfig == null ? 43 : $jsonDecoratorConfig.hashCode());
        String $apiKeyHeaderName = this.getApiKeyHeaderName();
        result = result * 59 + ($apiKeyHeaderName == null ? 43 : $apiKeyHeaderName.hashCode());
        String $cookieContainerDirectory = this.getCookieContainerDirectory();
        result = result * 59 + ($cookieContainerDirectory == null ? 43 : $cookieContainerDirectory.hashCode());
        AttachmentsConfiguration $attachmentsConfiguration = this.getAttachmentsConfiguration();
        result = result * 59 + ($attachmentsConfiguration == null ? 43 : ((Object)$attachmentsConfiguration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueryConfiguration(url=" + this.getUrl() + ", method=" + this.getMethod() + ", connectionTimeout=" + this.getConnectionTimeout() + ", receiveTimeout=" + this.getReceiveTimeout() + ", bypassCertificateValidation=" + this.isBypassCertificateValidation() + ", authenticationType=" + (Object)((Object)this.getAuthenticationType()) + ", loginPassword=" + this.getLoginPassword() + ", authorizationToken=" + this.getAuthorizationToken() + ", urlPathParams=" + this.getUrlPathParams() + ", queryParams=" + this.getQueryParams() + ", headers=" + this.getHeaders() + ", bodyType=" + (Object)((Object)this.getBodyType()) + ", bodyQueryParams=" + this.getBodyQueryParams() + ", filePath=" + this.getFilePath() + ", plainTextBody=" + this.getPlainTextBody() + ", decompressResponsePayload=" + this.isDecompressResponsePayload() + ", oauthCall=" + this.getOauthCall() + ", oAuthTokenCacheKey=" + this.getOAuthTokenCacheKey() + ", acceptRedirections=" + this.isAcceptRedirections() + ", maxNumberOfAcceptedRedirectionsOnSameURI=" + this.getMaxNumberOfAcceptedRedirectionsOnSameURI() + ", acceptOnlySameHostRedirection=" + this.isAcceptOnlySameHostRedirection() + ", acceptRelativeURLRedirection=" + this.isAcceptRelativeURLRedirection() + ", allowedURIRedirection=" + this.getAllowedURIRedirection() + ", responseFormat=" + (Object)((Object)this.getResponseFormat()) + ", proxy=" + this.getProxy() + ", initPaginationDone=" + this.isInitPaginationDone() + ", offsetLimitPagination=" + this.getOffsetLimitPagination() + ", retryWithBackoff=" + this.getRetryWithBackoff() + ", jsonDecoratorConfig=" + this.getJsonDecoratorConfig() + ", apiKeyHeaderName=" + this.getApiKeyHeaderName() + ", readCookies=" + this.isReadCookies() + ", saveCookies=" + this.isSaveCookies() + ", cookieContainerDirectory=" + this.getCookieContainerDirectory() + ", keepSession=" + this.isKeepSession() + ", attachmentsConfiguration=" + this.getAttachmentsConfiguration() + ")";
    }
}

