/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api.substitutor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;

public class Substitutor {
    private static final char ESCAPE = '\\';
    private static final String DEFAULT_SEPARATOR = ":-";
    private final UnaryOperator<String> placeholderProvider;
    private final PlaceholderConfiguration finder;

    public Substitutor(PlaceholderConfiguration finder, UnaryOperator<String> placeholderProvider) {
        this.finder = finder;
        this.placeholderProvider = placeholderProvider instanceof CachedPlaceHolder ? placeholderProvider : new CachedPlaceHolder(placeholderProvider);
    }

    public UnaryOperator<String> getPlaceholderProvider() {
        return this.placeholderProvider;
    }

    public String replace(String source) {
        if (source == null) {
            return source;
        }
        if (source.trim().isEmpty()) {
            return source;
        }
        int prefixLength = this.finder.getOpenerWithKeyPrefix().length();
        int suffixLength = this.finder.getCloser().length();
        if (source.length() < prefixLength + suffixLength) {
            return source;
        }
        StringBuilder output = new StringBuilder();
        int cursor = 0;
        boolean foundKey = false;
        int indSuffix = 0;
        do {
            foundKey = false;
            int indPrefix = source.indexOf(this.finder.getOpenerWithKeyPrefix(), cursor);
            if (indPrefix < 0) {
                output.append(source.substring(cursor));
                continue;
            }
            boolean escaped = false;
            if (indPrefix > 0) {
                char previous = source.charAt(indPrefix - 1);
                boolean bl = escaped = previous == '\\';
            }
            if (escaped) {
                output.append(source.substring(cursor, indPrefix - 1)).append(this.finder.getOpenerWithKeyPrefix());
                cursor = indPrefix + prefixLength;
                foundKey = true;
                continue;
            }
            int indIntermediatePrefix = indPrefix;
            boolean hasPrefixIntermediate = false;
            do {
                hasPrefixIntermediate = false;
                indSuffix = source.indexOf(this.finder.getCloser(), indIntermediatePrefix);
                if (indSuffix < 0) continue;
                indIntermediatePrefix = source.indexOf(this.finder.getOpener(), indIntermediatePrefix + 1);
                boolean bl = hasPrefixIntermediate = indIntermediatePrefix >= 0 && indIntermediatePrefix < indSuffix;
                if (!hasPrefixIntermediate) continue;
                indIntermediatePrefix = indSuffix + 1;
            } while (hasPrefixIntermediate);
            output.append(source.substring(cursor, indPrefix));
            String key = source.substring(indPrefix + prefixLength, indSuffix);
            foundKey = true;
            output.append(this.getValue(key));
            cursor = indSuffix + suffixLength;
        } while (foundKey);
        return output.toString();
    }

    private String getValue(String key) {
        String[] split = key.split(DEFAULT_SEPARATOR);
        String value = (String)this.placeholderProvider.apply(split[0]);
        if (value == null) {
            if (split.length > 1) {
                return split[1];
            }
            return "";
        }
        return value;
    }

    public static class PlaceholderConfiguration {
        private final String opener;
        private final String closer;
        private final String keyPrefix;
        private final String openerWithKeyPrefix;

        public PlaceholderConfiguration(String opener, String closer) {
            this(opener, closer, null);
        }

        public PlaceholderConfiguration(String opener, String closer, String keyPrefix) {
            this.opener = opener;
            this.closer = closer;
            this.keyPrefix = keyPrefix;
            this.openerWithKeyPrefix = opener + Optional.ofNullable(keyPrefix).orElse("");
        }

        public String getOpener() {
            return this.opener;
        }

        public String getOpenerWithKeyPrefix() {
            return this.openerWithKeyPrefix;
        }

        public String getCloser() {
            return this.closer;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }
    }

    static class CachedPlaceHolder
    implements UnaryOperator<String> {
        private final UnaryOperator<String> originalFunction;
        private final Map<String, Optional<String>> cache = new HashMap<String, Optional<String>>();

        public CachedPlaceHolder(UnaryOperator<String> originalFunction) {
            this.originalFunction = originalFunction;
        }

        @Override
        public String apply(String varName) {
            return this.cache.computeIfAbsent(varName, k -> Optional.ofNullable((String)this.originalFunction.apply((String)k))).orElse(null);
        }
    }
}

