/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.AttachmentBuilder;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.api.BodyFormat;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.HTTPMethod;
import org.talend.components.common.httpclient.api.KeyValuePair;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.attachments.UploadFileConfig;
import org.talend.components.common.httpclient.api.authentication.OAuth20Cache;
import org.talend.components.common.httpclient.api.authentication.OAuth20FlowExecution;
import org.talend.components.common.httpclient.api.authentication.Token;
import org.talend.components.common.httpclient.api.service.AttachmentService;
import org.talend.components.common.httpclient.impl.cxf.BlindTrustManager;
import org.talend.components.common.httpclient.impl.cxf.CXFAttachmentService;
import org.talend.components.common.httpclient.impl.cxf.CXFHTTPResponseImpl;
import org.talend.components.common.httpclient.impl.cxf.cookies.CookieMatcher;
import org.talend.components.common.httpclient.impl.cxf.cookies.CookieService;
import org.talend.components.common.httpclient.impl.cxf.logfiltering.CXFLogManager;
import org.talend.components.common.httpclient.pagination.PaginationStrategy;
import org.talend.components.common.httpclient.pagination.PaginationStrategyFactory;
import org.talend.components.common.httpclient.retry.RetryStrategy;
import org.talend.components.common.httpclient.retry.RetryStrategyFactory;
import org.talend.components.common.service.http.ValidateSites;

public class CXFHTTPClientImpl
implements HTTPClient<WebClient> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CXFHTTPClientImpl.class);
    private static final String DEFAULT_METHOD = "GET";
    private QueryConfiguration queryConfiguration;
    private WebClient webClient;
    private CookieService cookieService;
    private Token token;
    private AttachmentService<Attachment, Response> attachmentsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CXFHTTPClientImpl(QueryConfiguration queryConfiguration) {
        ClassLoader backupThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.queryConfiguration = queryConfiguration;
            this.cookieService = new CookieService();
            this.attachmentsService = new CXFAttachmentService();
            String url = this.configureURL();
            this.forceCXFURLConduitIfNotSpecified();
            this.webClient = WebClient.create((String)url);
            this.configureCXFWebClient();
        }
        finally {
            Thread.currentThread().setContextClassLoader(backupThreadContextClassLoader);
        }
    }

    private void forceCXFURLConduitIfNotSpecified() {
        if (System.getProperty("org.apache.cxf.transport.http.forceURLConnection") == null) {
            System.setProperty("org.apache.cxf.transport.http.forceURLConnection", "true");
            this.configureLegacyCXFURLConduit();
        }
    }

    private void configureLegacyCXFURLConduit() {
        if (System.getProperty("sun.net.http.allowRestrictedHeaders") == null) {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        }
    }

    private void configureCXFWebClient() {
        ClientConfiguration config = WebClient.getConfig((Object)this.webClient);
        config.getRequestContext().put("set.content.type.for.empty.request", "false");
        config.getRequestContext().put("org.apache.cxf.transport.http.forceVersion", "1.1");
        if (this.queryConfiguration.isKeepSession()) {
            config.getRequestContext().put(Message.MAINTAIN_SESSION, true);
        }
        if (this.queryConfiguration.isDecompressResponsePayload()) {
            config.getInInterceptors().add(new GZIPInInterceptor());
        }
    }

    @Override
    public WebClient getNestedClient() {
        return this.webClient;
    }

    @Override
    public HTTPClient.HTTPResponse<Response> invoke() throws HTTPClientException {
        RetryStrategy retryStrategy = RetryStrategyFactory.RetryStrategyFactory(this.queryConfiguration);
        HTTPClient.HTTPResponse<Response> response = null;
        boolean retry = true;
        while (retry) {
            block5: {
                try {
                    response = this.atomicInvoke();
                    retry = retryStrategy.retry(response);
                }
                catch (HTTPClientException e) {
                    retry = retryStrategy.retry(e);
                    if (retry) break block5;
                    throw e;
                }
            }
            log.info(String.format("'%s' retry strategy selected for HTTP client. Retry the last call: %s.", retryStrategy.getClass().getName(), retry));
            if (log.isDebugEnabled()) {
                log.debug(String.format("'%s' retry strategy state:\n%s", retryStrategy.getClass().getName(), retryStrategy));
            }
            if (!retry) continue;
            this.queryConfiguration = retryStrategy.doActionBeforeRetry(this.queryConfiguration);
        }
        if (this.queryConfiguration.getAttachmentsConfiguration().isDownloadAttachments()) {
            response = this.attachmentsService.processAttachmentsInResponse(response, this.queryConfiguration);
        }
        return response;
    }

    protected HTTPClient.HTTPResponse<Response> atomicInvoke() throws HTTPClientException {
        this.validateURL();
        this.configureNestedClientBeforeInvoke();
        try {
            Response invoke = this.getResponse();
            PaginationStrategy paginationStrategy = PaginationStrategyFactory.getPaginationStrategy(this.queryConfiguration);
            CXFHTTPResponseImpl cxfhttpResponse = new CXFHTTPResponseImpl(invoke, paginationStrategy);
            if (this.queryConfiguration.isKeepSession()) {
                HTTPConduit conduit = WebClient.getConfig((Object)this.webClient).getHttpConduit();
                cxfhttpResponse.updateSessionCookies(this.castCxfCookieMap(conduit.getCookies()));
            }
            if (this.queryConfiguration.isSaveCookies()) {
                Map<String, NewCookie> responseCookies = cxfhttpResponse.getCookies();
                this.cookieService.saveCookies(cxfhttpResponse.getCookies(), this.queryConfiguration.getCookieContainerDirectory());
                log.debug("{} cookies serialized and added to the cookie container: {}", (Object)responseCookies.size(), responseCookies);
            }
            log.info(String.format("HTTP Query '%s' : '%s' ", this.queryConfiguration.getUrl(), cxfhttpResponse.getStatus().getCodeWithReason()));
            return cxfhttpResponse;
        }
        catch (Exception e) {
            throw this.manageExceptions(e);
        }
    }

    protected void configureNestedClientBeforeInvoke() throws HTTPClientException {
        this.manageAuthentication();
        this.certificateValidation();
        if (this.queryConfiguration.getBodyType() != null) {
            this.webClient.type(this.queryConfiguration.getBodyType().getContentType());
        }
        HTTPConduit conduit = WebClient.getConfig((Object)this.webClient).getHttpConduit();
        conduit.getClient().setConnectionTimeout(this.queryConfiguration.getConnectionTimeout());
        conduit.getClient().setReceiveTimeout(this.queryConfiguration.getReceiveTimeout());
        this.queryConfiguration.getHeaders().forEach(h -> {
            if ("Authorization".equalsIgnoreCase(h.getKey())) {
                conduit.setAuthSupplier(new HttpAuthSupplier(){
                    final /* synthetic */ KeyValuePair val$h;
                    {
                        this.val$h = keyValuePair;
                    }

                    public boolean requiresRequestCaching() {
                        return false;
                    }

                    public String getAuthorization(AuthorizationPolicy authPolicy, URI uri, Message message, String fullHeader) {
                        boolean authorizationHasBeenChallenged = fullHeader != null;
                        return authorizationHasBeenChallenged ? null : this.val$h.getValue();
                    }
                });
            } else {
                this.webClient.header(h.getKey(), new Object[]{h.getValue()});
            }
        });
        if (this.queryConfiguration.isReadCookies()) {
            List<jakarta.ws.rs.core.Cookie> cookies = this.cookieService.loadCookies(this.queryConfiguration.getCookieContainerDirectory());
            this.addCookiesToTheHeader(cookies);
            log.debug("{} cookies added to the request Cookie header: {}", (Object)cookies.size(), cookies);
        }
        this.queryConfiguration.getQueryParams().stream().forEach(q -> this.webClient.query(q.getKey(), new Object[]{q.getValue()}));
        this.manageProxy();
        this.manageRedirections();
    }

    private void addCookiesToTheHeader(Collection<jakarta.ws.rs.core.Cookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return;
        }
        String resultCookieHeaderValue = cookies.stream().filter(c -> CookieMatcher.isCookieMatch(c, this.queryConfiguration.getUrl())).map(c -> c.getName() + "=" + c.getValue()).collect(Collectors.joining(";"));
        this.webClient.header("Cookie", new Object[]{resultCookieHeaderValue});
    }

    private Map<String, NewCookie> castCxfCookieMap(Map<String, Cookie> cookies) {
        return cookies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Cookie cxfCookie = (Cookie)e.getValue();
            return new NewCookie(cxfCookie.getName(), cxfCookie.getValue(), cxfCookie.getPath(), null, 1, null, cxfCookie.getMaxAge(), null, false, false);
        }));
    }

    private void certificateValidation() throws HTTPClientException {
        HTTPConduit conduit = WebClient.getConfig((Object)this.webClient).getHttpConduit();
        if (this.queryConfiguration.isBypassCertificateValidation()) {
            TLSClientParameters params = this.getTlsClientParameters(conduit);
            params.setTrustManagers(new TrustManager[]{new BlindTrustManager()});
            params.setDisableCNCheck(true);
        } else {
            TLSClientParameters params = this.getTlsClientParameters(conduit);
            try {
                params.setSslContext(SSLContext.getDefault());
            }
            catch (Exception e) {
                log.warn("fail to call SSLContext.getDefault() : " + e.getMessage());
            }
        }
    }

    private TLSClientParameters getTlsClientParameters(HTTPConduit conduit) {
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        return params;
    }

    private void validateURL() throws HTTPClientException {
        String url = this.configureURL();
        if (!ValidateSites.isValidSite((String)url)) {
            try {
                URI uri = new URI(url);
                throw new HTTPClientException(String.format("The given URL '%s://%s' is not acceptable according to configuration.", uri.getScheme(), uri.getHost()));
            }
            catch (URISyntaxException e) {
                throw new HTTPClientException(e.getMessage(), e);
            }
        }
    }

    private HTTPClientException manageExceptions(Exception e) {
        String msg = this.queryConfiguration.getMaxNumberOfAcceptedRedirectionsOnSameURI() > 0 && e.getMessage().startsWith("java.io.IOException: Redirect loop detected on Conduit") ? "There has been too many HTTP redirection to the same query." : (this.queryConfiguration.isAcceptOnlySameHostRedirection() && e.getMessage().contains("Different HTTP Scheme or Host Redirect detected on Conduit") ? "HTTP redirection to another host is forbidden." : (e.getCause() != null ? (e.getCause() instanceof SocketTimeoutException ? String.format("HTTP timeout: %s", e.getCause().getMessage()) : String.format("The HTTPClient call was failing '%s' : '%s'", e.getMessage(), e.getCause())) : String.format("The HTTPClient call was failing '%s'", e.getMessage())));
        return new HTTPClientException(msg, e);
    }

    private void manageProxy() {
        if (this.queryConfiguration.getProxy() == null) {
            return;
        }
        HTTPConduit httpConduit = WebClient.getConfig((Object)this.webClient).getHttpConduit();
        httpConduit.getClient().setProxyServer(this.queryConfiguration.getProxy().getHost());
        httpConduit.getClient().setProxyServerPort(Integer.valueOf(this.queryConfiguration.getProxy().getPort()));
        httpConduit.getClient().setProxyServerType(ProxyServerType.fromValue((String)this.queryConfiguration.getProxy().getType().name()));
        String login = this.queryConfiguration.getProxy().getCredentials().getLogin();
        String password = this.queryConfiguration.getProxy().getCredentials().getPassword();
        if (login != null && !login.isEmpty()) {
            httpConduit.getProxyAuthorization().setUserName(login);
        }
        if (password != null && !password.isEmpty()) {
            httpConduit.getProxyAuthorization().setPassword(password);
        }
    }

    private void manageAuthentication() throws HTTPClientException {
        ClientConfiguration clientConfiguration = WebClient.getConfig((Object)this.webClient);
        HTTPConduit httpConduit = clientConfiguration.getHttpConduit();
        switch (this.queryConfiguration.getAuthenticationType()) {
            case Basic: {
                AuthorizationPolicy basicAuthPolicy = new AuthorizationPolicy();
                basicAuthPolicy.setUserName(this.queryConfiguration.getLoginPassword().getLogin());
                basicAuthPolicy.setPassword(this.queryConfiguration.getLoginPassword().getPassword());
                basicAuthPolicy.setAuthorizationType("Basic");
                httpConduit.setAuthorization(basicAuthPolicy);
                break;
            }
            case Digest: {
                AuthorizationPolicy digestAuthPolicy = new AuthorizationPolicy();
                digestAuthPolicy.setUserName(this.queryConfiguration.getLoginPassword().getLogin());
                digestAuthPolicy.setPassword(this.queryConfiguration.getLoginPassword().getPassword());
                digestAuthPolicy.setAuthorizationType("Digest");
                httpConduit.setAuthorization(digestAuthPolicy);
                break;
            }
            case NTLM: {
                AuthorizationPolicy authPolicy = new AuthorizationPolicy();
                authPolicy.setAuthorizationType("NTLM");
                authPolicy.setUserName(this.queryConfiguration.getLoginPassword().getLogin());
                authPolicy.setPassword(this.queryConfiguration.getLoginPassword().getPassword());
                httpConduit.setAuthorization(authPolicy);
                break;
            }
            case Authorization_Token: {
                this.setAuthorizationToken(this.queryConfiguration.getAuthorizationToken());
                break;
            }
            case API_Key: {
                CXFLogManager.addSensitiveHeaderToCXFConfig(clientConfiguration, this.queryConfiguration.getApiKeyHeaderName());
                break;
            }
            case OAuth20_Client_Credential: {
                String headerValue;
                this.token = this.manageCachedToken();
                if (this.token == null || this.token.isExpired()) {
                    this.token = this.requestOauthToken();
                    this.queryConfiguration.getOAuthTokenCacheKey().ifPresent(tokenCacheKey -> OAuth20Cache.getCacheMap().put((String)tokenCacheKey, this.token));
                }
                String prefix = this.queryConfiguration.getOauthCall().getTokenPrefix() == null ? this.token.getTokenType() : this.queryConfiguration.getOauthCall().getTokenPrefix();
                String string = headerValue = StringUtils.isEmpty((String)prefix) ? this.token.getAccessToken() : String.format("%s %s", prefix, this.token.getAccessToken());
                if (StringUtils.isEmpty((String)this.queryConfiguration.getOauthCall().getAuthorizationHeader())) {
                    this.setAuthorizationToken(headerValue);
                    break;
                }
                CXFLogManager.addSensitiveHeaderToCXFConfig(clientConfiguration, this.queryConfiguration.getOauthCall().getAuthorizationHeader());
                this.queryConfiguration.getHeaders().add(new KeyValuePair(this.queryConfiguration.getOauthCall().getAuthorizationHeader(), headerValue));
            }
        }
    }

    private Token requestOauthToken() throws HTTPClientException {
        Token resultToken = new OAuth20FlowExecution(this.queryConfiguration.getOauthCall().getQueryConfiguration()).executeFlow();
        String type = resultToken.getTokenType();
        if (type.length() > 2) {
            type = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
        }
        resultToken.setTokenType(type);
        return resultToken;
    }

    private Token manageCachedToken() {
        String tokenCacheKey = this.queryConfiguration.getOAuthTokenCacheKey().orElse(null);
        return tokenCacheKey == null ? null : OAuth20Cache.getCacheMap().get(tokenCacheKey);
    }

    private void setAuthorizationToken(String token) {
        this.queryConfiguration.getHeaders().add(new KeyValuePair("Authorization", token));
    }

    private void manageRedirections() {
        HTTPConduit httpConduit = WebClient.getConfig((Object)this.webClient).getHttpConduit();
        HTTPClientPolicy policy = httpConduit.getClient();
        if (!this.queryConfiguration.isAcceptRedirections()) {
            policy.setAutoRedirect(false);
            return;
        }
        policy.setAutoRedirect(true);
        String allowedHttpRedirects = Arrays.stream(HTTPMethod.values()).map(Enum::toString).collect(Collectors.joining(","));
        WebClient.getConfig((Object)this.webClient).getRequestContext().put("http.redirect.allowed.verbs", allowedHttpRedirects);
        WebClient.getConfig((Object)this.webClient).getRequestContext().put("http.redirect.same.host.only", Boolean.toString(this.queryConfiguration.isAcceptOnlySameHostRedirection()));
        WebClient.getConfig((Object)this.webClient).getRequestContext().put("http.redirect.relative.uri", Boolean.toString(this.queryConfiguration.isAcceptRelativeURLRedirection()));
        if (this.queryConfiguration.getMaxNumberOfAcceptedRedirectionsOnSameURI() > 0) {
            WebClient.getConfig((Object)this.webClient).getRequestContext().put("http.redirect.max.same.uri.count", this.queryConfiguration.getMaxNumberOfAcceptedRedirectionsOnSameURI());
        }
        if (this.queryConfiguration.getAllowedURIRedirection() != null) {
            WebClient.getConfig((Object)this.webClient).getRequestContext().put("http.redirect.allowed.uri", this.queryConfiguration.getAllowedURIRedirection());
        }
    }

    private Response getResponse() throws IOException {
        Response invoke;
        BodyFormat bodyType = this.queryConfiguration.getBodyType();
        if (bodyType == BodyFormat.FORM_DATA) {
            invoke = this.webClient.invoke(this.getHTTPMethod(), (Object)this.buildMultiPartBody());
        } else if (bodyType == BodyFormat.X_WWW_FORM_URLENCODED) {
            invoke = this.webClient.invoke(this.getHTTPMethod(), (Object)this.buildForm());
        } else if (bodyType == BodyFormat.BINARY) {
            try (FileInputStream fileInputStream = new FileInputStream(this.queryConfiguration.getFilePath());){
                invoke = this.webClient.invoke(this.getHTTPMethod(), (Object)this.transferStream(fileInputStream));
            }
        } else {
            invoke = this.webClient.invoke(this.getHTTPMethod(), (Object)this.queryConfiguration.getPlainTextBody());
        }
        return invoke;
    }

    private MultipartBody buildMultiPartBody() {
        List attachments = this.queryConfiguration.getBodyQueryParams().stream().map(p -> {
            AttachmentBuilder attachmentBuilder = new AttachmentBuilder();
            ContentDisposition contentDisposition = new ContentDisposition(String.format("form-data; name=\"%s\"", p.getKey()));
            return attachmentBuilder.id(p.getKey()).contentDisposition(contentDisposition).object((Object)p.getValue()).build();
        }).collect(Collectors.toList());
        if (this.queryConfiguration.getAttachmentsConfiguration().getUploadAttachments() != null) {
            for (UploadFileConfig uploadFileConfig : this.queryConfiguration.getAttachmentsConfiguration().getUploadAttachments()) {
                attachments.add(this.attachmentsService.translateAttachmentFromConfig(uploadFileConfig));
            }
        }
        return new MultipartBody(attachments, MediaType.MULTIPART_FORM_DATA_TYPE, false);
    }

    private StreamingOutput transferStream(InputStream inputStream) {
        return output -> {
            int bytesRead;
            long transferred = 0L;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
                transferred += (long)bytesRead;
            }
            log.trace("Transferred {} bytes", (Object)transferred);
            output.flush();
        };
    }

    private Form buildForm() {
        Form form = new Form();
        this.queryConfiguration.getBodyQueryParams().forEach(kp -> form.param(kp.getKey(), kp.getValue()));
        return form;
    }

    private String getHTTPMethod() {
        Optional<String> method = Optional.ofNullable(this.queryConfiguration.getMethod());
        return method.orElse(DEFAULT_METHOD);
    }

    private String configureURL() {
        return this.queryConfiguration.getUrl();
    }

    static {
        CXFLogManager.injectLog4jFilter();
    }
}

