/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf;

import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.talend.components.common.httpclient.api.ContentType;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.pagination.PaginationStrategy;

class CXFHTTPResponseImpl
implements HTTPClient.HTTPResponse<Response> {
    private final Response response;
    private HTTPClient.Status status;
    private Map<String, String> headers;
    private String encoding;
    private byte[] payload;
    private final PaginationStrategy paginationStrategy;
    private Map<String, NewCookie> sessionCookies = new HashMap<String, NewCookie>();

    public CXFHTTPResponseImpl(Response response, PaginationStrategy paginationStrategy) {
        this.response = response;
        this.paginationStrategy = paginationStrategy;
        this.computeResponse();
    }

    private void computeResponse() {
        this.computeStatus();
        this.computeHeaders();
    }

    private void computeStatus() {
        this.status = new HTTPClient.Status(this.response.getStatus(), this.response.getStatusInfo().getReasonPhrase(), this.response.getStatusInfo().getFamily().name());
    }

    private void computeHeaders() {
        this.headers = this.response.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(Object::toString).collect(Collectors.joining(";"))));
        this.encoding = ContentType.getCharsetName(this.headers);
    }

    @Override
    public HTTPClient.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isSuccess() {
        return this.response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getBodyAsString() throws HTTPClientException {
        this.loadPayload();
        try {
            return new String(this.payload, 0, this.payload.length, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new HTTPClientException(String.format("Can't convert HTTP response payload to string with that encoding '%s' : %s", this.encoding, e.getMessage()), e);
        }
    }

    @Override
    public InputStream getBodyAsStream() throws HTTPClientException {
        this.loadPayload();
        return new ByteArrayInputStream(this.payload);
    }

    private void loadPayload() throws HTTPClientException {
        try {
            if (this.payload == null) {
                int bytesRead;
                InputStream inputStream = (InputStream)this.response.getEntity();
                if (inputStream == null) {
                    inputStream = new ByteArrayInputStream(new byte[0]);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                baos.close();
                this.payload = baos.toByteArray();
            }
        }
        catch (IOException e) {
            throw new HTTPClientException("Can't load HTTP response payload: " + e.getMessage(), e);
        }
    }

    @Override
    public Response getNestedResponse() {
        return this.response;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Optional<QueryConfiguration> nextPageQueryConfiguration() throws HTTPClientException {
        return this.paginationStrategy.getNextPageConfiguration(this);
    }

    @Override
    public int getLastPageCount() throws HTTPClientException {
        return this.paginationStrategy.getLastCount(this);
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        HashMap<String, NewCookie> unitedMap = new HashMap<String, NewCookie>(this.sessionCookies);
        unitedMap.putAll(this.response.getCookies());
        return unitedMap;
    }

    void updateSessionCookies(Map<String, NewCookie> cookies) {
        this.sessionCookies = cookies;
    }

    @Generated
    PaginationStrategy getPaginationStrategy() {
        return this.paginationStrategy;
    }
}

