/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf.cookies;

import jakarta.ws.rs.core.NewCookie;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import lombok.Generated;
import lombok.NonNull;

public final class CookieFormatLine {
    private static final String NAME_JSON_KEY = "name";
    private static final String EXPIRY_JSON_KEY = "expiry";
    private static final String DOMAIN_JSON_KEY = "domain";
    private static final String COOKIE_STRING_JSON_KEY = "cookie";
    private String name;
    private Long expiry;
    private String domain;
    private String valueWithMetadata;

    CookieFormatLine(@NonNull String cookieName, @NonNull NewCookie cookie) {
        if (cookieName == null) {
            throw new NullPointerException("cookieName is marked non-null but is null");
        }
        if (cookie == null) {
            throw new NullPointerException("cookie is marked non-null but is null");
        }
        this.name = cookieName;
        this.domain = cookie.getDomain();
        this.expiry = cookie.getExpiry() != null ? Long.valueOf(cookie.getExpiry().getTime()) : null;
        this.valueWithMetadata = cookie.toCookie().toString();
    }

    static CookieFormatLine fromJson(String cookieLine) {
        try (JsonParser jsonParser = Json.createParser((Reader)new StringReader(cookieLine));){
            JsonValue domain;
            JsonObject jsonCookie = jsonParser.getObject();
            CookieFormatLine cookieFormatLine = new CookieFormatLine();
            cookieFormatLine.setName(jsonCookie.getString(NAME_JSON_KEY));
            JsonValue expiry = (JsonValue)jsonCookie.get((Object)EXPIRY_JSON_KEY);
            if (expiry != null && !expiry.equals(JsonValue.NULL)) {
                cookieFormatLine.setExpiry(jsonCookie.getJsonNumber(EXPIRY_JSON_KEY).longValue());
            }
            if ((domain = (JsonValue)jsonCookie.get((Object)DOMAIN_JSON_KEY)) != null && !domain.equals(JsonValue.NULL)) {
                cookieFormatLine.setDomain(jsonCookie.getString(DOMAIN_JSON_KEY));
            }
            cookieFormatLine.setValueWithMetadata(jsonCookie.getString(COOKIE_STRING_JSON_KEY));
            CookieFormatLine cookieFormatLine2 = cookieFormatLine;
            return cookieFormatLine2;
        }
    }

    String asJson() {
        JsonObjectBuilder cookieJsonBuilder = Json.createObjectBuilder();
        cookieJsonBuilder.add(NAME_JSON_KEY, this.name);
        if (this.expiry == null) {
            cookieJsonBuilder.addNull(EXPIRY_JSON_KEY);
        } else {
            cookieJsonBuilder.add(EXPIRY_JSON_KEY, this.expiry.longValue());
        }
        if (this.domain == null) {
            cookieJsonBuilder.addNull(DOMAIN_JSON_KEY);
        } else {
            cookieJsonBuilder.add(DOMAIN_JSON_KEY, this.domain);
        }
        cookieJsonBuilder.add(COOKIE_STRING_JSON_KEY, this.valueWithMetadata);
        return cookieJsonBuilder.build().toString();
    }

    @Generated
    protected String getName() {
        return this.name;
    }

    @Generated
    protected Long getExpiry() {
        return this.expiry;
    }

    @Generated
    protected String getDomain() {
        return this.domain;
    }

    @Generated
    protected String getValueWithMetadata() {
        return this.valueWithMetadata;
    }

    @Generated
    private void setName(String name) {
        this.name = name;
    }

    @Generated
    private void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    @Generated
    private void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    private void setValueWithMetadata(String valueWithMetadata) {
        this.valueWithMetadata = valueWithMetadata;
    }

    @Generated
    public CookieFormatLine() {
    }
}

