/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.retry;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.QueryConfiguration;

public abstract class RetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryStrategy.class);
    private static final List<Integer> NO_RETRY_FOR_THOSE_HTTP_CODES = Arrays.asList(401, 403, 511);
    private static final List<Class<? extends Exception>> RETRY_FOR_EXCEPTIONS = Arrays.asList(SocketTimeoutException.class, ConnectException.class);
    private int nextAttemptsIndex = 1;
    private final int maxAttempts;

    public RetryStrategy(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean retry(HTTPClient.HTTPResponse response) {
        int status = response.getStatus().getCode();
        if (status < 400 || NO_RETRY_FOR_THOSE_HTTP_CODES.contains(status)) {
            return false;
        }
        return !this.maxAttemptsReached();
    }

    public boolean retry(Throwable e) {
        if (this.maxAttemptsReached()) {
            return false;
        }
        List<Class> causesNeededRetry = this.getCauses(e);
        causesNeededRetry.retainAll(RETRY_FOR_EXCEPTIONS);
        return !causesNeededRetry.isEmpty();
    }

    private List<Class> getCauses(Throwable t) {
        List<Object> causes;
        if (t.getCause() == null) {
            causes = new ArrayList();
            causes.add(t.getClass());
        } else {
            causes = this.getCauses(t.getCause());
            causes.add(t.getClass());
        }
        return causes;
    }

    protected boolean maxAttemptsReached() {
        boolean b;
        boolean bl = b = this.getNextAttemptsIndex() > this.getMaxAttempts();
        if (b) {
            log.info(String.format("Retry max attempts reached '%s'. No more retry.", this.getMaxAttempts()));
        }
        return b;
    }

    public QueryConfiguration doActionBeforeRetry(QueryConfiguration queryConfiguration) {
        ++this.nextAttemptsIndex;
        return this.actionBeforeRetry(queryConfiguration);
    }

    protected abstract QueryConfiguration actionBeforeRetry(QueryConfiguration var1);

    @Generated
    public int getNextAttemptsIndex() {
        return this.nextAttemptsIndex;
    }

    @Generated
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Generated
    public void setNextAttemptsIndex(int nextAttemptsIndex) {
        this.nextAttemptsIndex = nextAttemptsIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNextAttemptsIndex() != other.getNextAttemptsIndex()) {
            return false;
        }
        return this.getMaxAttempts() == other.getMaxAttempts();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RetryStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNextAttemptsIndex();
        result = result * 59 + this.getMaxAttempts();
        return result;
    }

    @Generated
    public String toString() {
        return "RetryStrategy(nextAttemptsIndex=" + this.getNextAttemptsIndex() + ", maxAttempts=" + this.getMaxAttempts() + ")";
    }
}

