/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.aws;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.aws.SettingHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointParams;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.PolicyDescriptorType;
import software.amazon.awssdk.services.sts.model.Tag;
import software.amazon.awssdk.utils.StringUtils;

public class CredentialsProviderUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CredentialsProviderUtil.class);
    private SettingHelper settings;

    public CredentialsProviderUtil(SettingHelper settings) {
        this.settings = settings;
    }

    public AwsCredentialsProvider getNormalAwsCredentialsProvider() {
        log.info("Getting normal AWS credentials provider.");
        switch (this.settings.getCredentialProvider()) {
            case "STATIC_CREDENTIALS": {
                log.debug("Using static credentials.");
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.settings.getAccessKey(), (String)this.settings.getSecretKey()));
            }
            case "INHERIT_CREDENTIALS": {
                log.debug("Using inherited credentials.");
                AwsCredentialsProvider[] credentialsProviders = new AwsCredentialsProvider[]{ContainerCredentialsProvider.builder().build(), InstanceProfileCredentialsProvider.builder().build()};
                AwsCredentialsProviderChain awsCredentialsProviderChain = AwsCredentialsProviderChain.builder().reuseLastProviderEnabled(Boolean.valueOf(true)).credentialsProviders(credentialsProviders).build();
                return awsCredentialsProviderChain;
            }
            case "WEB_TOKEN": {
                log.debug("Using web identity token credentials.");
                WebIdentityTokenFileCredentialsProvider.Builder webIdentBuilder = WebIdentityTokenFileCredentialsProvider.builder();
                Optional.ofNullable(this.settings.getWebIdentityTokenFile()).map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(arg_0 -> ((WebIdentityTokenFileCredentialsProvider.Builder)webIdentBuilder).webIdentityTokenFile(arg_0));
                Optional.ofNullable(this.settings.getWebTokenArn()).ifPresent(arg_0 -> ((WebIdentityTokenFileCredentialsProvider.Builder)webIdentBuilder).roleArn(arg_0));
                Optional.ofNullable(this.settings.getWebTokenRoleSessionName()).ifPresent(arg_0 -> ((WebIdentityTokenFileCredentialsProvider.Builder)webIdentBuilder).roleSessionName(arg_0));
                return webIdentBuilder.build();
            }
            case "PROFILE_INHERIT_CREDENTIALS": {
                log.debug("Using profile inherit credentials.");
                DefaultCredentialsProvider.Builder builder = DefaultCredentialsProvider.builder();
                if (StringUtils.isNotBlank((CharSequence)this.settings.getProfilePath())) {
                    Path path = Paths.get(this.settings.getProfilePath(), new String[0]);
                    ProfileFile profileFile = ProfileFile.builder().type(ProfileFile.Type.CREDENTIALS).content(path).build();
                    builder.profileFile(profileFile).profileName(this.settings.getProfileName());
                }
                return builder.build();
            }
        }
        log.error("Unsupported credential provider type: {}", (Object)this.settings.getCredentialProvider());
        throw new IllegalArgumentException("Unsupported credential provider type:" + this.settings.getCredentialProvider());
    }

    public AssumeRoleRequest getAssumeRoleRequest() {
        AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder();
        assumeRoleRequestBuilder.roleArn(this.settings.getArn()).roleSessionName(this.settings.getRoleSessionName()).durationSeconds(Integer.valueOf(this.settings.getSessionDuration() * 60));
        log.debug("AssumeRoleRequest configured with ARN: {}, RoleSessionName: {}, DurationSeconds: {}", new Object[]{this.settings.getArn(), this.settings.getRoleSessionName(), this.settings.getSessionDuration() * 60});
        if (StringUtils.isNotBlank((CharSequence)this.settings.getExternalId())) {
            assumeRoleRequestBuilder.externalId(this.settings.getExternalId());
            log.debug("ExternalId set: {}", (Object)this.settings.getExternalId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.settings.getSerialNumber())) {
            assumeRoleRequestBuilder.serialNumber(this.settings.getSerialNumber());
            log.debug("SerialNumber set: {}", (Object)this.settings.getSerialNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)this.settings.getTokenCode())) {
            assumeRoleRequestBuilder.tokenCode(this.settings.getTokenCode());
            log.debug("TokenCode set: {}", (Object)this.settings.getTokenCode());
        }
        if (this.settings.getTags() != null && !this.settings.getTags().isEmpty()) {
            List transitiveTags = this.settings.getTags().stream().filter(e -> "true".equals(e.get("TAG_TRANSITIVE"))).map(e -> (String)e.get("TAG_KEY")).collect(Collectors.toList());
            List tags = this.settings.getTags().stream().filter(e -> "true".equals(e.get("TAG_TRANSITIVE"))).map(tag -> (Tag)Tag.builder().key((String)tag.get("TAG_KEY")).value((String)tag.get("TAG_VALUE")).build()).collect(Collectors.toList());
            assumeRoleRequestBuilder.tags(tags);
            assumeRoleRequestBuilder.transitiveTagKeys(transitiveTags);
            log.debug("Tags set: {}, TransitiveTags set: {}", tags, transitiveTags);
        }
        if (this.settings.getPolicyArns() != null && !this.settings.getPolicyArns().isEmpty()) {
            assumeRoleRequestBuilder.policyArns((Collection)this.settings.getPolicyArns().stream().map(policyArn -> (PolicyDescriptorType)PolicyDescriptorType.builder().arn((String)policyArn.get("POLICY_ARN")).build()).collect(Collectors.toList()));
            log.debug("PolicyArns set: {}", this.settings.getPolicyArns());
        }
        if (StringUtils.isNotBlank((CharSequence)this.settings.getPolicy())) {
            assumeRoleRequestBuilder.policy(this.settings.getPolicy());
            log.debug("Policy set: {}", (Object)this.settings.getPolicy());
        }
        return (AssumeRoleRequest)assumeRoleRequestBuilder.build();
    }

    public AwsCredentialsProvider getAssumeRoleCredentialsProvider() {
        log.info("Creating AssumeRoleCredentialsProvider.");
        StsClient stsClient = this.createStsClient();
        StsAssumeRoleCredentialsProvider assumeRoleCredentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(this.getAssumeRoleRequest()).build();
        log.info("AssumeRoleCredentialsProvider created successfully.");
        return assumeRoleCredentialsProvider;
    }

    public Credentials getAssumeCredentials() {
        try (StsClient stsClient = this.createStsClient();){
            Credentials credentials;
            AssumeRoleResponse assumeRoleResponse = stsClient.assumeRole(this.getAssumeRoleRequest());
            Credentials credentials2 = credentials = assumeRoleResponse.credentials();
            return credentials2;
        }
    }

    public StsClient createStsClient() {
        String signingRegion;
        log.info("Creating STS client.");
        StsClientBuilder stsClientBuilder = StsClient.builder();
        stsClientBuilder.credentialsProvider(this.getNormalAwsCredentialsProvider());
        log.debug("Credentials provider set.");
        if (this.settings.isSpecifySTSEndpoint()) {
            StsEndpointParams stsEndpointParams = StsEndpointParams.builder().endpoint(this.settings.getStsEndpoint()).build();
            StsEndpointProvider stsEndpointProvider = StsEndpointProvider.defaultProvider();
            stsEndpointProvider.resolveEndpoint(stsEndpointParams).join();
            stsClientBuilder.endpointProvider(stsEndpointProvider);
            log.debug("STS endpoint Params set: {}", (Object)stsEndpointParams);
        }
        if (StringUtils.isNotBlank((CharSequence)(signingRegion = this.settings.getSigningRegion()))) {
            if ("DEFAULT".equals(signingRegion)) {
                stsClientBuilder.region(Region.US_EAST_1);
            } else {
                stsClientBuilder.region(Region.of((String)signingRegion));
            }
            log.debug("Signing region set: {}", (Object)signingRegion);
        }
        StsClient stsClient = (StsClient)stsClientBuilder.build();
        log.debug("STS client created successfully.");
        return stsClient;
    }
}

