/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.aws.s3;

import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.aws.CommonUtils;
import org.talend.components.aws.SettingHelper;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;

public class NettyClientHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyClientHelper.class);
    private final SettingHelper settings;
    private String protocol = "https://";
    private NettyNioAsyncHttpClient.Builder nettyBuilder = NettyNioAsyncHttpClient.builder();
    private ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder();
    private ClientOverrideConfiguration.Builder overrideBuilder = ClientOverrideConfiguration.builder();
    private boolean useProxy = false;

    public NettyClientHelper(SettingHelper settings) {
        this.settings = settings;
        this.init();
    }

    public void init() {
        if (this.settings.isConfigClient()) {
            block45: for (Map.Entry<String, String> clientConfig : this.settings.getClientConfiguration().entrySet()) {
                String clientParameter = CommonUtils.stripQuotes(clientConfig.getKey());
                String value = CommonUtils.stripQuotes(clientConfig.getValue());
                switch (clientParameter) {
                    case "ConnectionTimeout": 
                    case "CONNECTION_TIMEOUT": {
                        this.nettyBuilder.connectionTimeout(Duration.ofMillis(Long.parseLong(value)));
                        continue block45;
                    }
                    case "MaxConnections": 
                    case "MAX_CONNECTIONS": {
                        this.nettyBuilder.maxConcurrency(Integer.valueOf(Integer.parseInt(value)));
                        continue block45;
                    }
                    case "MaxErrorRetry": 
                    case "MAX_ERROR_RETRY": {
                        this.overrideBuilder.retryPolicy(RetryPolicy.builder().numRetries(Integer.valueOf(Integer.parseInt(value))).build());
                        continue block45;
                    }
                    case "RetryMode": 
                    case "RETRY_MODE": {
                        this.overrideBuilder.retryStrategy(RetryMode.valueOf((String)value.toUpperCase()));
                        continue block45;
                    }
                    case "Protocol": 
                    case "PROTOCOL": {
                        this.protocol = value.toLowerCase() + "://";
                        this.proxyBuilder.scheme(value);
                        continue block45;
                    }
                    case "ProxyHost": 
                    case "PROXY_HOST": {
                        this.useProxy = true;
                        this.proxyBuilder.host(value);
                        continue block45;
                    }
                    case "ProxyPort": 
                    case "PROXY_PORT": {
                        this.useProxy = true;
                        this.proxyBuilder.port(Integer.parseInt(value));
                        continue block45;
                    }
                    case "ProxyUsername": 
                    case "PROXY_USERNAME": {
                        this.useProxy = true;
                        this.proxyBuilder.username(value);
                        continue block45;
                    }
                    case "ProxyPassword": 
                    case "PROXY_PASSWORD": {
                        this.useProxy = true;
                        this.proxyBuilder.password(value);
                        continue block45;
                    }
                    case "UserAgent": 
                    case "USER_AGENT": {
                        this.overrideBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)value);
                        continue block45;
                    }
                }
                log.warn("Unsupported Client configuration: {}", (Object)clientParameter);
            }
        }
        if (this.useProxy) {
            this.proxyBuilder.useSystemPropertyValues(Boolean.valueOf(false));
            ProxyConfiguration proxyConfiguration = (ProxyConfiguration)this.proxyBuilder.build();
            log.debug("Proxy Configuration {}", (Object)proxyConfiguration);
            this.nettyBuilder.proxyConfiguration(proxyConfiguration);
        }
    }

    @Generated
    public SettingHelper getSettings() {
        return this.settings;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public NettyNioAsyncHttpClient.Builder getNettyBuilder() {
        return this.nettyBuilder;
    }

    @Generated
    public ProxyConfiguration.Builder getProxyBuilder() {
        return this.proxyBuilder;
    }

    @Generated
    public ClientOverrideConfiguration.Builder getOverrideBuilder() {
        return this.overrideBuilder;
    }

    @Generated
    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setNettyBuilder(NettyNioAsyncHttpClient.Builder nettyBuilder) {
        this.nettyBuilder = nettyBuilder;
    }

    @Generated
    public void setProxyBuilder(ProxyConfiguration.Builder proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
    }

    @Generated
    public void setOverrideBuilder(ClientOverrideConfiguration.Builder overrideBuilder) {
        this.overrideBuilder = overrideBuilder;
    }

    @Generated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NettyClientHelper)) {
            return false;
        }
        NettyClientHelper other = (NettyClientHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseProxy() != other.isUseProxy()) {
            return false;
        }
        SettingHelper this$settings = this.getSettings();
        SettingHelper other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        NettyNioAsyncHttpClient.Builder this$nettyBuilder = this.getNettyBuilder();
        NettyNioAsyncHttpClient.Builder other$nettyBuilder = other.getNettyBuilder();
        if (this$nettyBuilder == null ? other$nettyBuilder != null : !this$nettyBuilder.equals(other$nettyBuilder)) {
            return false;
        }
        ProxyConfiguration.Builder this$proxyBuilder = this.getProxyBuilder();
        ProxyConfiguration.Builder other$proxyBuilder = other.getProxyBuilder();
        if (this$proxyBuilder == null ? other$proxyBuilder != null : !this$proxyBuilder.equals(other$proxyBuilder)) {
            return false;
        }
        ClientOverrideConfiguration.Builder this$overrideBuilder = this.getOverrideBuilder();
        ClientOverrideConfiguration.Builder other$overrideBuilder = other.getOverrideBuilder();
        return !(this$overrideBuilder == null ? other$overrideBuilder != null : !this$overrideBuilder.equals(other$overrideBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NettyClientHelper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseProxy() ? 79 : 97);
        SettingHelper $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        NettyNioAsyncHttpClient.Builder $nettyBuilder = this.getNettyBuilder();
        result = result * 59 + ($nettyBuilder == null ? 43 : $nettyBuilder.hashCode());
        ProxyConfiguration.Builder $proxyBuilder = this.getProxyBuilder();
        result = result * 59 + ($proxyBuilder == null ? 43 : $proxyBuilder.hashCode());
        ClientOverrideConfiguration.Builder $overrideBuilder = this.getOverrideBuilder();
        result = result * 59 + ($overrideBuilder == null ? 43 : $overrideBuilder.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NettyClientHelper(settings=" + this.getSettings() + ", protocol=" + this.getProtocol() + ", nettyBuilder=" + this.getNettyBuilder() + ", proxyBuilder=" + this.getProxyBuilder() + ", overrideBuilder=" + this.getOverrideBuilder() + ", useProxy=" + this.isUseProxy() + ")";
    }
}

