/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.azure.runtime.token;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.talend.components.azure.runtime.token.EndpointUtil;

public class AzureActiveDirectoryTokenGetter {
    private final String tenantId;
    private final String clientId;
    private final String clientSecret;
    private String authorityHost;

    public AzureActiveDirectoryTokenGetter(String tenantId, String clientId, String clientSecret) {
        this(tenantId, clientId, clientSecret, null);
    }

    public AzureActiveDirectoryTokenGetter(String tenantId, String clientId, String clientSecret, String authorityHost) {
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authorityHost = authorityHost;
    }

    public String retrieveAccessToken() throws Exception {
        return this.retrieveAccessToken(EndpointUtil.getEndpoint(EndpointUtil.Region.AZURE_CLOUD.toString(), ""));
    }

    public String retrieveAccessToken(String endpoint) throws Exception {
        if (this.authorityHost == null) {
            this.authorityHost = EndpointUtil.getAuthorityHost(endpoint);
        }
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential).authority(this.authorityHost + this.tenantId)).build();
        Set<String> scopes = Collections.singleton("https://storage.azure.com//.default");
        String azure_blob_aad_scope = System.getenv().get("AZURE_BLOB_SCOPE");
        if (azure_blob_aad_scope != null && !"".equals(azure_blob_aad_scope)) {
            String[] azure_scopes = azure_blob_aad_scope.split(",");
            scopes.addAll(Arrays.asList(azure_scopes));
        }
        ClientCredentialParameters parameters = ClientCredentialParameters.builder(scopes).build();
        IAuthenticationResult result = (IAuthenticationResult)confidentialClientApplication.acquireToken(parameters).get();
        return result.accessToken();
    }
}

