/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.talend.webservice.mapper.converter;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class XMLGregorianCalendarConverter implements Converter {

    public Object convert(Class type, Object value) {

        if (value == null) {
            return null;
        }

        if (value instanceof XMLGregorianCalendar) {
            return (value);
        } else if (value instanceof Date) {
            try {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime((Date) value);
                XMLGregorianCalendar date = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
                return date;
            } catch (javax.xml.datatype.DatatypeConfigurationException ex) {
                ex.printStackTrace();
            }
        } else {
            throw new ConversionException(
                    "Should be javax.xml.datatype.XMLGregorianCalendar type or java.util.Date type");
        }
        return null;
    }
}
