/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.talend.webservice.mapper;

import org.talend.webservice.mapper.converter.ConvertTool;

/**
 * 
 * @author rlamarche
 */
public class SimpleTypeMapper implements TypeMapper {

    private Class<?> clazz;

    public SimpleTypeMapper(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getClazz() {
        return clazz;
    }

    public Object convertToType(Object value) {
        if (value == null) {
            return null;
        } else {
            // return ConvertUtils.convert(ConvertUtils.convert(value), clazz);
            return ConvertTool.convert(value, clazz);// bug13001, for date type value
        }
    }

    public Object typeToValue(Object bean) {
        return bean;
    }
}
