/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.talend.webservice.exception;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 *
 * @author rlamarche
 */
public class LocalizedException extends Exception {

    protected Object[] arguments;

    private static ResourceBundle messages;

    static {
        messages = ResourceBundle.getBundle("messages");
    }

    /**
     * Creates a new instance of <code>LocalizedException</code> without detail message.
     */
    public LocalizedException() {
    }

    public LocalizedException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public LocalizedException(String msg, Object[] arguments, Throwable cause) {
        super(msg, cause);
        this.arguments = arguments;
    }

    public LocalizedException(String msg) {
        super(msg);
    }

    /**
     * Constructs an instance of <code>LocalizedException</code> with the specified detail message.
     * 
     * @param msg the detail message.
     */
    public LocalizedException(String msg, Object[] arguments) {
        this(msg);
        this.arguments = arguments;
    }

    @Override
    public String getLocalizedMessage() {
        String msg = getMessage();
        if (msg != null) {
            msg = messages.getString(msg);
            if (msg == null) {
                return getMessage();
            } else {
                if (arguments == null) {
                    return msg;
                } else {
                    return MessageFormat.format(msg, arguments);
                }
            }
        } else {
            return null;
        }
    }
}
