/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.microsoft.aad.msal4j;

import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.auth.Secret;

class OauthCredentialRequest extends MsalRequest {

    ClientCredentialParameters parameters;

    OauthCredentialRequest(ClientCredentialParameters parameters, String username, String password,
            OauthClientApplication application, RequestContext requestContext) {
        super(application, createMsalGrant(parameters, username, password), requestContext);
        this.parameters = parameters;
    }

    private static OAuthAuthorizationGrant createMsalGrant(ClientCredentialParameters parameters,
            String username, String password) {
        return new OAuthAuthorizationGrant(new ResourceOwnerPasswordCredentialsGrant(username, new Secret(
                password)), parameters.scopes(), parameters.claims());
    }

}
