/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.character;

import java.util.function.Function;
import org.talend.dataquality.common.character.StringHandler;

public enum AbbreviationMode {
    FIRST_LETTERS_IGNORE_NUMERIC(false, false, StringHandler::firstCharIgnoreNumeric),
    FIRST_UPPER_CASE_LETTERS_IGNORE_NUMERIC(false, true, StringHandler::firstUpperIgnoreNumeric),
    ALL_UPPER_CASE_LETTERS_IGNORE_NUMERIC(false, true, StringHandler::allUpperIgnoreNumeric),
    FIRST_LETTERS_KEEP_NUMERIC(true, false, StringHandler::firstCharKeepNumeric),
    FIRST_UPPER_CASE_LETTERS_KEEP_NUMERIC(true, true, StringHandler::firstUpperKeepNumeric),
    ALL_UPPER_CASE_LETTERS_KEEP_NUMERIC(true, true, StringHandler::allUpperKeepNumeric);

    private final boolean keepDigits;
    private final boolean isUpperCaseMode;
    private final Function<String, String> function;

    private AbbreviationMode(boolean keepDigits, boolean isUpperCaseMode, Function<String, String> function) {
        this.keepDigits = keepDigits;
        this.isUpperCaseMode = isUpperCaseMode;
        this.function = function;
    }

    public boolean keepsDigits() {
        return this.keepDigits;
    }

    public boolean isUpperCaseMode() {
        return this.isUpperCaseMode;
    }

    public String apply(String str) {
        return this.function.apply(str);
    }
}

