/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.character;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.talend.dataquality.common.character.AbbreviationMode;
import org.talend.dataquality.common.character.TokenizedString;

public class Acronym {
    private AcronymSeparator separator;
    private AbbreviationMode abbrevMode;
    private String delimiterPattern;

    private Acronym(AbbreviationMode abbrevMode, AcronymSeparator separator, String delimiterPattern) {
        this.abbrevMode = abbrevMode;
        this.separator = separator;
        this.delimiterPattern = delimiterPattern;
    }

    public AcronymSeparator getSeparator() {
        return this.separator;
    }

    public AbbreviationMode getAbbrevMode() {
        return this.abbrevMode;
    }

    public String transform(String str) {
        String firstApplied;
        TokenizedString tokenizedString = new TokenizedString(str, this.delimiterPattern);
        List<String> tokens = tokenizedString.getTokens();
        if (tokens.size() == 0) {
            return "";
        }
        int start = 0;
        while ((firstApplied = this.abbrevMode.apply(tokens.get(start))).isEmpty() && ++start < tokens.size()) {
        }
        StringBuilder sb = new StringBuilder(firstApplied);
        if (this.separator == AcronymSeparator.KEEP_SPECIAL_CHARS) {
            Pattern specialCharPattern = Pattern.compile(this.separator.getValue());
            List<String> separators = tokenizedString.getSeparators();
            int nextSeparator = tokenizedString.isStartingWithSeparator() ? 1 : 0;
            for (int i = 1; i < tokens.size(); ++i) {
                String chars = this.abbrevMode.apply(tokens.get(i));
                if (!chars.isEmpty()) {
                    sb.append(this.getSpecialChars(separators.get(nextSeparator), specialCharPattern)).append(this.abbrevMode.apply(tokens.get(i)));
                }
                ++nextSeparator;
            }
        } else {
            for (int i = start; i < tokens.size(); ++i) {
                String chars = this.abbrevMode.apply(tokens.get(i));
                if (chars.isEmpty()) continue;
                sb.append(this.separator.getValue()).append(this.abbrevMode.apply(tokens.get(i)));
            }
            if (sb.length() > 0 && AcronymSeparator.PERIOD == this.separator) {
                sb.append(this.separator.getValue());
            }
        }
        return sb.toString();
    }

    private String getSpecialChars(String separator, Pattern specialCharPattern) {
        Matcher matcher = specialCharPattern.matcher(separator);
        return matcher.find() ? matcher.group() : "";
    }

    public static AcronymBuilder newBuilder() {
        return new AcronymBuilder();
    }

    public static enum AcronymSeparator {
        NONE(""),
        DASH("-"),
        SPACE(" "),
        PERIOD("."),
        KEEP_SPECIAL_CHARS("[#$%&()\\-/=@_|~]");

        private String value;

        private AcronymSeparator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class AcronymBuilder {
        private AcronymSeparator separator;
        private AbbreviationMode abbrevMode;
        private String delimiterPattern;

        private AcronymBuilder() {
        }

        public AcronymBuilder withAbbreviationMode(AbbreviationMode abbrevMode) {
            this.abbrevMode = abbrevMode;
            return this;
        }

        public AcronymBuilder withSeparator(AcronymSeparator separator) {
            this.separator = separator;
            return this;
        }

        public AcronymBuilder withDelimiters(String delimiterPattern) {
            this.delimiterPattern = delimiterPattern;
            return this;
        }

        public Acronym build() {
            return new Acronym(this.abbrevMode, this.separator, this.delimiterPattern);
        }
    }
}

