/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.character;

import java.util.stream.Stream;

public final class StringHandler {
    public static String toTitleCase(String str, String delimiters) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        StringBuilder resultPlaceHolder = new StringBuilder(str.length());
        Stream.of(str.split(delimiters)).forEach(stringPart -> {
            if (stringPart.length() > 1) {
                int firstCodePoint = stringPart.codePointAt(0);
                String firstChars = new String(Character.toChars(firstCodePoint));
                int offset = stringPart.offsetByCodePoints(0, 1);
                resultPlaceHolder.append(firstChars.toUpperCase()).append(stringPart.substring(offset).toLowerCase());
            } else {
                resultPlaceHolder.append(stringPart.toUpperCase());
            }
            resultPlaceHolder.append(" ");
        });
        return resultPlaceHolder.toString().trim();
    }

    public static String firstCharIgnoreNumeric(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        int cpCount = str.codePointCount(0, str.length());
        for (int i = 0; i < cpCount; ++i) {
            int codePointPos = str.offsetByCodePoints(0, i);
            int codePoint = str.codePointAt(codePointPos);
            if (Character.isDigit(codePoint)) continue;
            return new String(Character.toChars(codePoint));
        }
        return "";
    }

    public static String firstUpperIgnoreNumeric(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        int cpCount = str.codePointCount(0, str.length());
        for (int i = 0; i < cpCount; ++i) {
            int codePointPos = str.offsetByCodePoints(0, i);
            int codePoint = str.codePointAt(codePointPos);
            if (Character.isDigit(codePoint)) continue;
            if (!Character.isUpperCase(codePoint)) break;
            return new String(Character.toChars(codePoint));
        }
        return "";
    }

    public static String allUpperIgnoreNumeric(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int cpCount = str.codePointCount(0, str.length());
        for (int i = 0; i < cpCount; ++i) {
            int codePointPos = str.offsetByCodePoints(0, i);
            int codePoint = str.codePointAt(codePointPos);
            if (!Character.isUpperCase(codePoint)) continue;
            sb.append(Character.toChars(codePoint));
        }
        return sb.toString();
    }

    public static String firstCharKeepNumeric(String str) {
        int codePointPos;
        int codePoint;
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int cpCount = str.codePointCount(0, str.length());
        int firstCodePoint = str.codePointAt(str.offsetByCodePoints(0, 0));
        sb.append(Character.toChars(firstCodePoint));
        for (int i = 1; i < cpCount && Character.isDigit(codePoint = str.codePointAt(codePointPos = str.offsetByCodePoints(0, i))); ++i) {
            sb.append(Character.toChars(codePoint));
        }
        return sb.toString();
    }

    public static String firstUpperKeepNumeric(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int cpCount = str.codePointCount(0, str.length());
        int firstCodePoint = str.codePointAt(str.offsetByCodePoints(0, 0));
        if (Character.isDigit(firstCodePoint) || Character.isUpperCase(firstCodePoint)) {
            int codePointPos;
            int codePoint;
            sb.append(Character.toChars(firstCodePoint));
            for (int i = 1; i < cpCount && Character.isDigit(codePoint = str.codePointAt(codePointPos = str.offsetByCodePoints(0, i))); ++i) {
                sb.append(Character.toChars(codePoint));
            }
        }
        return sb.toString();
    }

    public static String allUpperKeepNumeric(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int cpCount = str.codePointCount(0, str.length());
        for (int i = 0; i < cpCount; ++i) {
            int codePointPos = str.offsetByCodePoints(0, i);
            int codePoint = str.codePointAt(codePointPos);
            if (!Character.isDigit(codePoint) && !Character.isUpperCase(codePoint)) continue;
            sb.append(Character.toChars(codePoint));
        }
        return sb.toString();
    }
}

