/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.character;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenizedString {
    private static final String DEFAULT_SEPARATORS = "[[\\p{Punct}&&[^'.]]\\s\\u00A0\\u2007\\u202F\\u3000]+";
    private Pattern separatorPattern = Pattern.compile("[[\\p{Punct}&&[^'.]]\\s\\u00A0\\u2007\\u202F\\u3000]+");
    private final String value;
    private final List<String> tokens;
    private final List<String> separators;
    private boolean startingWithSeparator;
    private boolean endingWithSeparator;

    public TokenizedString(String str, String listOfSeparators) {
        this.value = str;
        this.separatorPattern = Pattern.compile(listOfSeparators);
        this.tokens = this.tokenize(this.value);
        this.separators = new ArrayList<String>(this.tokens.size());
    }

    public TokenizedString(String str) {
        this.value = str;
        this.tokens = this.tokenize(this.value);
        this.separators = new ArrayList<String>(this.tokens.size());
    }

    public boolean isStartingWithSeparator() {
        return this.startingWithSeparator;
    }

    public boolean isEndingWithSeparator() {
        return this.endingWithSeparator;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public List<String> getSeparators() {
        if (this.separators.isEmpty()) {
            this.extractSeparators();
        }
        return this.separators;
    }

    public List<String> tokenize(String field) {
        if (field == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> fieldTokens = new ArrayList<String>(Arrays.asList(this.separatorPattern.split(field)));
        if (!fieldTokens.isEmpty() && ((String)fieldTokens.get(0)).isEmpty()) {
            fieldTokens.remove(0);
        }
        return fieldTokens;
    }

    private void extractSeparators() {
        Matcher matcher = this.separatorPattern.matcher(this.value);
        this.startingWithSeparator = false;
        this.endingWithSeparator = false;
        while (matcher.find()) {
            if (matcher.start() == 0) {
                this.startingWithSeparator = true;
            } else if (matcher.end() == this.value.length()) {
                this.endingWithSeparator = true;
            }
            this.separators.add(matcher.group());
        }
    }

    public Pattern getSeparatorPattern() {
        return this.separatorPattern;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenizedString that = (TokenizedString)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

