/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.inference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.talend.dataquality.common.exception.DQCommonRuntimeException;
import org.talend.dataquality.common.inference.AvroAnalyzer;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.common.util.AvroUtils;

public abstract class AvroQualityAnalyzer
implements AvroAnalyzer {
    private static final long serialVersionUID = 7878661383777406934L;
    public static final String GLOBAL_QUALITY_PROP_NAME = "talend.component.globalQuality";
    public static final String QUALITY_PROP_NAME = "talend.component.qualityAggregate";
    public static final String DQTYPE_PROP_NAME = "talend.component.dqType";
    public static final String DQTYPE_DATA_TYPE_FIELD_NAME = "dataType";
    public static final String DQTYPE_DQTYPE_FIELD_NAME = "dqType";
    public static final String VALIDITY_FIELD_NAME = "validity";
    private static final String QUALITY_VALUE_LEVEL_SCHEMA_DEF = "{ \"type\": \"record\",    \"name\": \"quality_metadata\", \"namespace\": \"org.talend.dataquality\",    \"fields\": [ { \"name\": \"validity\", \"type\": \"int\" } ] }";
    public static final Schema QUALITY_VALUE_LEVEL_SCHEMA = new Schema.Parser().parse("{ \"type\": \"record\",    \"name\": \"quality_metadata\", \"namespace\": \"org.talend.dataquality\",    \"fields\": [ { \"name\": \"validity\", \"type\": \"int\" } ] }");
    public static final int VALID_VALUE = 1;
    public static final int INVALID_VALUE = -1;
    public static final int EMPTY_VALUE = 0;
    protected boolean isStoreInvalidValues = true;
    protected final Map<String, ValueQualityStatistics> qualityResults = new HashMap<String, ValueQualityStatistics>();
    protected Schema inputSemanticSchema;
    protected Schema outputSemanticSchema;
    protected Schema outputRecordSemanticSchema;

    protected <T> T getOrCreate(String key, Map<String, T> map, Class<T> itemClass) {
        T value = map.get(key);
        if (value == null) {
            try {
                value = itemClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DQCommonRuntimeException("Unable to get create an instance of " + itemClass, e);
            }
            map.put(key, value);
        }
        return value;
    }

    @Override
    public Schema getResult() {
        if (this.inputSemanticSchema == null) {
            return null;
        }
        ValueQualityStatistics stats = this.qualityResults.values().stream().reduce(new ValueQualityStatistics(), ValueQualityStatistics::mergeCounts);
        this.outputSemanticSchema.addProp(GLOBAL_QUALITY_PROP_NAME, stats.toMap());
        for (Schema.Field field : this.outputSemanticSchema.getFields()) {
            this.updateQuality(field.schema(), field.name());
        }
        return this.outputSemanticSchema;
    }

    private Map<String, Long> getStatMap(String resultKey) {
        if (this.qualityResults.containsKey(resultKey)) {
            return this.qualityResults.get(resultKey).toMap();
        }
        return new ValueQualityStatistics().toMap();
    }

    private Schema updateQuality(Schema sourceSchema, String prefix) {
        switch (sourceSchema.getType()) {
            case RECORD: {
                for (Schema.Field field : sourceSchema.getFields()) {
                    this.updateQuality(field.schema(), AvroUtils.itemId(prefix, field.name()));
                }
                break;
            }
            case ARRAY: {
                this.updateQuality(sourceSchema.getElementType(), prefix);
                break;
            }
            case MAP: {
                this.updateQuality(sourceSchema.getValueType(), prefix);
                break;
            }
            case UNION: {
                if (this.qualityResults.containsKey(prefix)) {
                    try {
                        sourceSchema.addProp(QUALITY_PROP_NAME, this.getStatMap(prefix));
                    }
                    catch (AvroRuntimeException e) {
                        System.out.println("Failed to add prop to field " + sourceSchema.getName() + ".");
                    }
                }
                for (Schema unionSchema : sourceSchema.getTypes()) {
                    this.updateQuality(unionSchema, AvroUtils.itemId(prefix, unionSchema.getName()));
                }
                break;
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                try {
                    sourceSchema.addProp(QUALITY_PROP_NAME, this.getStatMap(prefix));
                    break;
                }
                catch (AvroRuntimeException e) {
                    System.out.println("Failed to add prop to referenced type " + sourceSchema.getName() + ". The analyzer is not supporting schema with referenced types.");
                }
            }
        }
        return null;
    }

    @Override
    public List<Schema> getResults() {
        return Collections.singletonList(this.getResult());
    }

    @Override
    public void close() throws Exception {
    }
}

