/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.inference;

import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.talend.dataquality.common.exception.DQCommonRuntimeException;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.AnalyzerSupplier;

public class ConcurrentAnalyzer<T>
implements Analyzer<T> {
    private static final long serialVersionUID = 6896234073310039985L;
    private final ThreadLocal<Analyzer<T>> threadLocal;

    private ConcurrentAnalyzer(int maxSize, AnalyzerSupplier<Analyzer<T>> supplier) {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.maxTotal = maxSize;
        config.maxActive = maxSize;
        config.maxIdle = maxSize / 2;
        config.minIdle = maxSize / 2;
        config.maxWait = -1L;
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(new Factory<T>(supplier), config);
        this.threadLocal = new ThreadLocal<Analyzer<T>>((KeyedObjectPool)pool){
            final /* synthetic */ KeyedObjectPool val$pool;
            {
                this.val$pool = keyedObjectPool;
            }

            @Override
            protected Analyzer<T> initialValue() {
                try {
                    return (Analyzer)this.val$pool.borrowObject((Object)Thread.currentThread());
                }
                catch (Exception e) {
                    throw new DQCommonRuntimeException(e);
                }
            }

            @Override
            public void remove() {
                try {
                    this.val$pool.returnObject((Object)Thread.currentThread(), this.get());
                }
                catch (Exception e) {
                    throw new DQCommonRuntimeException(e);
                }
                finally {
                    super.remove();
                }
            }
        };
    }

    public static <T> Analyzer<T> make(AnalyzerSupplier<Analyzer<T>> supplier, int maxSize) {
        return new ConcurrentAnalyzer<T>(maxSize, supplier);
    }

    @Override
    public void init() {
        Analyzer<T> analyzer = this.threadLocal.get();
        analyzer.init();
    }

    @Override
    public boolean analyze(String ... record) {
        Analyzer<T> analyzer = this.threadLocal.get();
        return analyzer.analyze(record);
    }

    @Override
    public void end() {
        Analyzer<T> analyzer = this.threadLocal.get();
        analyzer.end();
    }

    @Override
    public List<T> getResult() {
        Analyzer<T> analyzer = this.threadLocal.get();
        return analyzer.getResult();
    }

    @Override
    public void close() throws Exception {
        this.threadLocal.remove();
    }

    private static class Factory<T>
    implements KeyedPoolableObjectFactory<Thread, Analyzer<T>> {
        private final AnalyzerSupplier<Analyzer<T>> supplier;

        public Factory(AnalyzerSupplier<Analyzer<T>> supplier) {
            this.supplier = supplier;
        }

        public synchronized Analyzer<T> makeObject(Thread key) throws Exception {
            return this.supplier.get();
        }

        public void destroyObject(Thread key, Analyzer<T> obj) throws Exception {
        }

        public boolean validateObject(Thread key, Analyzer<T> obj) {
            return true;
        }

        public void activateObject(Thread key, Analyzer<T> obj) throws Exception {
        }

        public void passivateObject(Thread key, Analyzer<T> obj) throws Exception {
        }
    }
}

