/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.inference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import org.talend.dataquality.common.exception.DQCommonRuntimeException;

public class ResizableList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = -4643753633617225999L;
    private final Supplier<T> supplier;
    private final List<T> innerList;

    public ResizableList(Supplier<T> supplier) {
        this.supplier = supplier;
        this.innerList = new ArrayList<T>();
    }

    public boolean resize(int size) {
        if (size < 0) {
            throw new DQCommonRuntimeException("Unable to resize list of items: Size must be a positive number.");
        }
        int missing = size - this.innerList.size();
        boolean addedMissing = missing > 0;
        for (int i = 0; i < missing; ++i) {
            this.innerList.add(this.supplier.get());
        }
        return addedMissing;
    }

    @Override
    public int size() {
        return this.innerList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.innerList.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.innerList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.innerList.toArray();
    }

    @Override
    public <Q> Q[] toArray(Q[] qs) {
        return this.innerList.toArray(qs);
    }

    @Override
    public boolean add(T t) {
        return this.innerList.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.innerList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.innerList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.innerList.addAll(collection);
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> collection) {
        return this.innerList.addAll(i, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.innerList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.innerList.retainAll(collection);
    }

    @Override
    public void clear() {
        this.innerList.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.innerList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.innerList.hashCode();
    }

    @Override
    public T get(int i) {
        return this.innerList.get(i);
    }

    @Override
    public T set(int i, T t) {
        return this.innerList.set(i, t);
    }

    @Override
    public void add(int i, T t) {
        this.innerList.add(i, t);
    }

    @Override
    public T remove(int i) {
        return this.innerList.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.innerList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.innerList.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.innerList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return this.innerList.listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return this.innerList.subList(i, i1);
    }
}

