/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.inference;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ValueQualityStatistics
implements Serializable {
    private static final long serialVersionUID = -4839915401904443142L;
    private final Set<String> invalidValues = new HashSet<String>();
    private final Set<String> unknownValues = new HashSet<String>();
    private long validCount;
    private long emptyCount;
    private long invalidCount;
    private long unknownCount;

    public Set<String> getInvalidValues() {
        return this.invalidValues;
    }

    public Set<String> getUnknownValues() {
        return this.unknownValues;
    }

    public long getValidCount() {
        return this.validCount;
    }

    public void setValidCount(long newCount) {
        this.validCount = newCount;
    }

    public long getEmptyCount() {
        return this.emptyCount;
    }

    public void setEmptyCount(long newCount) {
        this.emptyCount = newCount;
    }

    public long getInvalidCount() {
        return this.invalidCount;
    }

    public void setInvalidCount(long newCount) {
        this.invalidCount = newCount;
    }

    public long getUnknownCount() {
        return this.unknownCount;
    }

    public void setUnknownCount(long newCount) {
        this.unknownCount = newCount;
    }

    @JsonIgnore
    public long getCount() {
        return this.validCount + this.emptyCount + this.invalidCount + this.unknownCount;
    }

    public ValueQualityStatistics mergeCounts(ValueQualityStatistics stats) {
        this.validCount += stats.validCount;
        this.invalidCount += stats.invalidCount;
        this.emptyCount += stats.emptyCount;
        return this;
    }

    public Map<String, Long> toMap() {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        map.put(Integer.toString(-1), this.invalidCount);
        map.put(Integer.toString(1), this.validCount);
        map.put(Integer.toString(0), this.emptyCount);
        map.put("total", this.invalidCount + this.validCount + this.emptyCount);
        return map;
    }

    public void incrementValid() {
        ++this.validCount;
    }

    public void incrementEmpty() {
        ++this.emptyCount;
    }

    public void incrementInvalid() {
        ++this.invalidCount;
    }

    public void incrementUnknown() {
        ++this.unknownCount;
    }

    public void appendInvalidValue(String value) {
        this.invalidValues.add(value);
    }

    public void appendUnknownValue(String value) {
        this.unknownValues.add(value);
    }

    public String toString() {
        return "ValueQuality{valid=" + this.validCount + ", empty=" + this.emptyCount + ", invalid=" + this.invalidCount + '}' + ", unknown=" + this.unknownCount + '}' + "InvalidValues{" + this.invalidValues + "} UnknownValues{" + this.unknownValues + "}";
    }
}

