/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.talend.daikon.pattern.character.CharPattern;

public class TextPatternUtil {
    public static final int PROLONGED_SOUND_MARK = 12540;

    private TextPatternUtil() {
    }

    public static String findPattern(String stringToRecognize) {
        StringBuilder sb = new StringBuilder();
        boolean skipNextOne = false;
        for (int i = 0; i < stringToRecognize.length(); ++i) {
            if (skipNextOne) {
                skipNextOne = false;
                continue;
            }
            Integer codePoint = stringToRecognize.codePointAt(i);
            if (TextPatternUtil.isValidProlongedSoundMark(codePoint, sb)) {
                sb.append(sb.charAt(sb.length() - 1));
            } else {
                sb.append(Character.toChars(TextPatternUtil.findReplaceCodePoint(codePoint)));
            }
            if (!Character.isHighSurrogate(stringToRecognize.charAt(i))) continue;
            skipNextOne = true;
        }
        return sb.toString();
    }

    private static boolean isValidProlongedSoundMark(Integer codePoint, StringBuilder sb) {
        return codePoint == 12540 && sb.length() > 0 && (sb.charAt(sb.length() - 1) == 'K' || sb.charAt(sb.length() - 1) == 'H');
    }

    private static Integer findReplaceCodePoint(Integer codePoint) {
        for (CharPattern charPattern : CharPattern.values()) {
            if (!charPattern.contains(codePoint)) continue;
            return charPattern.getReplaceChar().charValue();
        }
        return codePoint;
    }

    public static Integer replaceCharacter(Integer codePointToReplace, Random random) {
        for (CharPattern charPattern : CharPattern.values()) {
            if (!charPattern.contains(codePointToReplace)) continue;
            int length = charPattern.getCodePointSize();
            int position = random.nextInt(length);
            return charPattern.getCodePointAt(position);
        }
        return codePointToReplace;
    }

    public static List<Integer> replaceStringCodePoints(String stringToReplace, Random random) {
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        long numberCodePoints = stringToReplace.codePoints().count();
        int i = 0;
        while ((long)i < numberCodePoints) {
            Integer codePoint = stringToReplace.codePointAt(i);
            codePoints.add(TextPatternUtil.replaceCharacter(codePoint, random));
            ++i;
        }
        return codePoints;
    }

    public static char[] replacePatternCharacter(Integer codePointToReplace, Random random) {
        for (CharPattern charPattern : CharPattern.values()) {
            if (charPattern.getReplaceChar().charValue() != codePointToReplace.intValue()) continue;
            int length = charPattern.getCodePointSize();
            int position = random.nextInt(length);
            return Character.toChars(charPattern.getCodePointAt(position));
        }
        return Character.toChars(codePointToReplace);
    }

    public static Set<CharPattern> getCharPatterns(List<Integer> codePoints, List<Integer> filteredCodepoints) {
        TreeSet<CharPattern> charPatternSet = new TreeSet<CharPattern>();
        for (Integer codepoint : codePoints) {
            CharPattern charPattern = TextPatternUtil.getCharPattern(codepoint);
            if (charPattern == null) continue;
            charPatternSet.add(charPattern);
            filteredCodepoints.add(codepoint);
        }
        return charPatternSet;
    }

    public static CharPattern getCharPattern(Integer codepoint) {
        for (CharPattern charPattern : CharPattern.values()) {
            if (!charPattern.contains(codepoint)) continue;
            return charPattern;
        }
        return null;
    }
}

