/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.lang3.StringUtils;

public class AvroUtils {
    public static Schema copySchema(Schema sourceSchema) {
        return new Schema.Parser().parse(sourceSchema.toString());
    }

    public static IndexedRecord applySchema(IndexedRecord record, Schema schema) {
        try {
            GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
            writer.write((Object)record, (Encoder)encoder);
            encoder.flush();
            GenericDatumReader reader = new GenericDatumReader(schema);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(outputStream.toByteArray(), null);
            return (IndexedRecord)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Schema replaceNullUnion(Schema s) {
        return AvroUtils.replaceNullUnion(s, Collections.emptyList());
    }

    public static Schema replaceNullUnion(Schema s, List<String> propsToAvoid) {
        if (s == null) {
            return null;
        }
        switch (s.getType()) {
            case UNION: {
                ArrayList<Schema> replacedUnionTypes = new ArrayList<Schema>();
                for (Schema unionType : s.getTypes()) {
                    if (unionType.getType() == Schema.Type.NULL) {
                        replacedUnionTypes.add(Schema.create((Schema.Type)Schema.Type.NULL));
                        continue;
                    }
                    Schema unionTypeSchema = AvroUtils.replaceNullUnion(unionType, propsToAvoid);
                    replacedUnionTypes.add(unionTypeSchema);
                }
                Schema unionSchema = Schema.createUnion(replacedUnionTypes);
                AvroUtils.addPropsToSchema(unionSchema, s.getObjectProps(), propsToAvoid);
                return unionSchema;
            }
            case RECORD: {
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                for (Schema.Field outField : s.getFields()) {
                    Schema fieldSchema = AvroUtils.replaceNullUnion(outField.schema(), propsToAvoid);
                    AvroUtils.addPropsToSchema(fieldSchema, outField.schema().getObjectProps(), propsToAvoid);
                    fields.add(new Schema.Field(outField.name(), fieldSchema, outField.doc(), outField.defaultVal()));
                }
                Schema recordSchema = Schema.createRecord((String)s.getName(), (String)s.getDoc(), (String)s.getNamespace(), (boolean)s.isError(), fields);
                AvroUtils.addPropsToSchema(recordSchema, s.getObjectProps(), propsToAvoid);
                return recordSchema;
            }
            case ARRAY: {
                Schema arraySchema = Schema.createArray((Schema)AvroUtils.replaceNullUnion(s.getElementType(), propsToAvoid));
                AvroUtils.addPropsToSchema(arraySchema, s.getObjectProps(), propsToAvoid);
                return arraySchema;
            }
            case MAP: {
                Schema mapSchema = Schema.createMap((Schema)AvroUtils.replaceNullUnion(s.getValueType(), propsToAvoid));
                AvroUtils.addPropsToSchema(mapSchema, s.getObjectProps(), propsToAvoid);
                return mapSchema;
            }
        }
        return s;
    }

    public static Schema createRecordSemanticSchema(Schema sourceSchema, Schema valueLevelMetadataSchema) {
        return AvroUtils.createSemanticSchemaForRecord(sourceSchema, valueLevelMetadataSchema);
    }

    private static Schema createSemanticSchemaForRecord(Schema recordSchema, Schema valueLevelMetadataSchema) {
        SchemaBuilder.RecordBuilder semanticRecordBuilder = (SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)recordSchema.getName()).namespace(recordSchema.getNamespace());
        SchemaBuilder.FieldAssembler fieldAssembler = semanticRecordBuilder.fields();
        for (Schema.Field field : recordSchema.getFields()) {
            fieldAssembler.name(field.name()).type(AvroUtils.createSemanticSchema(field.schema(), valueLevelMetadataSchema)).noDefault();
        }
        return (Schema)fieldAssembler.endRecord();
    }

    private static Schema createSemanticSchema(Schema sourceSchema, Schema valueLevelMetadataSchema) {
        switch (sourceSchema.getType()) {
            case RECORD: {
                return AvroUtils.createSemanticSchemaForRecord(sourceSchema, valueLevelMetadataSchema);
            }
            case ARRAY: {
                return Schema.createArray((Schema)AvroUtils.createSemanticSchema(sourceSchema.getElementType(), valueLevelMetadataSchema));
            }
            case MAP: {
                return Schema.createMap((Schema)AvroUtils.createSemanticSchema(sourceSchema.getValueType(), valueLevelMetadataSchema));
            }
            case UNION: {
                HashSet<Schema> unionSchemas = new HashSet<Schema>();
                for (Schema unionSchema : sourceSchema.getTypes()) {
                    unionSchemas.add(AvroUtils.createSemanticSchema(unionSchema, valueLevelMetadataSchema));
                }
                return Schema.createUnion(new ArrayList(unionSchemas));
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                return valueLevelMetadataSchema;
            }
        }
        return null;
    }

    public static Schema createSchemaFromLeafSchema(Schema baseSchema, Schema leafSchema, String namespaceSuffix) {
        switch (baseSchema.getType()) {
            case RECORD: {
                SchemaBuilder.RecordBuilder builder = SchemaBuilder.record((String)baseSchema.getName());
                if (namespaceSuffix != null) {
                    builder.namespace((baseSchema.getNamespace() == null ? "" : baseSchema.getNamespace() + ".") + namespaceSuffix);
                } else {
                    builder.namespace(baseSchema.getNamespace());
                }
                SchemaBuilder.FieldAssembler fieldAssembler = builder.fields();
                for (Schema.Field field : baseSchema.getFields()) {
                    Schema fieldSchema = AvroUtils.createSchemaFromLeafSchema(field.schema(), leafSchema, namespaceSuffix);
                    fieldAssembler.name(field.name()).type(fieldSchema).noDefault();
                }
                return (Schema)fieldAssembler.endRecord();
            }
            case ARRAY: {
                return Schema.createArray((Schema)AvroUtils.createSchemaFromLeafSchema(baseSchema.getElementType(), leafSchema, namespaceSuffix));
            }
            case MAP: {
                return Schema.createMap((Schema)AvroUtils.createSchemaFromLeafSchema(baseSchema.getValueType(), leafSchema, namespaceSuffix));
            }
            case UNION: {
                return Schema.createUnion(baseSchema.getTypes().stream().map(unionSchema -> AvroUtils.createSchemaFromLeafSchema(unionSchema, leafSchema, namespaceSuffix)).distinct().collect(Collectors.toList()));
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                return leafSchema;
            }
        }
        throw new IllegalStateException("Unexpected Avro Schema type: " + baseSchema.getType());
    }

    public static boolean isPrimitiveType(Schema.Type type) {
        return AvroUtils.isPrimitiveType(type, false);
    }

    public static boolean isPrimitiveType(Schema.Type type, boolean enumFixedIncluded) {
        return type == Schema.Type.STRING || type == Schema.Type.BYTES || type == Schema.Type.INT || type == Schema.Type.LONG || type == Schema.Type.FLOAT || type == Schema.Type.DOUBLE || type == Schema.Type.BOOLEAN || type == Schema.Type.NULL || enumFixedIncluded && (type == Schema.Type.ENUM || type == Schema.Type.FIXED);
    }

    public static String itemId(String prefix, String itemId) {
        return StringUtils.isEmpty((CharSequence)prefix) ? itemId : prefix + "." + itemId;
    }

    public static void applyFunctionOnFields(Schema fieldSchema, String fieldPath, BiConsumer<Schema, String> consumer) {
        switch (fieldSchema.getType()) {
            case RECORD: {
                for (Schema.Field field : fieldSchema.getFields()) {
                    AvroUtils.applyFunctionOnFields(field.schema(), AvroUtils.itemId(fieldPath, field.name()), consumer);
                }
                break;
            }
            case ARRAY: {
                AvroUtils.applyFunctionOnFields(fieldSchema.getElementType(), fieldPath, consumer);
                break;
            }
            case MAP: {
                AvroUtils.applyFunctionOnFields(fieldSchema.getValueType(), fieldPath, consumer);
                break;
            }
            case UNION: {
                for (Schema unionSchema : fieldSchema.getTypes()) {
                    AvroUtils.applyFunctionOnFields(unionSchema, AvroUtils.itemId(fieldPath, unionSchema.getName()), consumer);
                }
                break;
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                consumer.accept(fieldSchema, fieldPath);
            }
        }
    }

    public static Map<String, Object> extractProperties(Schema schema, String propName) {
        Objects.requireNonNull(schema, "Input schema should not be null.");
        HashMap<String, Object> props = new HashMap<String, Object>();
        AvroUtils.applyFunctionOnFields(schema, "", (fieldSchema, fieldPath) -> {
            if (propName != null) {
                if (fieldSchema.getObjectProp(propName) != null) {
                    props.put((String)fieldPath, fieldSchema.getObjectProp(propName));
                }
            } else {
                Map fieldProps = fieldSchema.getObjectProps();
                if (!fieldProps.isEmpty()) {
                    props.put((String)fieldPath, fieldProps);
                }
            }
        });
        return props;
    }

    public static void addProperties(Schema schema, String propName, Map<String, Object> props) {
        Objects.requireNonNull(schema, "Input schema should not be null.");
        AvroUtils.applyFunctionOnFields(schema, "", (fieldSchema, fieldPath) -> {
            if (props.containsKey(fieldPath)) {
                if (propName != null) {
                    fieldSchema.addProp(propName, props.get(fieldPath));
                } else if (props.get(fieldPath) instanceof Map) {
                    for (Map.Entry entry : ((Map)props.get(fieldPath)).entrySet()) {
                        fieldSchema.addProp((String)entry.getKey(), entry.getValue());
                    }
                }
            }
        });
    }

    public static Map<String, Object> extractAllProperties(Schema schema) {
        return AvroUtils.extractProperties(schema, null);
    }

    public static void addAllProperties(Schema schema, Map<String, Object> props) {
        AvroUtils.addProperties(schema, null, props);
    }

    public static Schema dereferencing(Schema schema, boolean keepProps) {
        Stream names = AvroUtils.getNamedTypes(schema);
        List<String> flattenNames = AvroUtils.flattenStream(names);
        HashSet<String> distinctFlattenNames = new HashSet<String>(flattenNames);
        if (distinctFlattenNames.size() != flattenNames.size()) {
            HashMap<String, String> namespaces = new HashMap<String, String>();
            for (String name : distinctFlattenNames) {
                namespaces.put(name, "a");
            }
            Schema dereferencedSchema = AvroUtils.buildDereferencedSchema(schema, namespaces);
            if (keepProps) {
                Map<String, Object> props = AvroUtils.extractAllProperties(schema);
                AvroUtils.addAllProperties(dereferencedSchema, props);
            }
            return dereferencedSchema;
        }
        return schema;
    }

    public static Schema dereferencing(Schema schema) {
        return AvroUtils.dereferencing(schema, false);
    }

    private static Stream getNamedTypes(Schema schema) {
        if (schema.getType() != Schema.Type.RECORD) {
            return Stream.empty();
        }
        return schema.getFields().stream().flatMap(field -> {
            Schema fieldSchema = field.schema();
            switch (fieldSchema.getType()) {
                case RECORD: {
                    List recordNames = AvroUtils.getNamedTypes(fieldSchema).collect(Collectors.toCollection(ArrayList::new));
                    recordNames.add(fieldSchema.getFullName());
                    return recordNames.stream();
                }
                case ARRAY: {
                    Stream arrayStream = AvroUtils.getNamedTypes(fieldSchema.getElementType());
                    if (arrayStream != null) {
                        List arrayNames = arrayStream.collect(Collectors.toCollection(ArrayList::new));
                        arrayNames.add(fieldSchema.getElementType().getFullName());
                        return arrayNames.stream();
                    }
                    return Stream.empty();
                }
                case MAP: {
                    Stream namedTypes = AvroUtils.getNamedTypes(fieldSchema.getValueType());
                    List mapNames = namedTypes.collect(Collectors.toCollection(ArrayList::new));
                    mapNames.add(fieldSchema.getValueType().getFullName());
                    return mapNames.stream();
                }
                case UNION: {
                    return fieldSchema.getTypes().stream().flatMap(unionSchema -> {
                        switch (unionSchema.getType()) {
                            case RECORD: {
                                List unionRecordStream = AvroUtils.getNamedTypes(unionSchema).collect(Collectors.toCollection(ArrayList::new));
                                unionRecordStream.add(unionSchema.getFullName());
                                return unionRecordStream.stream();
                            }
                            case ARRAY: {
                                List unionArrayStream = AvroUtils.getNamedTypes(unionSchema.getElementType()).collect(Collectors.toCollection(ArrayList::new));
                                if (unionSchema.getElementType().getType() == Schema.Type.RECORD) {
                                    unionArrayStream.add(unionSchema.getElementType().getFullName());
                                }
                                return unionArrayStream.stream();
                            }
                            case MAP: {
                                List unionMapStream = AvroUtils.getNamedTypes(unionSchema.getValueType()).collect(Collectors.toCollection(ArrayList::new));
                                unionMapStream.add(unionSchema.getValueType().getFullName());
                                return unionMapStream.stream();
                            }
                            case FIXED: {
                                return Stream.of(fieldSchema.getFullName());
                            }
                        }
                        return Stream.empty();
                    });
                }
                case ENUM: {
                    return Stream.of(fieldSchema.getFullName());
                }
            }
            return Stream.empty();
        });
    }

    private static List<String> flattenStream(Stream stream) {
        ArrayList<String> flattenNames = new ArrayList<String>();
        if (stream == null) {
            return flattenNames;
        }
        stream.forEach(obj -> {
            if (obj instanceof String) {
                flattenNames.add((String)obj);
            } else {
                AvroUtils.flattenStream((Stream)obj);
            }
        });
        return flattenNames;
    }

    private static Schema buildDereferencedSchema(Schema schema, Map<String, String> namespaces) {
        String namespace = schema.getNamespace();
        if (namespaces.containsKey(schema.getFullName())) {
            namespace = namespace + "." + namespaces.get(schema.getFullName());
            namespaces.put(schema.getFullName(), AvroUtils.nextNamespaceSuffix(namespaces.get(schema.getFullName())));
        }
        SchemaBuilder.RecordBuilder qualityRecordBuilder = (SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)schema.getName()).namespace(namespace);
        SchemaBuilder.FieldAssembler fieldAssembler = qualityRecordBuilder.fields();
        for (Schema.Field field : schema.getFields()) {
            Schema fieldSchema = field.schema();
            switch (fieldSchema.getType()) {
                case RECORD: {
                    fieldAssembler.name(field.name()).type(AvroUtils.buildDereferencedSchema(field.schema(), namespaces)).noDefault();
                    break;
                }
                case ARRAY: {
                    fieldAssembler.name(field.name()).type(Schema.createArray((Schema)AvroUtils.dereferenceLeaf(fieldSchema.getElementType(), namespaces))).noDefault();
                    break;
                }
                case UNION: {
                    List fullChild = fieldSchema.getTypes().stream().map(unionSchema -> {
                        switch (unionSchema.getType()) {
                            case RECORD: {
                                return AvroUtils.buildDereferencedSchema(unionSchema, namespaces);
                            }
                            case ARRAY: {
                                Schema unionArraySchema = unionSchema.getElementType().getType() != Schema.Type.RECORD ? AvroUtils.dereferenceLeaf(unionSchema.getElementType(), namespaces) : AvroUtils.buildDereferencedSchema(unionSchema.getElementType(), namespaces);
                                return Schema.createArray((Schema)unionArraySchema);
                            }
                            case MAP: {
                                Schema unionMapSchema = unionSchema.getValueType().getType() != Schema.Type.RECORD ? AvroUtils.dereferenceLeaf(unionSchema.getValueType(), namespaces) : AvroUtils.buildDereferencedSchema(unionSchema.getValueType(), namespaces);
                                return Schema.createMap((Schema)unionMapSchema);
                            }
                        }
                        return unionSchema;
                    }).collect(Collectors.toList());
                    fieldAssembler.name(field.name()).type(Schema.createUnion(fullChild)).noDefault();
                    break;
                }
                case MAP: {
                    Schema mapSchema = fieldSchema.getValueType().getType() != Schema.Type.RECORD ? Schema.createMap((Schema)AvroUtils.dereferenceLeaf(fieldSchema.getValueType(), namespaces)) : Schema.createMap((Schema)AvroUtils.buildDereferencedSchema(fieldSchema.getValueType(), namespaces));
                    fieldAssembler.name(field.name()).type(mapSchema).noDefault();
                    break;
                }
                case ENUM: {
                    String enumNamespace = fieldSchema.getNamespace();
                    if (namespaces.containsKey(fieldSchema.getFullName())) {
                        enumNamespace = enumNamespace + "." + namespaces.get(fieldSchema.getFullName());
                        namespaces.put(fieldSchema.getFullName(), AvroUtils.nextNamespaceSuffix(namespaces.get(fieldSchema.getFullName())));
                    }
                    fieldAssembler.name(field.name()).type(Schema.createEnum((String)field.name(), (String)field.doc(), (String)enumNamespace, (List)field.schema().getEnumSymbols())).noDefault();
                    break;
                }
                case FIXED: 
                case STRING: 
                case BYTES: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case NULL: {
                    fieldAssembler.name(field.name()).type(field.schema()).noDefault();
                }
            }
        }
        return (Schema)fieldAssembler.endRecord();
    }

    private static Schema dereferenceLeaf(Schema fieldSchema, Map<String, String> namespaces) {
        switch (fieldSchema.getType()) {
            case RECORD: {
                return AvroUtils.buildDereferencedSchema(fieldSchema, namespaces);
            }
            case ARRAY: {
                return Schema.createArray((Schema)AvroUtils.dereferenceLeaf(fieldSchema.getElementType(), namespaces));
            }
            case ENUM: {
                String enumNamespace = fieldSchema.getNamespace();
                if (namespaces.containsKey(fieldSchema.getFullName())) {
                    enumNamespace = enumNamespace + "." + namespaces.get(fieldSchema.getFullName());
                    namespaces.put(fieldSchema.getFullName(), AvroUtils.nextNamespaceSuffix(namespaces.get(fieldSchema.getFullName())));
                }
                return Schema.createEnum((String)fieldSchema.getName(), (String)fieldSchema.getDoc(), (String)enumNamespace, (List)fieldSchema.getEnumSymbols());
            }
        }
        return fieldSchema;
    }

    private static String nextNamespaceSuffix(String suffix) {
        return AvroUtils.encode(AvroUtils.decode(suffix) + 1L);
    }

    private static long decode(String input) {
        long value = 0L;
        long multiplier = 1L;
        for (char c : input.toCharArray()) {
            value += (long)(c - 97) * multiplier;
            multiplier *= 26L;
        }
        return value;
    }

    private static String encode(long value) {
        long divide;
        StringBuilder output = new StringBuilder();
        do {
            divide = value / 26L;
            long remaining = value % 26L;
            output.append((char)(97L + remaining));
        } while ((value = divide) != 0L);
        return output.toString();
    }

    public static Schema cleanSchema(Schema schema, List<String> propsToAvoid) {
        if (schema != null) {
            switch (schema.getType()) {
                case RECORD: {
                    ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                    for (Schema.Field field : schema.getFields()) {
                        Schema fieldSchema = AvroUtils.cleanSchema(field.schema(), propsToAvoid);
                        Schema.Field newField = new Schema.Field(field.name(), fieldSchema, field.doc(), field.defaultVal());
                        AvroUtils.addFieldProps(field, newField);
                        fields.add(newField);
                    }
                    Schema recordSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), fields);
                    AvroUtils.addPropsToSchema(recordSchema, schema.getObjectProps(), propsToAvoid);
                    return recordSchema;
                }
                case MAP: {
                    Schema mapSchema = Schema.createMap((Schema)AvroUtils.cleanSchema(schema.getValueType(), propsToAvoid));
                    AvroUtils.addPropsToSchema(mapSchema, schema.getObjectProps(), propsToAvoid);
                    return mapSchema;
                }
                case ARRAY: {
                    Schema arraySchema = Schema.createArray((Schema)AvroUtils.cleanSchema(schema.getElementType(), propsToAvoid));
                    AvroUtils.addPropsToSchema(arraySchema, schema.getObjectProps(), propsToAvoid);
                    return arraySchema;
                }
                case UNION: {
                    ArrayList<Schema> types = new ArrayList<Schema>();
                    for (Schema unionType : schema.getTypes()) {
                        Schema unionTypeSchema = AvroUtils.cleanSchema(unionType, propsToAvoid);
                        types.add(unionTypeSchema);
                    }
                    Schema unionSchema = Schema.createUnion(types);
                    AvroUtils.addPropsToSchema(unionSchema, schema.getObjectProps(), propsToAvoid);
                    return unionSchema;
                }
                case ENUM: {
                    Schema enumSchema = Schema.createEnum((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (List)schema.getEnumSymbols());
                    AvroUtils.addPropsToSchema(enumSchema, schema.getObjectProps(), propsToAvoid);
                    return enumSchema;
                }
                case FIXED: {
                    Schema fixedSchema = Schema.createFixed((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (int)schema.getFixedSize());
                    AvroUtils.addPropsToSchema(fixedSchema, schema.getObjectProps(), propsToAvoid);
                    return fixedSchema;
                }
                case STRING: 
                case BYTES: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case NULL: {
                    Schema primitiveSchema = Schema.create((Schema.Type)schema.getType());
                    AvroUtils.addPropsToSchema(primitiveSchema, schema.getObjectProps(), propsToAvoid);
                    return primitiveSchema;
                }
            }
        }
        return null;
    }

    private static void addPropsToSchema(Schema destinationSchema, Map<String, Object> propsToCopy, List<String> propsToAvoid) {
        propsToCopy.forEach((k, v) -> {
            if (!propsToAvoid.contains(k)) {
                destinationSchema.addProp(k, v);
            }
        });
    }

    private static void addFieldProps(Schema.Field source, Schema.Field dest) {
        for (Map.Entry props : source.getObjectProps().entrySet()) {
            dest.addProp((String)props.getKey(), props.getValue());
        }
    }
}

