/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.datetime;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimePatternCheckerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimePatternCheckerUtils.class);
    private static final Set<String> dateTimePattens;
    private static final Set<String> datePattens;
    private static final Set<String> timePattens;

    public static boolean isValidDatePattern(String pattern) {
        return datePattens.contains(pattern);
    }

    public static boolean isValidTimePattern(String pattern) {
        return timePattens.contains(pattern);
    }

    public static boolean isValidDateTimePattern(String pattern) {
        return dateTimePattens.contains(pattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> readDateTimeFormats(String resourceName) {
        try (InputStream inputStream = Objects.requireNonNull(DateTimePatternCheckerUtils.class.getResourceAsStream(resourceName));){
            Set<String> set = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).stream().map(line -> line.split("\t")[1]).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static boolean isDateOnlyPattern(String pattern) {
        return !pattern.contains("h") && !pattern.contains("H");
    }

    private static boolean isDateTimeOnlyPattern(String pattern) {
        return !DateTimePatternCheckerUtils.isDateOnlyPattern(pattern);
    }

    static {
        Set<String> dateAndDateTimePattens = DateTimePatternCheckerUtils.readDateTimeFormats("DateFormats.txt");
        datePattens = dateAndDateTimePattens.stream().filter(DateTimePatternCheckerUtils::isDateOnlyPattern).collect(Collectors.toSet());
        dateTimePattens = dateAndDateTimePattens.stream().filter(DateTimePatternCheckerUtils::isDateTimeOnlyPattern).collect(Collectors.toSet());
        timePattens = DateTimePatternCheckerUtils.readDateTimeFormats("TimeFormats.txt");
        LOGGER.debug("{} patterns have been registered for Date type", (Object)datePattens.size());
        LOGGER.debug("{} patterns have been registered for Time type", (Object)timePattens.size());
        LOGGER.debug("{} patterns have been registered for DateTime type", (Object)dateTimePattens.size());
    }
}

