/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.datetime;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormatSymbols;
import java.time.ZoneId;
import java.time.chrono.JapaneseEra;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.statistics.datetime.ChronologyParameterManager;
import org.talend.dataquality.statistics.type.SortedList;

public class SystemDateTimePatternManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemDateTimePatternManager.class);
    private static final String[] SUPPORTED_ISO_LANGUAGES = new String[]{"ar", "be", "bg", "ca", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "ga", "iw", "hr", "hu", "in", "in", "is", "it", "iw", "ja", "ko", "lt", "lv", "mk", "ms", "mt", "nb", "nl", "nn", "no", "pl", "pt", "ro", "ru", "sk", "sl", "sq", "sr", "sv", "th", "tr", "uk", "vi", "zh"};
    private static final List<Map<Pattern, String>> DATE_PATTERN_GROUP_LIST = new ArrayList<Map<Pattern, String>>();
    private static final String MONTHS = "MONTHS";
    private static final String SHORT_MONTHS = "SHORT_MONTHS";
    private static final String WEEKDAYS = "WEEKDAYS";
    private static final String SHORT_WEEKDAYS = "SHORT_WEEKDAYS";
    private static final String AM_PM = "AM_PM";
    private static final String ERAS = "ERAS";
    private static final String TIMEZONES = "TIMEZONES";
    private static final Map<String, Map<String, Set<Locale>>> WORD_GROUPS_TO_LANGUAGES_DATES_WORDS = new HashMap<String, Map<String, Set<Locale>>>();
    private static final Map<String, List<String>> PATTERN_TO_WORD_GROUPS = new HashMap<String, List<String>>();
    private static final List<Map<Pattern, String>> TIME_PATTERN_GROUP_LIST = new ArrayList<Map<Pattern, String>>();
    private static final Map<String, DateTimeFormatter> dateTimeFormatterCache = new HashMap<String, DateTimeFormatter>();
    private static final String PATTERN_SUFFIX_ERA = "G";
    private static final Pattern PATTERN_FILTER_DATE = Pattern.compile("[ \\-]\\d|\\d[./+W\\u5E74]\\d|^\\d{8}$");
    private static final Set<Locale> LOCALES = SystemDateTimePatternManager.getDistinctLanguagesLocales();

    public static String[] getSupportedIsoLanguages() {
        return SUPPORTED_ISO_LANGUAGES;
    }

    private static void loadLanguagesDatesWords() {
        Set<String> zoneIds = ZoneId.getAvailableZoneIds();
        for (Locale locale : LOCALES) {
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            SystemDateTimePatternManager.buildWordsToLocales(MONTHS, new HashSet<String>(Arrays.asList(dfs.getMonths())), locale);
            SystemDateTimePatternManager.buildWordsToLocales(SHORT_MONTHS, new HashSet<String>(Arrays.asList(dfs.getShortMonths())), locale);
            SystemDateTimePatternManager.buildWordsToLocales(WEEKDAYS, new HashSet<String>(Arrays.asList(dfs.getWeekdays())), locale);
            SystemDateTimePatternManager.buildWordsToLocales(SHORT_WEEKDAYS, new HashSet<String>(Arrays.asList(dfs.getShortWeekdays())), locale);
            SystemDateTimePatternManager.buildWordsToLocales(AM_PM, new HashSet<String>(Arrays.asList(dfs.getAmPmStrings())), locale);
            SystemDateTimePatternManager.buildWordsToLocales(ERAS, new HashSet<String>(Arrays.asList(dfs.getEras())), locale);
            try {
                Set<String> zoneStringSet = zoneIds.stream().flatMap(zoneId -> {
                    TimeZone tz = TimeZone.getTimeZone(zoneId);
                    return Stream.of(tz.getDisplayName(false, 0, locale), tz.getDisplayName(true, 0, locale));
                }).filter(tz -> !tz.startsWith("GMT") || tz.equals("GMT")).collect(Collectors.toSet());
                SystemDateTimePatternManager.buildWordsToLocales(TIMEZONES, zoneStringSet, locale);
            }
            catch (Exception e) {
                LOGGER.error("Error while loading languages dates words", (Throwable)e);
            }
        }
    }

    private static void loadErasInNonIsoChronologies() {
        Set<String> japaneseEraSet = Arrays.stream(JapaneseEra.values()).map(e -> e.getDisplayName(TextStyle.FULL, Locale.JAPANESE)).collect(Collectors.toSet());
        SystemDateTimePatternManager.buildWordsToLocales(ERAS, japaneseEraSet, Locale.JAPANESE);
        HashSet<String> mingoEraSet = new HashSet<String>(Arrays.asList("\u6c11\u570b", "\u6c11\u570b\u524d"));
        SystemDateTimePatternManager.buildWordsToLocales(ERAS, mingoEraSet, Locale.TRADITIONAL_CHINESE);
        Set<String> hijrahEraSet = Collections.singleton("\u0647\u0640");
        SystemDateTimePatternManager.buildWordsToLocales(ERAS, hijrahEraSet, Locale.forLanguageTag("ar"));
        HashSet<String> thaiBuddhistEraSet = new HashSet<String>(Arrays.asList("\u0e1e.\u0e28.", "\u0e1b\u0e35\u0e01\u0e48\u0e2d\u0e19\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e01\u0e32\u0e25\u0e17\u0e35\u0e48"));
        SystemDateTimePatternManager.buildWordsToLocales(ERAS, thaiBuddhistEraSet, Locale.forLanguageTag("th"));
    }

    private static void buildWordsToLocales(String wordGroup, Set<String> languagesWords, Locale currentLocale) {
        Map languagesDatesWords = WORD_GROUPS_TO_LANGUAGES_DATES_WORDS.computeIfAbsent(wordGroup, k -> new HashMap());
        for (String languageWord : languagesWords) {
            if (!StringUtils.isNotEmpty((CharSequence)languageWord)) continue;
            String lowerCaseLanguageWord = languageWord.toLowerCase();
            Set locales = languagesDatesWords.computeIfAbsent(lowerCaseLanguageWord, k -> new HashSet());
            locales.add(currentLocale);
        }
    }

    private static Set<Locale> getDistinctLanguagesLocales() {
        LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
        for (String lang : SUPPORTED_ISO_LANGUAGES) {
            locales.add(Locale.forLanguageTag(lang));
        }
        return locales;
    }

    private static void loadPatterns(String patternFileName, List<Map<Pattern, String>> patternParsers) {
        InputStream stream = SystemDateTimePatternManager.class.getResourceAsStream(patternFileName);
        try {
            List lines = IOUtils.readLines((InputStream)stream, (String)"UTF-8");
            LinkedHashMap<Pattern, String> currentGroupMap = new LinkedHashMap<Pattern, String>();
            patternParsers.add(currentGroupMap);
            for (String line : lines) {
                if ("".equals(line.trim())) continue;
                if (line.startsWith("--")) {
                    currentGroupMap = new LinkedHashMap();
                    patternParsers.add(currentGroupMap);
                    continue;
                }
                String[] lineArray = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)line, (String)"\t");
                String format = lineArray[0];
                Pattern pattern = Pattern.compile(lineArray[1]);
                currentGroupMap.put(pattern, format);
                SystemDateTimePatternManager.loadPatternToLanguagesDatesWords(format);
            }
            stream.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void loadPatternToLanguagesDatesWords(String format) {
        ArrayList<String> languagesWordsList = new ArrayList<String>();
        if (format.contains("MMMM")) {
            languagesWordsList.add(MONTHS);
        } else if (format.contains("MMM")) {
            languagesWordsList.add(SHORT_MONTHS);
        }
        if (format.contains("EEEE")) {
            languagesWordsList.add(WEEKDAYS);
        } else if (format.contains("EEE")) {
            languagesWordsList.add(SHORT_WEEKDAYS);
        }
        if (format.contains(PATTERN_SUFFIX_ERA)) {
            languagesWordsList.add(ERAS);
        }
        if (format.contains("a")) {
            languagesWordsList.add(AM_PM);
        }
        if (format.contains("z")) {
            languagesWordsList.add(TIMEZONES);
        }
        PATTERN_TO_WORD_GROUPS.put(format, languagesWordsList);
    }

    public static boolean isDate(String value) {
        if (SystemDateTimePatternManager.checkDatesPreconditions(value)) {
            return SystemDateTimePatternManager.findOneDateTimePattern(DATE_PATTERN_GROUP_LIST, value).isPresent();
        }
        return false;
    }

    private static Optional<Pair<Pattern, DateTimeFormatter>> findOneDatePattern(String value) {
        if (SystemDateTimePatternManager.checkDatesPreconditions(value)) {
            return SystemDateTimePatternManager.findOneDateTimePattern(DATE_PATTERN_GROUP_LIST, value);
        }
        return Optional.empty();
    }

    public static boolean isTime(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) && value.length() >= 4 && value.length() <= 24 && SystemDateTimePatternManager.checkEnoughDigits(value) && SystemDateTimePatternManager.findOneDateTimePattern(TIME_PATTERN_GROUP_LIST, value).isPresent();
    }

    private static boolean checkDatesPreconditions(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) && value.length() >= 6 && value.length() <= 64 && PATTERN_FILTER_DATE.matcher(value).find() && SystemDateTimePatternManager.checkEnoughDigits(value);
    }

    private static boolean checkEnoughDigits(String value) {
        int digitCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch < '0' || ch > '9' || ++digitCount <= 2) continue;
            return true;
        }
        return false;
    }

    private static Optional<Pair<Pattern, DateTimeFormatter>> findOneDateTimePattern(List<Map<Pattern, String>> patternGroupList, String value) {
        for (Map<Pattern, String> patternMap : patternGroupList) {
            boolean isFoundRegex = false;
            for (Map.Entry<Pattern, String> entry : patternMap.entrySet()) {
                Matcher matcher = entry.getKey().matcher(value);
                if (!matcher.find()) continue;
                isFoundRegex = true;
                Optional<DateTimeFormatter> dateTimeFormatter = SystemDateTimePatternManager.validateWithPatternInAnyLocale(value, entry.getValue(), matcher);
                if (!dateTimeFormatter.isPresent()) continue;
                return Optional.of(Pair.of((Object)entry.getKey(), (Object)dateTimeFormatter.get()));
            }
            if (!isFoundRegex) continue;
            break;
        }
        return Optional.empty();
    }

    public static Map<String, Locale> getDatePatterns(String value) {
        return SystemDateTimePatternManager.getDateTimePatterns(DATE_PATTERN_GROUP_LIST, value, new SortedList<Map<Pattern, String>>());
    }

    public static Map<String, Locale> getDatePatterns(String value, SortedList<Map<Pattern, String>> frequentDatePatternsCache) {
        return SystemDateTimePatternManager.getDateTimePatterns(DATE_PATTERN_GROUP_LIST, value, frequentDatePatternsCache);
    }

    public static Map<String, Locale> getTimePatterns(String value) {
        return SystemDateTimePatternManager.getDateTimePatterns(TIME_PATTERN_GROUP_LIST, value, new SortedList<Map<Pattern, String>>());
    }

    private static Map<String, Locale> getDateTimePatterns(List<Map<Pattern, String>> patternGroupList, String value, SortedList<Map<Pattern, String>> frequentDatePatternsCache) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.singletonMap("", null);
        }
        Optional<Map<String, Locale>> foundFrequentDatePatterns = SystemDateTimePatternManager.findValueInFrequentDatePatternsCache(value, frequentDatePatternsCache);
        if (foundFrequentDatePatterns.isPresent()) {
            return foundFrequentDatePatterns.get();
        }
        HashMap<String, Locale> resultMap = new HashMap<String, Locale>();
        if (CollectionUtils.isNotEmpty(patternGroupList)) {
            for (Map<Pattern, String> patternMap : patternGroupList) {
                if (!SystemDateTimePatternManager.isFoundRegex(value, patternMap, resultMap)) continue;
                frequentDatePatternsCache.add(patternMap);
                return resultMap;
            }
        }
        return resultMap;
    }

    private static Optional<Map<String, Locale>> findValueInFrequentDatePatternsCache(String value, SortedList<Map<Pattern, String>> frequentDatePatternsCache) {
        if (frequentDatePatternsCache.size() > 0) {
            HashMap<String, Locale> resultMap = new HashMap<String, Locale>();
            for (int j = 0; j < frequentDatePatternsCache.size(); ++j) {
                Map<Pattern, String> cachedPattern = frequentDatePatternsCache.get(j);
                if (!SystemDateTimePatternManager.isFoundRegex(value, cachedPattern, resultMap)) continue;
                frequentDatePatternsCache.increment(j);
                return Optional.of(resultMap);
            }
        }
        return Optional.empty();
    }

    private static boolean isFoundRegex(String value, Map<Pattern, String> groupPattern, Map<String, Locale> resultMap) {
        boolean isFoundRegex = false;
        for (Map.Entry<Pattern, String> entry : groupPattern.entrySet()) {
            Matcher matcher = entry.getKey().matcher(value);
            if (!matcher.find()) continue;
            isFoundRegex = true;
            SystemDateTimePatternManager.validateWithPatternInAnyLocale(value, entry.getValue(), matcher).ifPresent(opt -> resultMap.put((String)entry.getValue(), opt.getLocale()));
        }
        return isFoundRegex;
    }

    public static DateTimeFormatter getDateTimeFormatterByPattern(String customPattern, Locale locale) {
        if (locale == null || StringUtils.isEmpty((CharSequence)customPattern)) {
            return null;
        }
        String localeStr = locale.toString();
        DateTimeFormatter formatter = dateTimeFormatterCache.get(customPattern + localeStr);
        if (formatter == null) {
            try {
                if (customPattern.contains(PATTERN_SUFFIX_ERA)) {
                    formatter = ChronologyParameterManager.getDateTimeFormatterWithChronology(customPattern, locale);
                } else {
                    String customPatternStrict = customPattern.replace('y', 'u');
                    formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(customPatternStrict).toFormatter(locale).withResolverStyle(ResolverStyle.STRICT);
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                return null;
            }
            dateTimeFormatterCache.put(customPattern + localeStr, formatter);
        }
        return formatter;
    }

    private static boolean isMatchDateTimePattern(String value, DateTimeFormatter formatter) {
        if (formatter != null) {
            try {
                TemporalAccessor temporal = formatter.parse(value);
                if (temporal.query(TemporalQueries.localDate()) != null || temporal.query(TemporalQueries.localTime()) != null) {
                    return true;
                }
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isDate(String value, SortedList<Pair<Pattern, DateTimeFormatter>> orderedPatterns) {
        for (int j = 0; j < orderedPatterns.size(); ++j) {
            Pair<Pattern, DateTimeFormatter> cachedPattern = orderedPatterns.get(j);
            if (!((Pattern)cachedPattern.getLeft()).matcher(value).find() || !SystemDateTimePatternManager.isMatchDateTimePattern(value, (DateTimeFormatter)cachedPattern.getRight())) continue;
            orderedPatterns.increment(j);
            return true;
        }
        Optional<Pair<Pattern, DateTimeFormatter>> foundPattern = SystemDateTimePatternManager.findOneDatePattern(value);
        foundPattern.ifPresent(orderedPatterns::add);
        return foundPattern.isPresent();
    }

    public static Set<String> getDatePatterns() {
        HashSet<String> patterns = new HashSet<String>();
        for (Map<Pattern, String> datePatternGroup : DATE_PATTERN_GROUP_LIST) {
            patterns.addAll(datePatternGroup.values());
        }
        return patterns;
    }

    public static boolean isMatchDateTimePattern(String value, String pattern, Locale locale) {
        return SystemDateTimePatternManager.findDateTimeFormatter(value, pattern, locale).isPresent();
    }

    @Deprecated
    public static boolean isMatchDateTimePattern(String value, String pattern) {
        return SystemDateTimePatternManager.findDateTimeFormatter(value, pattern, LOCALES).isPresent();
    }

    private static Optional<DateTimeFormatter> findDateTimeFormatter(String value, String pattern, Set<Locale> locales) {
        for (Locale locale : locales) {
            Optional<DateTimeFormatter> dateTimeFormatter = SystemDateTimePatternManager.findDateTimeFormatter(value, pattern, locale);
            if (!dateTimeFormatter.isPresent()) continue;
            return dateTimeFormatter;
        }
        return Optional.empty();
    }

    private static Optional<DateTimeFormatter> validateWithPatternInAnyLocale(String value, String pattern, Matcher matcher) {
        List<String> wordGroups = PATTERN_TO_WORD_GROUPS.get(pattern);
        if (CollectionUtils.isNotEmpty(wordGroups)) {
            if (matcher.groupCount() == wordGroups.size()) {
                List<Map<String, Set<Locale>>> languagesDatesWords = wordGroups.stream().map(WORD_GROUPS_TO_LANGUAGES_DATES_WORDS::get).collect(Collectors.toList());
                Set<Locale> locales = SystemDateTimePatternManager.findLocales(languagesDatesWords, matcher);
                if (CollectionUtils.isNotEmpty(locales)) {
                    return SystemDateTimePatternManager.findDateTimeFormatter(value, pattern, locales);
                }
            }
        } else {
            return SystemDateTimePatternManager.findDateTimeFormatter(value, pattern);
        }
        return Optional.empty();
    }

    private static Set<Locale> findLocales(List<Map<String, Set<Locale>>> wordToLocalList, Matcher matcher) {
        int groupIndex = 1;
        HashSet<Locale> locales = new HashSet<Locale>();
        while (groupIndex <= matcher.groupCount()) {
            Set<Locale> tmpLocales = null;
            String group = matcher.group(groupIndex++).toLowerCase();
            for (Map<String, Set<Locale>> wordToLocal : wordToLocalList) {
                tmpLocales = wordToLocal.get(group);
                if (tmpLocales == null) continue;
                if (CollectionUtils.isEmpty(locales)) {
                    locales.addAll(tmpLocales);
                    break;
                }
                locales.retainAll(tmpLocales);
                break;
            }
            if (!CollectionUtils.isEmpty(tmpLocales) && !CollectionUtils.isEmpty(locales)) continue;
            return Collections.emptySet();
        }
        return locales;
    }

    private static Optional<DateTimeFormatter> findDateTimeFormatter(String value, String pattern, Locale locale) {
        DateTimeFormatter dateTimeFormatterByPattern = SystemDateTimePatternManager.getDateTimeFormatterByPattern(pattern, locale);
        if (SystemDateTimePatternManager.isMatchDateTimePattern(value, dateTimeFormatterByPattern)) {
            return Optional.of(dateTimeFormatterByPattern);
        }
        return Optional.empty();
    }

    private static Optional<DateTimeFormatter> findDateTimeFormatter(String value, String pattern) {
        return SystemDateTimePatternManager.findDateTimeFormatter(value, pattern, Locale.getDefault());
    }

    static {
        SystemDateTimePatternManager.loadLanguagesDatesWords();
        SystemDateTimePatternManager.loadErasInNonIsoChronologies();
        SystemDateTimePatternManager.loadPatterns("DateRegexesGrouped.txt", DATE_PATTERN_GROUP_LIST);
        SystemDateTimePatternManager.loadPatterns("TimeRegexes.txt", TIME_PATTERN_GROUP_LIST);
    }
}

