/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.frequency.recognition;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.talend.dataquality.statistics.frequency.recognition.AbstractPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.RecognitionResult;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class LatinExtendedCharPatternRecognizer
extends AbstractPatternRecognizer {
    public static final String CHARS_TO_REPLACE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df0123456789";
    public static final String REPLACEMENT_CHARS = "aaaaaaaaaaaaaaaaaaaaaaaaaaAAAAAAAAAAAAAAAAAAAAAAAAAAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA9999999999";
    private Pattern charsPattern = Pattern.compile("[a-z|A-Z|\u00e0-\u00ff|\u00c0-\u00df]");

    @Override
    public RecognitionResult recognize(String stringToRecognize, DataTypeEnum type) {
        RecognitionResult result = new RecognitionResult();
        if (StringUtils.isEmpty((CharSequence)stringToRecognize)) {
            result.setResult(Collections.singleton(stringToRecognize), false);
            return result;
        }
        boolean isComplete = true;
        StringBuilder sb = new StringBuilder();
        int n = stringToRecognize.length();
        for (int i = 0; i < n; ++i) {
            char c = stringToRecognize.charAt(i);
            int pos = CHARS_TO_REPLACE.indexOf(c);
            if (pos > -1) {
                sb.append(REPLACEMENT_CHARS.charAt(pos));
                continue;
            }
            sb.append(c);
            isComplete = false;
        }
        result.setResult(Collections.singleton(sb.toString()), isComplete);
        return result;
    }

    public boolean containsAlphabetic(String patternString) {
        return this.charsPattern.matcher(patternString).find();
    }

    @Override
    public Set<String> getValuePattern(String originalValue) {
        RecognitionResult result = this.recognize(originalValue);
        return result.getPatternStringSet();
    }
}

