/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.frequency.recognition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.frequency.recognition.AbstractPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.DateTimePatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.EmptyPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.GenericCharPatternRecognizer;
import org.talend.dataquality.statistics.frequency.recognition.WordPatternRecognizer;

public class PatternMatcher {
    private static List<AbstractPatternRecognizer> patternRecognizerList = new ArrayList<AbstractPatternRecognizer>();
    private static Set<String> datePatterns;

    private PatternMatcher() {
    }

    public static boolean matchCharDatePattern(String value, String pattern) {
        if (value == null) {
            return false;
        }
        HashSet<String> patterns = new HashSet<String>();
        for (AbstractPatternRecognizer patternRecognizer : patternRecognizerList) {
            patterns.addAll(patternRecognizer.getValuePattern(value));
        }
        if (!PatternMatcher.isDatePattern(pattern) && PatternMatcher.containsDatePattern(patterns)) {
            return false;
        }
        return patterns.contains(pattern);
    }

    private static boolean containsDatePattern(Set<String> patterns) {
        for (String pattern : patterns) {
            if (!datePatterns.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDatePattern(String pattern) {
        return datePatterns.contains(pattern);
    }

    public static boolean matchWordPattern(String value, String pattern) {
        return PatternMatcher.matchWordPattern(value, pattern, true);
    }

    public static boolean matchWordPattern(String value, String pattern, boolean caseSensitive) {
        if (value == null) {
            return false;
        }
        Set<String> patterns = PatternMatcher.getPatterns(caseSensitive, value);
        return patterns.contains(pattern);
    }

    private static Set<String> getPatterns(boolean caseSensitive, String value) {
        if (caseSensitive) {
            return WordPatternRecognizer.withCase().getValuePattern(value);
        }
        return WordPatternRecognizer.noCase().getValuePattern(value);
    }

    static {
        patternRecognizerList.add(new EmptyPatternRecognizer());
        patternRecognizerList.add(new DateTimePatternRecognizer());
        patternRecognizerList.add(new GenericCharPatternRecognizer());
        datePatterns = SystemDateTimePatternManager.getDatePatterns();
    }
}

