/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric;

import java.util.ArrayList;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public abstract class NumericalStatisticsAnalyzer<T>
implements Analyzer<T> {
    private static final long serialVersionUID = 5444082810385180383L;
    private Integer[] statColIdx;
    private DataTypeEnum[] types;

    public NumericalStatisticsAnalyzer(DataTypeEnum[] types) {
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("types are required to compute numerical statistics.");
        }
        this.setTypes(types);
    }

    public void init() {
        this.setStatColIdx();
    }

    public DataTypeEnum[] getTypes() {
        return this.types;
    }

    private void setTypes(DataTypeEnum[] types) {
        this.types = types;
        if (types == null) {
            this.statColIdx = null;
        } else {
            this.setStatColIdx();
        }
    }

    public Integer[] getStatColIdx() {
        return this.statColIdx;
    }

    private void setStatColIdx() {
        ArrayList<Integer> statIdxList = new ArrayList<Integer>();
        for (int idCol = 0; idCol < this.types.length; ++idCol) {
            if (!this.types[idCol].equals((Object)DataTypeEnum.INTEGER) && !this.types[idCol].equals((Object)DataTypeEnum.DOUBLE)) continue;
            statIdxList.add(idCol);
        }
        this.statColIdx = statIdxList.toArray(new Integer[statIdxList.size()]);
    }

    public void close() throws Exception {
    }
}

