/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.numeric.quantile;

import java.util.List;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.numeric.NumericalStatisticsAnalyzer;
import org.talend.dataquality.statistics.numeric.quantile.TDigestQuantileStatistics;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class TDigestAnalyzer
extends NumericalStatisticsAnalyzer<TDigestQuantileStatistics> {
    private static final long serialVersionUID = -9176043422228459277L;
    private final ResizableList<TDigestQuantileStatistics> stats = new ResizableList(TDigestQuantileStatistics::new);
    private Integer[] compression = null;
    private boolean isDigestInited = false;

    public TDigestAnalyzer(DataTypeEnum[] types) {
        super(types);
    }

    @Override
    public void init() {
        super.init();
        this.stats.clear();
    }

    public void init(Integer[] compression) {
        this.compression = compression;
        this.isDigestInited = false;
    }

    public boolean analyze(String ... record) {
        DataTypeEnum[] types = this.getTypes();
        if (record.length != types.length) {
            throw new IllegalArgumentException("Each column of the record should be declared a DataType.Type corresponding! \n" + types.length + " type(s) declared in this T-Digest analyzer but " + record.length + " column(s) was found in this record. \nUsing method: setTypes(DataType.Type[] types) to set the types.");
        }
        this.stats.resize(record.length);
        Integer[] integerArray = this.getStatColIdx();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            if (!TypeInferenceUtils.isValid(types[idx], record[idx])) continue;
            TDigestQuantileStatistics stat = (TDigestQuantileStatistics)this.stats.get(idx);
            if (this.compression != null && !this.isDigestInited) {
                stat.initTDigest(this.compression[idx]);
            }
            try {
                stat.add(BigDecimalParser.toBigDecimal((String)record[idx]).doubleValue());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!this.isDigestInited) {
            this.isDigestInited = true;
        }
        return true;
    }

    public void end() {
    }

    public List<TDigestQuantileStatistics> getResult() {
        return this.stats;
    }
}

