/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.quality;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.talend.dataquality.common.inference.AvroQualityAnalyzer;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.common.util.AvroUtils;
import org.talend.dataquality.common.util.LFUCache;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.SortedList;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class AvroDataTypeQualityAnalyzer
extends AvroQualityAnalyzer {
    private static final long serialVersionUID = 6687921563928212180L;
    private final Map<String, LFUCache> knownDataTypeCaches = new HashMap<String, LFUCache>();
    private final Map<String, SortedList> frequentDatePatterns = new HashMap<String, SortedList>();

    public AvroDataTypeQualityAnalyzer(boolean isStoreInvalidValues) {
        this.isStoreInvalidValues = isStoreInvalidValues;
    }

    public AvroDataTypeQualityAnalyzer() {
        this(true);
    }

    public void init() {
        this.frequentDatePatterns.clear();
        this.qualityResults.clear();
        this.knownDataTypeCaches.clear();
    }

    public void init(Schema semanticSchema) {
        this.init();
        this.initResultSchema(semanticSchema);
    }

    private void initResultSchema(Schema semanticSchema) {
        this.inputSemanticSchema = semanticSchema;
        this.outputSemanticSchema = AvroUtils.copySchema((Schema)this.inputSemanticSchema);
        this.outputRecordSemanticSchema = AvroUtils.createRecordSemanticSchema((Schema)this.inputSemanticSchema, (Schema)QUALITY_VALUE_LEVEL_SCHEMA);
    }

    private void analyzeRecord(String id, IndexedRecord record, GenericRecord resultRecord, Schema recordSemanticSchema) {
        Schema schema = record.getSchema();
        for (Schema.Field field : schema.getFields()) {
            String itemId = AvroUtils.itemId((String)id, (String)field.name());
            Optional<Schema> maybeFieldResultSchema = Optional.ofNullable(resultRecord.getSchema().getField(field.name())).map(Schema.Field::schema);
            Optional<Schema> maybeFieldSemanticSchema = Optional.ofNullable(recordSemanticSchema.getField(field.name())).map(Schema.Field::schema);
            if (maybeFieldResultSchema.isPresent()) {
                if (maybeFieldSemanticSchema.isPresent()) {
                    Object semRecord = this.analyzeItem(itemId, record.get(field.pos()), field.schema(), maybeFieldResultSchema.get(), maybeFieldSemanticSchema.get());
                    resultRecord.put(field.name(), semRecord);
                    continue;
                }
                System.out.println(field.name() + " field is missing from semantic schema.");
                continue;
            }
            System.out.println(field.name() + " field is missing from result record schema.");
        }
    }

    private Object analyzeItem(String itemId, Object item, Schema itemSchema, Schema resultSchema, Schema semanticSchema) {
        switch (itemSchema.getType()) {
            case RECORD: {
                GenericData.Record resultRecord = new GenericData.Record(resultSchema);
                this.analyzeRecord(itemId, (IndexedRecord)((GenericRecord)item), (GenericRecord)resultRecord, semanticSchema);
                return resultRecord;
            }
            case ARRAY: {
                ArrayList<Object> resultArray = new ArrayList<Object>();
                for (Object obj : (List)item) {
                    resultArray.add(this.analyzeItem(itemId, obj, itemSchema.getElementType(), resultSchema.getElementType(), semanticSchema.getElementType()));
                }
                return new GenericData.Array(resultSchema, resultArray);
            }
            case MAP: {
                Map itemMap = (Map)item;
                HashMap resultMap = new HashMap();
                for (Map.Entry itemValue : itemMap.entrySet()) {
                    resultMap.put(itemValue.getKey(), this.analyzeItem(itemId, itemValue.getValue(), itemSchema.getValueType(), resultSchema.getValueType(), semanticSchema.getValueType()));
                }
                return resultMap;
            }
            case UNION: {
                int typeIdx = new GenericData().resolveUnion(itemSchema, item);
                List unionSchemas = itemSchema.getTypes();
                Schema realItemSchema = (Schema)unionSchemas.get(typeIdx);
                Schema realResultSchema = resultSchema.getTypes().stream().filter(type -> type.getName().equals(realItemSchema.getName())).findFirst().orElse(QUALITY_VALUE_LEVEL_SCHEMA);
                Schema realSemanticSchema = (Schema)semanticSchema.getTypes().get(typeIdx);
                return this.analyzeItem(AvroUtils.itemId((String)itemId, (String)realItemSchema.getName()), item, realItemSchema, realResultSchema, realSemanticSchema);
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                Optional<Map> maybeProps = Optional.ofNullable((Map)semanticSchema.getObjectProp("talend.component.dqType"));
                GenericData.Record semRecord = new GenericData.Record(QUALITY_VALUE_LEVEL_SCHEMA);
                String semanticType = maybeProps.map(props -> props.get("dataType").toString()).orElse(null);
                semRecord.put("validity", (Object)this.analyzeLeafValue(itemId, item, semanticType));
                return semRecord;
            }
            case NULL: {
                GenericData.Record nullSemRecord = new GenericData.Record(QUALITY_VALUE_LEVEL_SCHEMA);
                nullSemRecord.put("validity", (Object)this.analyzeLeafValue(itemId, item, null));
                return nullSemRecord;
            }
        }
        throw new IllegalStateException("Unexpected value: " + itemSchema.getType());
    }

    private int analyzeLeafValue(String id, Object objValue, String semanticType) {
        LFUCache knownDataTypeCache = (LFUCache)this.getOrCreate(id, this.knownDataTypeCaches, LFUCache.class);
        String value = objValue == null ? "" : objValue.toString();
        Boolean knownDataType = (Boolean)knownDataTypeCache.get((Object)value);
        ValueQualityStatistics valueQuality = (ValueQualityStatistics)this.getOrCreate(id, this.qualityResults, ValueQualityStatistics.class);
        if (!this.frequentDatePatterns.containsKey(id)) {
            this.frequentDatePatterns.put(id, new SortedList());
        }
        if (knownDataType != null) {
            if (knownDataType.booleanValue()) {
                valueQuality.incrementValid();
                return 1;
            }
            valueQuality.incrementInvalid();
            this.processInvalidValue(valueQuality, value);
            return -1;
        }
        if (TypeInferenceUtils.isNullOrEmpty(value)) {
            valueQuality.incrementEmpty();
            return 0;
        }
        if (semanticType == null) {
            valueQuality.incrementValid();
            return 1;
        }
        if (DataTypeEnum.DATE == DataTypeEnum.valueOf(semanticType) && SystemDateTimePatternManager.isDate(value, this.frequentDatePatterns.get(id))) {
            valueQuality.incrementValid();
            knownDataTypeCache.put((Object)value, (Object)Boolean.TRUE);
            return 1;
        }
        if (TypeInferenceUtils.isValid(DataTypeEnum.valueOf(semanticType), value)) {
            valueQuality.incrementValid();
            knownDataTypeCache.put((Object)value, (Object)Boolean.TRUE);
            return 1;
        }
        valueQuality.incrementInvalid();
        this.processInvalidValue(valueQuality, value);
        knownDataTypeCache.put((Object)value, (Object)Boolean.FALSE);
        return -1;
    }

    private void processInvalidValue(ValueQualityStatistics valueQuality, String invalidValue) {
        if (this.isStoreInvalidValues) {
            valueQuality.appendInvalidValue(invalidValue);
        }
    }

    public boolean analyze(IndexedRecord record) {
        this.analyzeRecord(record);
        return true;
    }

    public Stream<IndexedRecord> analyze(Stream<IndexedRecord> records) {
        return ((Stream)records.sequential()).map(this::analyzeRecord);
    }

    private IndexedRecord analyzeRecord(IndexedRecord record) {
        if (record == null) {
            return null;
        }
        if (this.inputSemanticSchema == null) {
            this.initResultSchema(record.getSchema());
        }
        GenericData.Record resultRecord = new GenericData.Record(this.outputRecordSemanticSchema);
        this.analyzeRecord("", record, (GenericRecord)resultRecord, this.inputSemanticSchema);
        return resultRecord;
    }
}

